/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.model;

import com.jrockit.mc.flightrecorder.spi.IEvent;
import com.jrockit.mc.flightrecorder.spi.IRange;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BrokenIterator
implements Iterator<IEvent> {
    private final Iterator<IEvent> m_iterator;
    private final long m_startTime;
    private final long m_endTime;
    private IEvent m_event;

    public BrokenIterator(List<IEvent> events, IRange range) {
        this.m_iterator = events.iterator();
        this.m_startTime = range.getStartTimestamp();
        this.m_endTime = range.getEndTimestamp();
        this.skipToNext();
    }

    void skipToNext() {
        while (this.m_iterator.hasNext()) {
            IEvent e = this.m_iterator.next();
            if (e.getStartTimestamp() < this.m_startTime || e.getEndTimestamp() > this.m_endTime) continue;
            this.m_event = e;
            return;
        }
        this.m_event = null;
    }

    @Override
    public boolean hasNext() {
        return this.m_event != null;
    }

    @Override
    public IEvent next() {
        IEvent event = this.m_event;
        this.skipToNext();
        return event;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("");
    }
}

