/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.input;

import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.input.IBinaryChunkInput;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.input.StreamInput;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.model.BinaryChunk;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ZipFileInput
implements IBinaryChunkInput {
    private ZipFile m_file;
    private Iterator<ZipEntry> m_zipEntryIterator;
    private StreamInput m_streamInput;

    public ZipFileInput(ZipFile file) {
        this.m_file = file;
        this.m_zipEntryIterator = this.sort(this.createEntriesList(this.m_file)).iterator();
    }

    private List<ZipEntry> sort(List<ZipEntry> list) {
        Collections.sort(list, new Comparator<ZipEntry>(){

            @Override
            public int compare(ZipEntry a, ZipEntry b) {
                return a.getName().compareTo(b.getName());
            }
        });
        return list;
    }

    private List<ZipEntry> createEntriesList(ZipFile zipFile) {
        ArrayList<ZipEntry> zipEntries = new ArrayList<ZipEntry>();
        Enumeration<? extends ZipEntry> ze = zipFile.entries();
        while (ze.hasMoreElements()) {
            zipEntries.add(ze.nextElement());
        }
        return zipEntries;
    }

    @Override
    public BinaryChunk nextChunk() throws IOException {
        if (this.m_zipEntryIterator != null) {
            return this.nextZipChunk();
        }
        throw new IOException("Input closed");
    }

    private BinaryChunk nextZipChunk() throws IOException {
        while (true) {
            BinaryChunk chunk;
            if (this.m_streamInput == null) {
                if (!this.m_zipEntryIterator.hasNext()) {
                    return null;
                }
                ZipEntry ze = this.m_zipEntryIterator.next();
                this.m_streamInput = new StreamInput(this.m_file.getInputStream(ze));
            }
            if ((chunk = this.m_streamInput.nextChunk()) != null) {
                return chunk;
            }
            this.m_streamInput.close();
            this.m_streamInput = null;
        }
    }

    @Override
    public void close() throws IOException {
        try {
            if (this.m_streamInput != null) {
                this.m_streamInput.close();
            }
        }
        finally {
            this.m_zipEntryIterator = null;
            this.m_streamInput = null;
            this.m_file.close();
        }
    }
}

