/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.input;

import java.util.LinkedList;
import java.util.Queue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class TerminatableQueue<T> {
    private final Object m_lock = new Object();
    private final Queue<T> m_queue = new LinkedList<T>();
    private final int m_capacity;
    private boolean m_terminated = false;

    TerminatableQueue(int capacity) {
        this.m_capacity = capacity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isTerminated() {
        Object object = this.m_lock;
        synchronized (object) {
            return this.m_terminated;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void terminate() {
        Object object = this.m_lock;
        synchronized (object) {
            this.m_terminated = true;
            this.m_queue.clear();
            this.m_lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void add(T t) {
        Object object = this.m_lock;
        synchronized (object) {
            while (true) {
                if (!this.isFull() || this.isTerminated()) {
                    if (this.isTerminated()) return;
                    this.m_queue.add(t);
                    this.m_lock.notifyAll();
                    return;
                }
                try {
                    this.m_lock.wait();
                }
                catch (InterruptedException e) {
                    this.terminate();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    T poll() {
        Object object = this.m_lock;
        synchronized (object) {
            while (true) {
                if (!this.m_queue.isEmpty() || this.isTerminated()) {
                    T t = this.m_queue.poll();
                    if (t == null) break;
                    this.m_lock.notifyAll();
                    return t;
                }
                try {
                    this.m_lock.wait();
                }
                catch (InterruptedException e) {
                    this.terminate();
                }
            }
            this.terminate();
            return null;
        }
    }

    private boolean isFull() {
        return this.m_queue.size() >= this.m_capacity;
    }
}

