/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.input;

import com.jrockit.mc.common.io.IOToolkit;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.input.IBinaryChunkInput;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.model.BinaryChunk;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.model.ChunkDescriptor;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.parsers.ChunkDescriptorParser;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.parsers.IntegerParser;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;

public class StreamInput
implements IBinaryChunkInput,
Closeable {
    private final byte[] m_chunkHeader;
    private final InputStream m_stream;
    private ChunkDescriptorParser m_chunkHeaderParser = new ChunkDescriptorParser();

    public StreamInput(InputStream stream) {
        this.m_stream = stream;
        this.m_chunkHeader = new byte[16];
    }

    boolean fillbytes(byte[] data, int offset, int count, String dataDescription, boolean allowZero) throws IOException {
        int totalRead = 0;
        while (totalRead < count) {
            int read = this.m_stream.read(data, offset + totalRead, count - totalRead);
            if (read == -1) {
                if (allowZero && totalRead == 0) {
                    return false;
                }
                throw new IOException("Unexpected end od data when reading " + dataDescription + ". Expected " + count + " bytes, but only found " + totalRead);
            }
            totalRead += read;
        }
        return true;
    }

    public final BinaryChunk nextChunk() throws IOException {
        if (this.fillbytes(this.m_chunkHeader, 0, this.m_chunkHeader.length, "flight recording chunk header", true)) {
            ChunkDescriptor chunkDescriptor = this.m_chunkHeaderParser.read(this.m_chunkHeader, 0);
            if (!chunkDescriptor.hasFlightRecorderMagic()) {
                throw new IOException("Not a flight recording file " + chunkDescriptor.getMagicString());
            }
            if (!chunkDescriptor.hasReasonableMetadataOffset()) {
                throw new IOException("Metadata offset to far away to process data in memory. " + chunkDescriptor.getMetadataOffset());
            }
            int metaDataOffset = (int)chunkDescriptor.getMetadataOffset();
            byte[] eventBuffer = new byte[metaDataOffset + 4];
            this.fillbytes(eventBuffer, 0, eventBuffer.length, "event data", false);
            int size = IntegerParser.readInt(eventBuffer, metaDataOffset) - 4;
            byte[] buffer = new byte[eventBuffer.length + size];
            System.arraycopy(eventBuffer, 0, buffer, 0, eventBuffer.length);
            this.fillbytes(buffer, eventBuffer.length, size, "event meta data", false);
            return new BinaryChunk(buffer, chunkDescriptor);
        }
        return null;
    }

    public void close() throws IOException {
        IOToolkit.closeSilently((Closeable)this.m_stream);
    }
}

