/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.input;

import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.input.IBinaryChunkInput;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.model.BinaryChunk;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.parsers.IntegerParser;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.parsers.LongParser;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;

public class SortedInput
implements IBinaryChunkInput {
    private final IBinaryChunkInput m_binaryInput;

    public SortedInput(IBinaryChunkInput cp) {
        this.m_binaryInput = cp;
    }

    public BinaryChunk nextChunk() throws IOException {
        BinaryChunk ch = this.m_binaryInput.nextChunk();
        if (ch != null) {
            this.buildIndex(ch);
        }
        return ch;
    }

    void buildIndex(BinaryChunk chunk) {
        byte[] data = chunk.getData();
        ArrayList<EventPosition> positions = new ArrayList<EventPosition>();
        int arrayIndex = 0;
        while (arrayIndex < data.length) {
            int size = IntegerParser.readInt(data, arrayIndex);
            long timeStamp = LongParser.readLong(data, arrayIndex + 8);
            positions.add(new EventPosition(arrayIndex, timeStamp));
            arrayIndex += size;
        }
        Collections.sort(positions);
        chunk.getDescriptor().setPositions(positions);
    }

    public void close() throws IOException {
        this.m_binaryInput.close();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class EventPosition
    implements Comparable<EventPosition> {
        public final long timeStamp;
        public final int index;

        public EventPosition(int index, long timeStamp) {
            this.timeStamp = timeStamp;
            this.index = index;
        }

        @Override
        public int compareTo(EventPosition o) {
            if (o.timeStamp < this.timeStamp) {
                return 1;
            }
            if (o.timeStamp == this.timeStamp) {
                return 0;
            }
            return -1;
        }
    }
}

