/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.input;

import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.input.StreamInput;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

public final class FileStreamInput
extends StreamInput {
    private final FileChannel m_fileChannel;

    FileStreamInput(FileInputStream fis) {
        super(fis);
        this.m_fileChannel = fis.getChannel();
    }

    boolean fillbytes(byte[] data, int offset, int count, String dataDescription, boolean allowZero) throws IOException {
        ByteBuffer buffer = ByteBuffer.wrap(data);
        buffer.position(offset);
        int totalRead = 0;
        while (buffer.position() < count) {
            int read = this.m_fileChannel.read(buffer);
            if (read == -1) {
                if (allowZero && totalRead == 0) {
                    return false;
                }
                throw new IOException("Unexpected end of data when reading " + dataDescription + ". Expected " + count + " bytes, but only found " + totalRead);
            }
            totalRead += read;
        }
        return true;
    }

    public void close() throws IOException {
        try {
            super.close();
        }
        finally {
            this.m_fileChannel.close();
        }
    }
}

