/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.input;

import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.input.IBinaryChunkInput;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.input.StreamInput;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.model.BinaryChunk;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FilePathInput
implements IBinaryChunkInput {
    private static final String JFR_FILE_EXTENSION = ".jfr";
    private Iterator<File> m_fileIterator;
    private StreamInput m_streamInput;

    FilePathInput(File directory) {
        this(directory, new JFRExtensionFilter());
    }

    FilePathInput(File directory, FilenameFilter filter) {
        if (!directory.isDirectory()) {
            throw new IllegalArgumentException("Must be directory");
        }
        this.m_fileIterator = this.sort(Arrays.asList(directory.listFiles(filter))).iterator();
    }

    private List<File> sort(List<File> list) {
        Collections.sort(list, new Comparator<File>(){

            @Override
            public int compare(File a, File b) {
                return a.getName().compareTo(b.getName());
            }
        });
        return list;
    }

    @Override
    public BinaryChunk nextChunk() throws IOException {
        if (this.m_fileIterator != null) {
            this.nextFileChunk();
        }
        throw new IOException("FilePathInput closed");
    }

    private BinaryChunk nextFileChunk() throws IOException {
        while (true) {
            BinaryChunk chunk;
            if (this.m_streamInput == null) {
                if (!this.m_fileIterator.hasNext()) {
                    return null;
                }
                File file = this.m_fileIterator.next();
                this.m_streamInput = new StreamInput(new FileInputStream(file));
            }
            if ((chunk = this.m_streamInput.nextChunk()) != null) {
                return chunk;
            }
            this.m_streamInput.close();
            this.m_streamInput = null;
        }
    }

    @Override
    public void close() throws IOException {
        this.m_fileIterator = null;
    }

    static class JFRExtensionFilter
    implements FilenameFilter {
        JFRExtensionFilter() {
        }

        public boolean accept(File dir, String name) {
            return !dir.isDirectory() && name.endsWith(FilePathInput.JFR_FILE_EXTENSION);
        }
    }
}

