/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.input;

import com.jrockit.mc.common.io.IOToolkit;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.input.FilePathInput;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.input.IBinaryChunkInput;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.input.StreamInput;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.input.ZipFileInput;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.model.BinaryChunk;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipFile;

public class FileInput
implements IBinaryChunkInput {
    private final File m_file;
    private IBinaryChunkInput m_input;

    public FileInput(File file) {
        this.m_file = file;
    }

    public void close() throws IOException {
        if (this.m_input != null) {
            this.m_input.close();
        }
    }

    public BinaryChunk nextChunk() throws IOException {
        this.ensureInput();
        return this.m_input.nextChunk();
    }

    private void ensureInput() throws IOException {
        if (this.m_input == null) {
            this.m_input = this.createInput(this.m_file);
        }
    }

    private IBinaryChunkInput createInput(File file) throws IOException {
        if (file.isDirectory()) {
            return new FilePathInput(file);
        }
        if (IOToolkit.isZipFile((File)file)) {
            return new ZipFileInput(new ZipFile(file));
        }
        if (IOToolkit.isGZipFile((File)file)) {
            return new StreamInput(new GZIPInputStream(new FileInputStream(file)));
        }
        return new StreamInput(new FileInputStream(file));
    }
}

