/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.input;

import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.input.IBinaryChunkInput;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.input.TerminatableQueue;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.model.BinaryChunk;
import java.io.IOException;

public final class BackgroundInput
implements IBinaryChunkInput {
    private final TerminatableQueue<BinaryChunk> m_queue;
    private final IBinaryChunkInput m_input;

    public BackgroundInput(IBinaryChunkInput input, int capacity) {
        this.m_queue = new TerminatableQueue(capacity);
        this.m_input = input;
        this.start();
    }

    void start() {
        new Thread(this.createReader()).start();
    }

    private Runnable createReader() {
        return new Runnable(){

            public void run() {
                BackgroundInput.this.read();
            }
        };
    }

    private void read() {
        while (!this.m_queue.isTerminated()) {
            try {
                this.m_queue.add(this.m_input.nextChunk());
            }
            catch (IOException e) {
                e.printStackTrace();
                this.m_queue.terminate();
            }
        }
    }

    void stop() {
        this.m_queue.terminate();
    }

    public BinaryChunk nextChunk() throws IOException {
        return this.m_queue.poll();
    }

    public void close() throws IOException {
        this.m_input.close();
        this.stop();
    }
}

