/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.internal.api.binary.jrockit;

import com.jrockit.mc.common.io.IOToolkit;
import com.jrockit.mc.flightrecorder.api.EventTypeRepository;
import com.jrockit.mc.flightrecorder.api.PrintStreamProgressMonitor;
import com.jrockit.mc.flightrecorder.api.ProgressMonitor;
import com.jrockit.mc.flightrecorder.api.Range;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.input.BackgroundInput;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.input.FileInput;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.input.IBinaryChunkInput;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.input.SortedInput;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.model.JRockitGlobalRepository;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.parsers.MainParser;
import com.jrockit.mc.flightrecorder.spi.IEvent;
import com.jrockit.mc.flightrecorder.spi.IEventProvider;
import com.jrockit.mc.flightrecorder.spi.IEventType;
import com.jrockit.mc.flightrecorder.spi.IEventTypeRepository;
import com.jrockit.mc.flightrecorder.spi.IRange;
import com.jrockit.mc.flightrecorder.spi.ITrack;
import com.jrockit.mc.flightrecorder.spi.ITrackRepository;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JRockitBinaryEventProvider
implements IEventProvider {
    private JRockitGlobalRepository m_repository = new JRockitGlobalRepository();
    private IEventTypeRepository m_eventTypeRepositor = new EventTypeRepository();
    private ProgressMonitor m_progressMonitor = new PrintStreamProgressMonitor();
    private Range m_range = new Range(System.currentTimeMillis() * 1000L * 1000L - 1000L, System.currentTimeMillis() * 1000L * 1000L + 1000L);
    private boolean m_initialized;
    private final IBinaryChunkInput m_input;

    public JRockitBinaryEventProvider(File file) {
        this.m_input = new BackgroundInput(new SortedInput(new BackgroundInput(new FileInput(file), 2)), 2);
        this.m_initialized = false;
    }

    @Override
    public IEventTypeRepository createEventTypeRepository() {
        this.initialize();
        return this.m_eventTypeRepositor;
    }

    @Override
    public Iterator<IEvent> createEventIterator() {
        this.initialize();
        return this.m_repository.createIterator(Range.INFINITE_RANGE);
    }

    @Override
    public IRange getRange() {
        this.initialize();
        return this.m_range;
    }

    @Override
    public void setProgressMonitor(ProgressMonitor monitor) {
        this.m_progressMonitor = monitor;
    }

    @Override
    public ITrackRepository getTrackRepository() {
        this.initialize();
        return this.m_repository;
    }

    @Override
    public void dispose() {
    }

    private void initialize() {
        if (!this.m_initialized) {
            this.m_initialized = true;
            try {
                try {
                    this.readFromInput();
                }
                catch (IOException e) {
                    this.m_progressMonitor.log(ProgressMonitor.SEVERITY.SEVERE, e.getMessage(), e);
                }
            }
            finally {
                if (this.m_input != null) {
                    IOToolkit.closeSilently((Closeable)this.m_input);
                }
            }
        }
    }

    private void readFromInput() throws IOException {
        MainParser mp = new MainParser(this.m_input);
        mp.read(this.m_progressMonitor);
        this.m_range = mp.getRange();
        this.m_eventTypeRepositor = mp.getEventTypeRepository();
        this.m_repository = (JRockitGlobalRepository)mp.getTrackRepository();
        this.initializeTracks();
    }

    private void initializeTracks() {
        for (IEventType type : this.m_eventTypeRepositor) {
            for (ITrack t : type.getTracks()) {
                t.iterator();
            }
        }
    }

    @Override
    public void flush() {
        this.m_eventTypeRepositor = new EventTypeRepository();
        this.m_repository = new JRockitGlobalRepository();
    }
}

