/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.api;

import com.jrockit.mc.flightrecorder.api.EventOrder;
import com.jrockit.mc.flightrecorder.api.Range;
import com.jrockit.mc.flightrecorder.api.RangeIterator;
import com.jrockit.mc.flightrecorder.api.RangeSelection;
import com.jrockit.mc.flightrecorder.internal.api.range.IPriorityProvider;
import com.jrockit.mc.flightrecorder.internal.api.range.PriorityIterator;
import com.jrockit.mc.flightrecorder.spi.IEventView;
import com.jrockit.mc.flightrecorder.spi.IRange;
import com.jrockit.mc.flightrecorder.spi.IRangeFilter;
import com.jrockit.mc.flightrecorder.spi.IRangeHolder;
import java.util.ArrayList;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class View
implements IEventView {
    private IRange m_range = Range.INFINITE_RANGE;
    private IRangeFilter m_filter = IRangeHolder.ALWAYS_TRUE_FILTER;
    private EventOrder m_eventOrder = EventOrder.DONT_CARE;
    private RangeSelection m_rangeSelection = RangeSelection.NORMAL;

    @Override
    public IRange getRange() {
        return this.m_range;
    }

    @Override
    public void setOrder(EventOrder order) {
        this.m_eventOrder = order;
    }

    @Override
    public void setFilter(IRangeFilter filter) {
        this.m_filter = filter;
    }

    @Override
    public void setRange(IRange range) {
        this.m_range = range;
    }

    @Override
    public Iterator iterator() {
        ArrayList<IRangeHolder> holders = this.createHolderList();
        switch (this.m_eventOrder) {
            case ORDER_BY_TIME_ASCENDING: {
                Iterator[] iterators = new Iterator[holders.size()];
                int n = 0;
                while (n < iterators.length) {
                    iterators[n] = holders.get(n).iterator(this.m_filter, this.m_range, this.m_rangeSelection);
                    ++n;
                }
                if (iterators.length == 1) {
                    return iterators[0];
                }
                return new PriorityIterator(iterators, IPriorityProvider.ORDER_BY_START_TIME);
            }
            case ORDER_BY_TRACK_ID: 
            case DONT_CARE: {
                if (holders.size() == 1) {
                    return holders.get(0).iterator(this.m_filter, this.m_range, this.m_rangeSelection);
                }
                return new RangeIterator(holders, this.m_range, this.m_filter, this.m_rangeSelection);
            }
        }
        throw new UnsupportedOperationException("Order " + (Object)((Object)this.m_eventOrder) + " currently not supported");
    }

    protected abstract ArrayList<IRangeHolder> createHolderList();

    @Override
    public IRangeFilter getFilter() {
        return this.m_filter;
    }

    @Override
    public EventOrder getOrder() {
        return this.m_eventOrder;
    }

    @Override
    public void setExpansion(RangeSelection expanded) {
        this.m_rangeSelection = expanded;
    }
}

