/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.api;

import com.jrockit.mc.flightrecorder.api.View;
import com.jrockit.mc.flightrecorder.spi.IRangeHolder;
import com.jrockit.mc.flightrecorder.spi.ITrack;
import com.jrockit.mc.flightrecorder.spi.ITrackDescriptor;
import com.jrockit.mc.flightrecorder.spi.ITrackRepository;
import com.jrockit.mc.flightrecorder.spi.ITrackView;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrackView
extends View
implements ITrackView {
    private final ITrackRepository m_repository;
    private Set<ITrackDescriptor> m_tracks = new HashSet<ITrackDescriptor>();

    public TrackView(ITrackRepository rep) {
        this.m_repository = rep;
    }

    @Override
    public void setTracks(Collection<ITrackDescriptor> tracks) {
        this.m_tracks = new HashSet<ITrackDescriptor>(tracks);
    }

    @Override
    public Collection<ITrackDescriptor> getTracks() {
        return this.m_tracks;
    }

    @Override
    protected ArrayList<IRangeHolder> createHolderList() {
        ArrayList<IRangeHolder> holders = new ArrayList<IRangeHolder>();
        for (ITrackDescriptor t : this.m_repository.getAllTrackDescriptors()) {
            if (!this.m_tracks.contains(t)) continue;
            ITrack track = this.m_repository.getTrack(t);
            holders.add(track.getRangeHolder());
        }
        return holders;
    }
}

