/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.api;

import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.model.ValueDescriptor;
import com.jrockit.mc.flightrecorder.spi.IEvent;
import com.jrockit.mc.flightrecorder.spi.IRetriever;

public abstract class Retriever
implements IRetriever {
    private final String m_path;
    private final ValueDescriptor m_descriptor;
    private final String m_identifier;

    public Retriever(ValueDescriptor descriptor, String path) {
        this.m_descriptor = descriptor;
        this.m_path = path;
        this.m_identifier = descriptor.getIdentifier();
    }

    public boolean isTextual() {
        return this.m_descriptor.getDataType().isTextual();
    }

    public boolean isNumeric() {
        return this.m_descriptor.getDataType().isNumeric();
    }

    public String getAttributeIdentifier() {
        return this.m_identifier;
    }

    public final String getDescription() {
        return this.m_descriptor.getDescription();
    }

    public boolean isVisible() {
        return true;
    }

    public String getName() {
        return this.m_descriptor.getName();
    }

    public abstract Object getValue(IEvent var1);

    public final boolean equals(Object object) {
        if (object instanceof IRetriever) {
            return ((IRetriever)object).getAttributeIdentifier().equals(this.getAttributeIdentifier());
        }
        return false;
    }

    public int hashCode() {
        return this.m_identifier.hashCode();
    }

    public final String getContentTypeString() {
        return this.m_descriptor.getContentTypeString();
    }

    public final String getEventTypePath() {
        return this.m_path;
    }

    public boolean isRelational() {
        return this.m_descriptor.getRelationalKey() != null && this.m_descriptor.getRelationalKey().length() > 0;
    }

    public boolean isSynthetic() {
        return false;
    }

    public String getRelationalKey() {
        return this.m_descriptor.getRelationalKey();
    }

    public String toString() {
        String toString = "";
        toString = String.valueOf(toString) + "Name:" + this.getName() + "\n";
        toString = String.valueOf(toString) + "Identifier:" + this.getAttributeIdentifier() + "\n";
        toString = String.valueOf(toString) + "Description:" + this.getDescription() + "\n";
        return toString;
    }
}

