/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.api;

import com.jrockit.mc.flightrecorder.api.RangeSelection;
import com.jrockit.mc.flightrecorder.internal.api.range.DisjointRangeHolder;
import com.jrockit.mc.flightrecorder.spi.IRange;
import com.jrockit.mc.flightrecorder.spi.IRangeFilter;
import com.jrockit.mc.flightrecorder.spi.IRangeHolder;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RangeIterator
implements Iterator<Object> {
    private final NullIterator NULL_ITERATOR = new NullIterator();
    private final IRange m_range;
    private final IRangeFilter m_filter;
    private Iterator<? extends Object> m_rangeCollectionsIterator;
    private Iterator<? extends Object> m_rangeItemIterator = new NullIterator();
    private IRangeHolder m_currentRangeHolder;
    private RangeSelection m_rangeSelection;

    public RangeIterator(Collection<? extends Object> rangeCollections, IRange range, IRangeFilter filter, RangeSelection rs) {
        for (DisjointRangeHolder disjointRangeHolder : rangeCollections) {
            disjointRangeHolder.iterator();
        }
        this.m_rangeCollectionsIterator = rangeCollections.iterator();
        this.m_range = range;
        this.m_filter = filter;
        this.m_rangeSelection = rs;
        this.internalNext();
    }

    public IRangeHolder getNextRangeHolder() {
        return this.m_currentRangeHolder;
    }

    @Override
    public boolean hasNext() {
        return this.m_rangeItemIterator.hasNext();
    }

    private void internalNext() {
        if (!this.m_rangeItemIterator.hasNext()) {
            while (this.m_rangeCollectionsIterator.hasNext()) {
                this.m_currentRangeHolder = (IRangeHolder)this.m_rangeCollectionsIterator.next();
                this.m_rangeItemIterator = this.m_currentRangeHolder.iterator(this.m_filter, this.m_range, this.m_rangeSelection);
                if (!this.m_rangeItemIterator.hasNext()) continue;
                return;
            }
            this.m_rangeItemIterator = this.NULL_ITERATOR;
        }
    }

    @Override
    public Object next() {
        Object object = this.m_rangeItemIterator.next();
        this.internalNext();
        return object;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Remove not supported");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class NullIterator
    implements Iterator<Object> {
        private NullIterator() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public Object next() {
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

