/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.api;

import com.jrockit.mc.flightrecorder.internal.api.range.RangeToolkit;
import com.jrockit.mc.flightrecorder.spi.IRange;

public final class Range
implements IRange {
    private final long m_startTimestamp;
    private final long m_endTimestamp;

    public Range(long start, long end) {
        assert (start <= end);
        this.m_startTimestamp = start;
        this.m_endTimestamp = end;
    }

    public String toString() {
        return RangeToolkit.formatRange(this);
    }

    public long getDuration() {
        return RangeToolkit.calculateDuration(this.m_startTimestamp, this.m_endTimestamp);
    }

    public long getEndTimestamp() {
        return this.m_endTimestamp;
    }

    public long getStartTimestamp() {
        return this.m_startTimestamp;
    }

    public long getDuration(IRange cropRange) {
        return RangeToolkit.cropRange(cropRange, this);
    }
}

