/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.api;

import com.jrockit.mc.flightrecorder.api.PathDescriptor;
import com.jrockit.mc.flightrecorder.api.PathDescriptorRepository;
import com.jrockit.mc.flightrecorder.spi.IEventType;
import com.jrockit.mc.flightrecorder.spi.IProducer;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Producer
implements IProducer {
    private List<IEventType> m_eventTypes = new ArrayList<IEventType>();
    private String m_description;
    private String m_name;
    private String m_namespace;
    private String m_uriString;
    private int m_identifier;
    private List<String> m_relations;
    private Object[] m_newEventTypes;
    private Runnable m_r;
    private Color m_color = Color.GREEN;

    public Producer(int pid) {
        this.m_identifier = pid;
    }

    public void setDescription(String description) {
        this.m_description = description;
    }

    @Override
    public String getDescription() {
        return this.m_description;
    }

    public void setEventTypes(List<IEventType> eventTypes) {
        this.m_eventTypes = eventTypes;
    }

    @Override
    public List<IEventType> getEventTypes() {
        return this.m_eventTypes;
    }

    public void setId(int identifier) {
        this.m_identifier = identifier;
    }

    @Override
    public int getId() {
        return this.m_identifier;
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public void setNamespace(String namespace) {
        this.m_namespace = namespace;
    }

    @Override
    public String getNamespace() {
        return this.m_namespace;
    }

    public void setURIString(String uriString) {
        if (uriString != null) {
            PathDescriptor pd = PathDescriptorRepository.getDefault().createPathDescriptor(uriString, null);
            this.m_color = pd.getColor();
        }
        this.m_uriString = uriString;
    }

    @Override
    public String getURIString() {
        return this.m_uriString;
    }

    public void setRelations(List<String> relations) {
        this.m_relations = relations;
    }

    public List<String> getRelations() {
        return this.m_relations;
    }

    public void addEventType(IEventType type) {
        this.m_eventTypes.add(type);
    }

    public void addNewEventTypes(Object[] eventTypes) {
        this.m_newEventTypes = eventTypes;
    }

    public Object[] getNewEventTypes() {
        return this.m_newEventTypes;
    }

    public Runnable getInitializationCallBack() {
        return this.m_r;
    }

    public void setInitializationCallback(Runnable r) {
        this.m_r = r;
    }

    @Override
    public Color getColor() {
        return this.m_color;
    }

    public void setColor(Color color) {
        this.m_color = color;
    }
}

