/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.api;

import com.jrockit.mc.common.persistence.ISettingFetcher;
import com.jrockit.mc.common.persistence.PersistenceToolkit;
import com.jrockit.mc.common.persistence.Setting;
import com.jrockit.mc.common.persistence.Type;
import com.jrockit.mc.flightrecorder.api.PathDescriptor;
import java.awt.Color;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PathDescriptorRepository {
    private static final String PATH_DESCRIPTORS = "pathDescriptors";
    private static final String PATH_SEGMENTS_XML = "paths.xml";
    private Map<String, PathDescriptor> s_segmentLookup = null;
    private static final PathDescriptorRepository INSTANCE;
    private Setting m_setting = new Setting("pathDescriptorRepository");

    static {
        PersistenceToolkit.registerFetcher(PathDescriptorRepository.class, (ISettingFetcher)new ISettingFetcher<PathDescriptorRepository>(){

            public Setting getSetting(PathDescriptorRepository pathSegment) {
                return pathSegment.m_setting;
            }
        });
        INSTANCE = PathDescriptorRepository.createRepository();
    }

    public PathDescriptor[] createAllPathDescriptors(String qualifiedPath) {
        String[] identifiers = qualifiedPath.split("/");
        PathDescriptor[] segments = new PathDescriptor[identifiers.length];
        String path = "";
        int n = 0;
        while (n < identifiers.length) {
            path = String.valueOf(path) + (n == 0 ? identifiers[n] : "/" + identifiers[n]);
            PathDescriptor ps = this.get(identifiers[n]);
            if (ps == null) {
                ps = this.createPathDescriptor(path, null);
            }
            segments[n] = ps;
            ++n;
        }
        return segments;
    }

    private static PathDescriptorRepository createRepository() {
        try {
            InputStream is = PathDescriptorRepository.class.getResourceAsStream(PATH_SEGMENTS_XML);
            if (is != null) {
                return (PathDescriptorRepository)PersistenceToolkit.createObjectFromInputStream(PathDescriptorRepository.class, (InputStream)is);
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return new PathDescriptorRepository();
    }

    public PathDescriptor createPathDescriptor(String qualifiedPath, String name) {
        PathDescriptor segment = this.get(qualifiedPath);
        if (segment == null) {
            int index = qualifiedPath.lastIndexOf(47);
            String identifier = qualifiedPath;
            if (index != -1) {
                identifier = qualifiedPath.substring(index + 1);
            }
            if (name == null) {
                name = PathDescriptorRepository.createHumanReadableName(identifier);
            }
            Color color = PathDescriptorRepository.createColor(qualifiedPath);
            PathDescriptor ps = new PathDescriptor();
            ps.setColor(color);
            ps.setIdentifier(qualifiedPath);
            ps.setName(name);
            segment = ps;
            return segment;
        }
        return segment;
    }

    private PathDescriptor get(String identifier) {
        if (this.s_segmentLookup == null) {
            this.s_segmentLookup = this.createLookup();
        }
        if (identifier != null) {
            return this.s_segmentLookup.get(identifier);
        }
        return null;
    }

    private Map<String, PathDescriptor> createLookup() {
        HashMap<String, PathDescriptor> segmentLookup = new HashMap<String, PathDescriptor>();
        for (PathDescriptor segment : this.getPathDescriptors()) {
            segmentLookup.put(segment.getPath(), segment);
        }
        return segmentLookup;
    }

    private List<PathDescriptor> getPathDescriptors() {
        return (List)this.m_setting.getChildObject(PATH_DESCRIPTORS, new Type(List.class, new Type[]{new Type(PathDescriptor.class)}));
    }

    private static String createHumanReadableName(String identifier) {
        if (identifier != null && identifier.length() > 0) {
            StringBuilder humanReadable = new StringBuilder();
            boolean firstLetter = true;
            int n = 0;
            while (n < identifier.length()) {
                char c = identifier.charAt(n);
                if (c == '_') {
                    c = ' ';
                }
                if (firstLetter && Character.isLetter(c)) {
                    humanReadable.append(Character.toUpperCase(c));
                } else {
                    humanReadable.append(c);
                }
                firstLetter = c == ' ';
                ++n;
            }
            return humanReadable.toString();
        }
        return identifier;
    }

    private static Color createColor(String identifier) {
        Random r = new Random(identifier.hashCode());
        return new Color(Color.HSBtoRGB(r.nextFloat(), 0.6f, 0.9f));
    }

    public static PathDescriptorRepository getDefault() {
        return INSTANCE;
    }
}

