/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.api;

import com.jrockit.mc.common.persistence.ISettingFetcher;
import com.jrockit.mc.common.persistence.LocalizedString;
import com.jrockit.mc.common.persistence.PersistenceToolkit;
import com.jrockit.mc.common.persistence.Setting;
import java.awt.Color;

public final class PathDescriptor {
    private static final String GREEN = "green";
    private static final String RED = "red";
    private static final String BLUE = "blue";
    private static final String NAME = "name";
    private static final String PATH = "path";
    private Setting m_setting = new Setting("pathDescriptor");
    private Color m_colorCache;

    static {
        PersistenceToolkit.registerFetcher(PathDescriptor.class, (ISettingFetcher)new ISettingFetcher<PathDescriptor>(){

            public Setting getSetting(PathDescriptor pathSegment) {
                return pathSegment.m_setting;
            }
        });
    }

    public void setBlue(int colorValue) {
        this.m_setting.setChildObject(RED, (Object)colorValue);
    }

    public void setGreen(int colorValue) {
        this.m_setting.setChildObject(GREEN, (Object)colorValue);
    }

    public void setRed(int colorValue) {
        this.m_setting.setChildObject(BLUE, (Object)colorValue);
    }

    public void setIdentifier(String identifier) {
        this.m_setting.setChildObject(PATH, (Object)identifier);
    }

    public String getName() {
        return ((LocalizedString)this.m_setting.getChildObject(NAME, LocalizedString.class)).getText();
    }

    public String getPath() {
        return (String)this.m_setting.getChildObject(PATH, String.class);
    }

    public int getRed() {
        return (Integer)this.m_setting.getChildObject(RED, Integer.class);
    }

    public int getBlue() {
        return (Integer)this.m_setting.getChildObject(BLUE, Integer.class);
    }

    public int getGreen() {
        return (Integer)this.m_setting.getChildObject(GREEN, Integer.class);
    }

    public int hashCode() {
        return this.getPath().hashCode();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof PathDescriptor) {
            return this.getPath().equals(((PathDescriptor)o).getPath());
        }
        return false;
    }

    public void setColor(Color color) {
        this.m_colorCache = color;
        this.setBlue(color.getBlue());
        this.setRed(color.getRed());
        this.setGreen(color.getGreen());
    }

    public Color getColor() {
        if (this.m_colorCache == null) {
            this.m_colorCache = new Color(this.getRed(), this.getGreen(), this.getBlue());
        }
        return this.m_colorCache;
    }

    public void setName(String name) {
        ((LocalizedString)this.m_setting.getChildObject(NAME, LocalizedString.class)).setText(name);
    }

    public String toString() {
        String toString = "";
        toString = String.valueOf(toString) + "Path: " + this.getPath() + "\n";
        toString = String.valueOf(toString) + "Name: " + this.getName() + "\n";
        toString = String.valueOf(toString) + "Color: " + this.getColor() + "\n";
        return toString;
    }
}

