/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.api;

import com.jrockit.mc.flightrecorder.spi.IEventType;
import com.jrockit.mc.flightrecorder.spi.IEventTypeRepository;
import com.jrockit.mc.flightrecorder.spi.IProducer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EventTypeRepository
implements IEventTypeRepository {
    private final HashMap<Integer, IEventType> m_eventTypes = new HashMap();

    @Override
    public IEventType getEventType(Integer id) {
        return this.m_eventTypes.get(id);
    }

    public void add(IEventType type) {
        this.m_eventTypes.put(type.getId(), type);
    }

    public void remove(IEventType type) {
        this.m_eventTypes.remove(type.getId());
    }

    public Collection<IEventType> getEventTypes() {
        return this.m_eventTypes.values();
    }

    public void clear() {
        this.m_eventTypes.clear();
    }

    @Override
    public Iterator<IEventType> iterator() {
        return this.m_eventTypes.values().iterator();
    }

    @Override
    public int getSize() {
        return this.m_eventTypes.size();
    }

    @Override
    public Collection<IEventType> asCollection() {
        return Collections.unmodifiableCollection(this.m_eventTypes.values());
    }

    public boolean hasEventType(IEventType type) {
        boolean contain = this.m_eventTypes.containsKey(type.getId());
        return contain;
    }

    @Override
    public List<IProducer> getProducers() {
        HashSet<IProducer> producers = new HashSet<IProducer>();
        for (IEventType type : this.getEventTypes()) {
            producers.add(type.getProducer());
        }
        return Collections.unmodifiableList(new ArrayList(producers));
    }
}

