/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.api;

import com.jrockit.mc.common.unit.UnitLookup;
import com.jrockit.mc.flightrecorder.api.Retriever;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.model.DataType;
import com.jrockit.mc.flightrecorder.internal.api.binary.jrockit.model.ValueDescriptor;
import com.jrockit.mc.flightrecorder.spi.IEvent;
import com.jrockit.mc.flightrecorder.spi.IEventType;
import com.jrockit.mc.flightrecorder.spi.IProducer;
import com.jrockit.mc.flightrecorder.spi.IRetriever;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class EventType {
    private final String m_name;
    private final String m_description;
    private final int m_eventTypeIdentifier;
    private final String m_path;
    private final IProducer m_producer;
    private final HashMap<String, IRetriever> m_retrivers;

    public EventType(IProducer producer, int eid, String path, String name, String description) {
        this.m_name = name;
        this.m_description = description;
        this.m_eventTypeIdentifier = eid;
        this.m_path = path;
        this.m_producer = producer;
        this.m_retrivers = new HashMap();
        this.addRetriver(this.createStartTimeRetriever(this));
        this.addRetriver(this.createDurationRetriverRetriever(this));
    }

    public IRetriever createDurationRetriverRetriever(EventType eventType) {
        ValueDescriptor b = new ValueDescriptor();
        b.setName("Duration");
        b.setDescription("The time the event took");
        b.setIdentifier("(duration)");
        b.setDataType(DataType.LONG);
        b.setContentType(UnitLookup.TIMESPAN.getIdentifier());
        return new Retriever(b, eventType.getPath()){

            public Object getValue(IEvent event) {
                return event.getEndTimestamp() - event.getStartTimestamp();
            }
        };
    }

    public IRetriever createStartTimeRetriever(EventType eventType) {
        ValueDescriptor b = new ValueDescriptor();
        b.setName("Start Time");
        b.setDescription("The start time of the event");
        b.setIdentifier("(startTime)");
        b.setDataType(DataType.LONG);
        b.setContentType(UnitLookup.TIMESPAN.getIdentifier());
        return new Retriever(b, eventType.getPath()){

            public Object getValue(IEvent event) {
                return event.getStartTimestamp();
            }
        };
    }

    public IRetriever createEndTimeRetriever(IEventType eventType) {
        ValueDescriptor b = new ValueDescriptor();
        b.setName("End Time");
        b.setDescription("The end time of the event, when it was committed");
        b.setIdentifier("(endTime)");
        b.setDataType(DataType.LONG);
        b.setContentType(UnitLookup.TIMESPAN.getIdentifier());
        return new Retriever(b, eventType.getPath()){

            public Object getValue(IEvent event) {
                return event.getEndTimestamp();
            }
        };
    }

    public void addRetriver(IRetriever retriever) {
        this.m_retrivers.put(retriever.getAttributeIdentifier(), retriever);
    }

    public Color getColor() {
        return Color.RED;
    }

    public String getDescription() {
        return this.m_description;
    }

    public int getEventCount() {
        return 0;
    }

    public Integer getId() {
        return this.m_eventTypeIdentifier;
    }

    public String getName() {
        return this.m_name;
    }

    public String getPath() {
        return this.m_path;
    }

    public IProducer getProducer() {
        return this.m_producer;
    }

    public IRetriever getRetriever(String key) {
        return this.m_retrivers.get(key);
    }

    public Map<String, IRetriever> getRetrivers() {
        return this.m_retrivers;
    }

    public String getSymbolName() {
        return this.m_path;
    }

    public int getTransitionFromIndex() {
        return -1;
    }

    public String getTransitionFromName() {
        return null;
    }

    public String getTransitionToName() {
        return null;
    }
}

