/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.api;

import com.jrockit.mc.flightrecorder.internal.api.range.RangeToolkit;
import com.jrockit.mc.flightrecorder.spi.IEvent;
import com.jrockit.mc.flightrecorder.spi.IEventType;
import com.jrockit.mc.flightrecorder.spi.IRange;
import com.jrockit.mc.flightrecorder.spi.IRetriever;

public class Event
implements IEvent {
    private final IEventType m_eventType;
    private final long m_startTime;
    private final long m_endTime;
    private final Object[] m_values;
    private int m_infoFlag;

    public Event(IEventType t, long startTime, long endTime, Object[] values) {
        this.m_eventType = t;
        this.m_startTime = startTime;
        this.m_endTime = endTime;
        this.m_values = values;
    }

    public long getDuration(IRange cropRange) {
        return RangeToolkit.cropRange(cropRange, this);
    }

    public IEventType getEventType() {
        return this.m_eventType;
    }

    public int getBitField() {
        return this.m_infoFlag;
    }

    public Object getThreadTransitionFrom() {
        return null;
    }

    public Object getThreadTransitionTo() {
        return null;
    }

    public void setBitField(int i) {
        this.m_infoFlag = i;
    }

    public long getDuration() {
        if (this.m_endTime == -4611686018427387904L || this.m_startTime == 0x3FFFFFFFFFFFFFFFL) {
            return Long.MAX_VALUE;
        }
        return this.m_endTime - this.m_startTime;
    }

    public long getEndTimestamp() {
        return this.m_endTime;
    }

    public long getStartTimestamp() {
        return this.m_startTime;
    }

    public Object getAttributeValue(int index) {
        return this.m_values[index];
    }

    public Object getValue(String value) {
        IRetriever r = this.m_eventType.getRetriever(value);
        if (r != null) {
            return r.getValue(this);
        }
        return null;
    }
}

