/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.api;

import com.jrockit.mc.flightrecorder.api.ProgressMonitor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeProgressMonitor
extends ProgressMonitor {
    private final List<ProgressMonitor> m_childMonitors = new ArrayList<ProgressMonitor>();

    @Override
    public void beginTask(int workUnits, String description) {
        for (ProgressMonitor child : this.m_childMonitors) {
            child.beginTask(workUnits, description);
        }
    }

    @Override
    public void doWork(int workUnits) {
        for (ProgressMonitor child : this.m_childMonitors) {
            child.doWork(workUnits);
        }
    }

    @Override
    public void done() {
        for (ProgressMonitor child : this.m_childMonitors) {
            child.done();
        }
    }

    @Override
    public void endTask() {
        for (ProgressMonitor child : this.m_childMonitors) {
            child.endTask();
        }
    }

    @Override
    public boolean cancel() {
        boolean success = true;
        for (ProgressMonitor child : this.m_childMonitors) {
            if (child.cancel()) continue;
            success = false;
        }
        return success;
    }

    public void add(String id, ProgressMonitor monitor) {
        this.m_childMonitors.add(monitor);
    }

    public boolean remove(ProgressMonitor monitor) {
        return this.m_childMonitors.add(monitor);
    }

    public List<ProgressMonitor> getProgressMonitors() {
        return (List)Collections.unmodifiableCollection(this.m_childMonitors);
    }

    @Override
    public void log(ProgressMonitor.SEVERITY sverity, String message, Throwable throwable) {
        for (ProgressMonitor child : this.m_childMonitors) {
            child.log(sverity, message, throwable);
        }
    }
}

