/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder;

import com.jrockit.mc.flightrecorder.api.Configuration;
import com.jrockit.mc.flightrecorder.api.EventTypeView;
import com.jrockit.mc.flightrecorder.api.Range;
import com.jrockit.mc.flightrecorder.api.TrackView;
import com.jrockit.mc.flightrecorder.spi.IConfiguration;
import com.jrockit.mc.flightrecorder.spi.IEvent;
import com.jrockit.mc.flightrecorder.spi.IEventTypeRepository;
import com.jrockit.mc.flightrecorder.spi.IEventTypeView;
import com.jrockit.mc.flightrecorder.spi.IRange;
import com.jrockit.mc.flightrecorder.spi.ITrackRepository;
import com.jrockit.mc.flightrecorder.spi.ITrackView;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FlightRecording {
    private IConfiguration m_configuration = new Configuration();
    private IEventTypeRepository m_eventTypeRepository = null;
    private IRange m_range;

    public synchronized IConfiguration getConfiguration() {
        return this.m_configuration;
    }

    public synchronized IEventTypeRepository getEventTypeRepository() {
        if (this.m_eventTypeRepository == null) {
            this.m_eventTypeRepository = this.getConfiguration().getEventProvider().createEventTypeRepository();
        }
        return this.m_eventTypeRepository;
    }

    public synchronized Iterator<IEvent> iterator() {
        return this.getConfiguration().getEventProvider().createEventIterator();
    }

    public synchronized IRange getRange() {
        if (this.m_range == null) {
            IRange r = this.getConfiguration().getEventProvider().getRange();
            if (r.getStartTimestamp() == 0x3FFFFFFFFFFFFFFFL || r.getEndTimestamp() == -4611686018427387904L) {
                r = new Range(System.currentTimeMillis() * 1000L * 1000L, System.currentTimeMillis() * 1000L * 1000L + 1L);
            }
            this.m_range = new Range(r.getStartTimestamp() - 1000000L, r.getEndTimestamp() + 1000000L);
        }
        return this.m_range;
    }

    public synchronized ITrackRepository getTrackRepository() {
        return this.getConfiguration().getEventProvider().getTrackRepository();
    }

    public IEventTypeView createView() {
        EventTypeView view = new EventTypeView();
        view.setEventTypes(this.getEventTypeRepository().asCollection());
        return view;
    }

    public ITrackView createTrackView() {
        TrackView view = new TrackView(this.getTrackRepository());
        view.setTracks(this.getTrackRepository().getAllTrackDescriptors());
        return view;
    }

    public synchronized void flush() {
        this.m_eventTypeRepository = null;
        this.m_configuration.getEventProvider().flush();
    }
}

