/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.browser.attach.preferences;

import com.jrockit.mc.browser.attach.AttachPlugin;
import com.jrockit.mc.browser.attach.LocalDescriptorProvider;
import com.jrockit.mc.browser.attach.preferences.EditableListEditor;
import com.jrockit.mc.browser.attach.preferences.Messages;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class AttachPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public AttachPreferencePage() {
        super(1);
        this.setPreferenceStore(AttachPlugin.getDefault().getPreferenceStore());
        this.setDescription(Messages.AttachPreferencePage_ATTACH_PREFERENCES_DESCRIPTION);
    }

    public void createFieldEditors() {
        this.addField(new ListEditorExtension("namingRulesPreference", Messages.AttachPreferencePage_CAPTION_NAMING_RULES, this.getFieldEditorParent()));
        this.addField((FieldEditor)new BooleanFieldEditor("autoStartPreference", Messages.AttachPreferencePage_CAPTION_AUTO_START, this.getFieldEditorParent()));
        GridData gridData = new GridData(0x1000000, 128, true, true);
        gridData.horizontalSpan = 2;
        Button resetCache = new Button(this.getFieldEditorParent(), 8);
        resetCache.setText(Messages.AttachPreferencePage_BUTTON_RESET_CACHE_TEXT);
        resetCache.setToolTipText(Messages.AttachPreferencePage_BUTTON_RESET_CACHE_TOOLTIP);
        resetCache.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                LocalDescriptorProvider.getInstance().resetDescriptorCache();
            }
        });
        resetCache.setLayoutData((Object)gridData);
    }

    public void init(IWorkbench workbench) {
    }

    private final class ListEditorExtension
    extends EditableListEditor {
        private ListEditorExtension(String name, String labelText, Composite parent) {
            super(name, labelText, parent);
        }

        protected String createList(String[] items) {
            StringBuffer buf = new StringBuffer();
            int i = 0;
            while (i < items.length) {
                buf.append(items[i]);
                buf.append('\u0000');
                ++i;
            }
            return buf.toString();
        }

        protected String getNewInputObject() {
            return this.getInput(Messages.AttachPreferencePage_RULE_INPUT_DIALOG_TITLE, Messages.AttachPreferencePage_RULE_INPUT_DIALOG_CAPTION, Messages.AttachPreferencePage_RULE_INPUT_DIALOG_DEFAULT_RULE);
        }

        private String getInput(String title, String caption, String defaultValue) {
            InputDialog dlg = new InputDialog(this.getShell(), title, caption, defaultValue, new IInputValidator(this){
                final /* synthetic */ ListEditorExtension this$1;
                {
                    this.this$1 = listEditorExtension;
                }

                public String isValid(String newText) {
                    String[] ruleParts = newText.split("=>");
                    if (ruleParts.length != 2) {
                        return Messages.AttachPreferencePage_RULE_INPUT_DIALOG_SYNTAX_ERROR_NO_IMPLICATION;
                    }
                    if (ruleParts[0].split("=").length != 2) {
                        return Messages.AttachPreferencePage_RULE_INPUT_DIALOG_SYNTAX_ERROR_NO_MATCHING_EQUALS;
                    }
                    return null;
                }
            });
            dlg.setBlockOnOpen(true);
            if (dlg.open() == 0) {
                return dlg.getValue();
            }
            return null;
        }

        protected String getEditedObject(String previous) {
            return this.getInput(Messages.AttachPreferencePage_RULE_INPUT_DIALOG_TITLE, Messages.AttachPreferencePage_RULE_INPUT_DIALOG_EDIT_CAPTION, previous);
        }

        protected String[] parseString(String stringList) {
            return stringList.split("\u0000");
        }
    }
}

