/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.browser.attach;

import com.jrockit.mc.browser.attach.AttachPlugin;
import com.jrockit.mc.browser.attach.Messages;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

public class NameConverter {
    private HashMap constants = new HashMap();
    private HashMap variables = new HashMap();
    private List rules = new ArrayList();
    private List matchers = new ArrayList();

    public NameConverter() {
        this.initDefaultConstants();
        this.initDefaultVariables();
    }

    private void initDefaultConstants() {
        this.setConstant("ThisPID", MessageFormat.format("{0}", new Integer(AttachPlugin.getPID())));
        this.setConstant("JDK", "{0}");
        this.setConstant("IsJRockit", "{1}");
        this.setConstant("Name", "{2}");
        this.setConstant("PID", "{3}");
        this.setConstant("IsDebug", "{4}");
        this.setConstant("StrConstNoJRockit", Messages.LocalConnectionDescriptor_NON_JROCKIT_JVM);
        this.setConstant("StrConstDebug", Messages.NameConverter_DEBUG);
    }

    private void initDefaultVariables() {
        this.variables.put("StrNoJRockit", new IVariableEvaluator(){

            public String evaluate(Object[] input) {
                return "true".equals(input[1]) ? "" : "[" + Messages.LocalConnectionDescriptor_NON_JROCKIT_JVM + "]";
            }
        });
        this.variables.put("StrDebug", new IVariableEvaluator(){

            public String evaluate(Object[] input) {
                return "true".equals(input[4]) ? "[" + Messages.NameConverter_DEBUG + "]" : "";
            }
        });
        this.variables.put("StrJDK", new IVariableEvaluator(){

            public String evaluate(Object[] input) {
                return "0".equals(input[0]) ? "" : "[" + input[0] + "]";
            }
        });
    }

    public void setConstant(String key, Object value) {
        if (value == null) {
            throw new IllegalArgumentException("You may not add a variable which has a value that is null!");
        }
        this.constants.put(key, value);
    }

    public String format(Object[] values) {
        Iterator iter = this.matchers.iterator();
        while (iter.hasNext()) {
            Matcher matcher = (Matcher)iter.next();
            try {
                if (!matcher.matches(values)) continue;
                return matcher.format(values);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        return MessageFormat.format(Messages.LocalConnectionDescriptor_LOCAL_NAME_TEMPLATE, values);
    }

    public void addNamingRule(String rule) {
        if ((rule = this.replaceStaticVariables(rule)).equals("")) {
            throw new IllegalArgumentException("Invalid rule - you may not add empty rules!");
        }
        this.rules.add(rule);
        this.matchers.add(new Matcher(rule));
    }

    private String replaceStaticVariables(String rule) {
        StringBuffer buffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(rule, "{}", true);
        while (stringTokenizer.hasMoreTokens()) {
            String token = stringTokenizer.nextToken();
            if (token.equals("{")) {
                if (!stringTokenizer.hasMoreTokens()) {
                    throw new IllegalArgumentException("Found unmatched { in rule!");
                }
                String content = stringTokenizer.nextToken();
                if (this.constants.containsKey(content)) {
                    token = this.constants.get(content).toString();
                    stringTokenizer.nextToken();
                } else {
                    token = String.valueOf(token) + content;
                }
            }
            buffer.append(token);
        }
        return buffer.toString();
    }

    private String replaceVariables(String rule, Object[] input) {
        StringBuffer buffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(rule, "{}", true);
        while (stringTokenizer.hasMoreTokens()) {
            String token = stringTokenizer.nextToken();
            if (token.equals("{")) {
                if (!stringTokenizer.hasMoreTokens()) {
                    throw new IllegalArgumentException("Found unmatched { in rule!");
                }
                String content = stringTokenizer.nextToken();
                if (this.variables.containsKey(content)) {
                    token = ((IVariableEvaluator)this.variables.get(content)).evaluate(input);
                    stringTokenizer.nextToken();
                } else {
                    token = "{" + content;
                }
            }
            buffer.append(token);
        }
        return buffer.toString();
    }

    public List getRules() {
        return Collections.unmodifiableList(this.rules);
    }

    private static interface IVariableEvaluator {
        public String evaluate(Object[] var1);
    }

    private class Matcher {
        private String matchPart;
        private String transformPart;
        private MessageFormat matchFormat;

        public Matcher(String rule) {
            this.initialize(rule);
        }

        private void initialize(String rule) {
            String[] match = rule.split("=>");
            if (match.length != 2) {
                throw new IllegalArgumentException("Invalid rule - need both match part and transform part.");
            }
            this.matchPart = match[0].trim().replace('=', '\u0000');
            this.matchFormat = new MessageFormat(this.matchPart);
            this.transformPart = match[1].trim();
        }

        public boolean matches(Object[] vals) {
            String right;
            String resolved = this.matchFormat.format(vals);
            String[] parts = resolved.split("\u0000");
            String left = parts[0].trim();
            return left.equals(right = parts[1].trim()) || left.matches(right);
        }

        public String format(Object[] vals) {
            return MessageFormat.format(NameConverter.this.replaceVariables(this.transformPart, vals), vals);
        }

        public String toString() {
            return "Matcher [" + this.matchPart + " => " + this.transformPart + "]";
        }
    }
}

