/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.browser.attach;

import com.jrockit.mc.browser.attach.AttachPlugin;
import com.jrockit.mc.browser.attach.LocalConnectionDescriptor;
import com.jrockit.mc.browser.attach.Messages;
import com.jrockit.mc.browser.attach.NameConverter;
import com.jrockit.mc.browser.attach.internal.ExecuteTunnler;
import com.jrockit.mc.rjmx.IConnectionDescriptor;
import com.sun.tools.attach.AgentLoadException;
import com.sun.tools.attach.AttachNotSupportedException;
import com.sun.tools.attach.VirtualMachine;
import com.sun.tools.attach.VirtualMachineDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.WeakHashMap;
import java.util.logging.Level;
import javax.management.remote.JMXServiceURL;
import sun.jvmstat.monitor.HostIdentifier;
import sun.jvmstat.monitor.MonitorException;
import sun.jvmstat.monitor.MonitoredHost;
import sun.jvmstat.monitor.MonitoredVm;
import sun.jvmstat.monitor.MonitoredVmUtil;
import sun.jvmstat.monitor.StringMonitor;
import sun.jvmstat.monitor.VmIdentifier;
import sun.management.ConnectorAddressLink;
import sun.management.counter.perf.InstrumentationException;
import sun.tools.attach.HotSpotVirtualMachine;

public class LocalJVMToolkit {
    private static boolean isErrorMessageSent = false;
    private static Map last = new WeakHashMap();
    private static NameConverter nameConverter;
    static final String LOCAL_CONNECTOR_ADDRESS_PROP = "com.sun.management.jmxremote.localConnectorAddress";

    private LocalJVMToolkit() {
    }

    public static IConnectionDescriptor[] getLocalConnections() {
        HashMap map = new HashMap();
        LocalJVMToolkit.populateAttachableVMs(map);
        LocalJVMToolkit.populateMonitoredVMs(map);
        last = map;
        ArrayList list = new ArrayList(map.values());
        return list.toArray(new IConnectionDescriptor[0]);
    }

    private static void populateMonitoredVMs(HashMap map) {
        Set<Integer> vms;
        MonitoredHost host;
        try {
            host = MonitoredHost.getMonitoredHost(new HostIdentifier(null));
            vms = host.activeVms();
        }
        catch (URISyntaxException sx) {
            throw new InternalError(sx.getMessage());
        }
        catch (MonitorException mx) {
            throw new InternalError(mx.getMessage());
        }
        Iterator<Integer> vmIter = vms.iterator();
        while (vmIter.hasNext()) {
            Integer vmid = vmIter.next();
            if (!(vmid instanceof Integer)) continue;
            IConnectionDescriptor connDesc = (IConnectionDescriptor)last.get(vmid);
            if (connDesc == null) {
                int pid = vmid;
                String name = ((Object)vmid).toString();
                boolean attachable = false;
                boolean isJrockit = true;
                boolean isDebug = false;
                String address = null;
                String version = null;
                try {
                    MonitoredVm mvm = host.getMonitoredVm(new VmIdentifier(name));
                    try {
                        name = MonitoredVmUtil.commandLine(mvm);
                        StringMonitor sm = (StringMonitor)mvm.findByName("java.property.java.vm.name");
                        if (sm != null) {
                            isJrockit = LocalJVMToolkit.isJRockit(sm.stringValue());
                        }
                        if ((sm = (StringMonitor)mvm.findByName("java.property.java.vm.version")) != null && isJrockit) {
                            version = LocalJVMToolkit.decodeJavaVersion(sm.stringValue());
                            isDebug = LocalJVMToolkit.isDebug(sm.stringValue());
                        } else {
                            version = "0";
                        }
                        attachable = MonitoredVmUtil.isAttachable(mvm);
                        address = ConnectorAddressLink.importFrom((int)pid);
                    }
                    finally {
                        mvm.detach();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                connDesc = LocalJVMToolkit.createDescriptor(name, vmid, attachable, isJrockit, address, version, isDebug);
            }
            map.put(vmid, connDesc);
        }
    }

    private static boolean isDebug(String stringValue) {
        return stringValue.startsWith("DEBUG");
    }

    private static void populateAttachableVMs(Map map) {
        List<VirtualMachineDescriptor> vms = VirtualMachine.list();
        if (vms == null) {
            return;
        }
        Iterator<VirtualMachineDescriptor> vmsIter = vms.iterator();
        while (vmsIter.hasNext()) {
            VirtualMachineDescriptor vmd = vmsIter.next();
            try {
                Integer vmid = Integer.valueOf(vmd.id());
                if (map.containsKey(vmid)) continue;
                AttachPlugin.getLogger().finest("Local attach resolving PID " + vmid);
                IConnectionDescriptor connDesc = (IConnectionDescriptor)last.get(vmid);
                if (connDesc == null) {
                    boolean attachable = false;
                    boolean isDebug = false;
                    boolean isJRockit = true;
                    String address = null;
                    String version = null;
                    try {
                        VirtualMachine vm = VirtualMachine.attach(vmd);
                        try {
                            attachable = true;
                            Properties props = vm.getSystemProperties();
                            if (props != null) {
                                String vmName = props.getProperty("java.vm.name");
                                isJRockit = LocalJVMToolkit.isJRockit(vmName);
                                isDebug = LocalJVMToolkit.isDebug(vmName);
                                version = props.getProperty("java.specification.version");
                            }
                            Properties agentProps = vm.getAgentProperties();
                            address = (String)agentProps.get(LOCAL_CONNECTOR_ADDRESS_PROP);
                        }
                        finally {
                            vm.detach();
                        }
                    }
                    catch (AttachNotSupportedException x) {
                        attachable = false;
                    }
                    catch (Throwable t) {
                        if (isErrorMessageSent) continue;
                        AttachPlugin.getLogger().log(Level.FINER, "Scanning using attach/getAgentProperties failed on " + vmid + ". Not implemented in JRockit R27.1 so not that strange. This message will only be printed once, so errors for subsequent PIDs will not be logged...", t);
                        isErrorMessageSent = true;
                        continue;
                    }
                    connDesc = LocalJVMToolkit.createDescriptor(vmd.displayName(), vmid, attachable, isJRockit, address, version, isDebug);
                    AttachPlugin.getLogger().info("Done resolving PID " + vmid);
                }
                map.put(vmid, connDesc);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    private static IConnectionDescriptor createDescriptor(String commandLine, Integer PID, boolean attachable, boolean isJRockit, String address, String version, boolean isDebug) {
        Object[] values = new Object[]{version, Boolean.toString(isJRockit), LocalJVMToolkit.cropCommandLine(commandLine), PID, Boolean.toString(isDebug)};
        return new LocalConnectionDescriptor(nameConverter.format(values), PID, commandLine, address, attachable, isJRockit, version, isDebug);
    }

    private static Object cropCommandLine(String commandLine) {
        StringTokenizer st = new StringTokenizer(commandLine, "-");
        if (commandLine == null || !st.hasMoreTokens()) {
            return Messages.LocalJVMToolkit_UNKNOWN_LOCAL_JVM;
        }
        return st.nextToken().trim();
    }

    private static boolean isJRockit(String vmName) {
        return vmName.startsWith("BEA JRockit") || vmName.startsWith("Oracle JRockit");
    }

    private static String decodeJavaVersion(String version) {
        String specVersion = version;
        if (version.startsWith("R") || version.startsWith("P") || version.startsWith("DEBUG-")) {
            specVersion = version.split("-")[3];
        }
        if (specVersion.lastIndexOf(46) >= 0) {
            return specVersion.substring(0, specVersion.lastIndexOf(46));
        }
        return null;
    }

    public static synchronized IConnectionDescriptor[] getAttachableJVMs() {
        return LocalJVMToolkit.getLocalConnections();
    }

    public static String executeCommandForPid(String pid, String command) throws AttachNotSupportedException, IOException, AgentLoadException {
        VirtualMachine vm = VirtualMachine.attach(pid);
        String result = LocalJVMToolkit.executeCommandForPid(vm, pid, command);
        vm.detach();
        return result;
    }

    public static String executeCommandForPid(VirtualMachine vm, String pid, String command) throws AttachNotSupportedException, IOException, AgentLoadException {
        int n;
        HotSpotVirtualMachine hvm = (HotSpotVirtualMachine)vm;
        InputStream in = ExecuteTunnler.execute(hvm, "jrockit_command", new Object[]{command});
        byte[] b = new byte[256];
        StringBuffer buf = new StringBuffer();
        do {
            if ((n = in.read(b)) <= 0) continue;
            String s = new String(b, 0, n, "UTF-8");
            buf.append(s);
        } while (n > 0);
        try {
            in.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return buf.toString();
    }

    public static JMXServiceURL getInMemoryURLFromPID(int pid) throws IOException {
        JMXServiceURL inMemURL = null;
        String address = null;
        try {
            address = ConnectorAddressLink.importFrom((int)pid);
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (InstrumentationException instrumentationException) {
            // empty catch block
        }
        if (address != null) {
            inMemURL = new JMXServiceURL(address);
        }
        return inMemURL;
    }

    public static synchronized void setNameConverter(NameConverter nc) {
        last.clear();
        nameConverter = nc;
    }
}

