/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.browser.attach;

import com.jrockit.mc.browser.attach.AttachPlugin;
import com.jrockit.mc.browser.attach.LocalJVMToolkit;
import com.jrockit.mc.browser.attach.Messages;
import com.jrockit.mc.browser.attach.NameConverter;
import com.jrockit.mc.browser.autodiscovery.AbstractDescriptorProvider;
import com.jrockit.mc.browser.autodiscovery.IDescriptorListener;
import com.jrockit.mc.rjmx.IConnectionDescriptor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

public class LocalDescriptorProvider
extends AbstractDescriptorProvider {
    private static final long LOCAL_REFRESH_INTERVAL = 5000L;
    private LocalScanner m_scanner;
    private Thread m_scannerThread;
    private static LocalDescriptorProvider m_lastProvider;
    private Map lastDescriptors = new HashMap();

    public LocalDescriptorProvider() {
        if (m_lastProvider != null) {
            m_lastProvider.shutDown();
        }
        m_lastProvider = this;
    }

    public String getName() {
        return Messages.LocalDescriptorProvider_PROVIDER_NAME;
    }

    private void initialize() {
        if (!AttachPlugin.isLocalAttachAvailable()) {
            AttachPlugin.getLogger().warning("Could not find the classes needed to support attach. Attaching to local JVMs will be disabled! Run with logging set to FINE for more information.");
            return;
        }
        this.initializeNameConverter();
        AttachPlugin.getDefault().getPreferenceStore().addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equals("namingRulesPreference")) {
                    LocalDescriptorProvider.this.initializeNameConverter();
                }
            }
        });
        this.m_scanner = new LocalScanner();
        this.m_scannerThread = new Thread((Runnable)this.m_scanner, "Local Descriptor Scanner");
        this.m_scannerThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeNameConverter() {
        NameConverter nc = new NameConverter();
        String r = AttachPlugin.getDefault().getPreferenceStore().getString("namingRulesPreference");
        String[] rules = r.split("\u0000");
        int i = 0;
        while (i < rules.length) {
            try {
                nc.addNamingRule(rules[i]);
            }
            catch (IllegalArgumentException e) {
                AttachPlugin.getLogger().log(Level.WARNING, "Could not add rule " + rules[i] + ". Skipping it.", e);
            }
            ++i;
        }
        Map map = this.lastDescriptors;
        synchronized (map) {
            LocalJVMToolkit.setNameConverter(nc);
            this.resetDescriptorCache();
        }
    }

    private String extractPID(IConnectionDescriptor prop) {
        String pid = (String)prop.getExtendedProperties().get("com.jrockit.connectioninfo.pid");
        return pid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDescriptorListener(IDescriptorListener l) {
        List list = this.m_descriptorListeners;
        synchronized (list) {
            if (this.m_descriptorListeners.size() == 0) {
                super.addDescriptorListener(l);
                this.initialize();
            } else {
                super.addDescriptorListener(l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDescriptorListener(IDescriptorListener l) {
        List list = this.m_descriptorListeners;
        synchronized (list) {
            super.removeDescriptorListener(l);
            if (this.m_descriptorListeners.size() == 0 && this.m_scanner != null) {
                this.m_scanner.shutDown();
                this.m_scannerThread.interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetDescriptorCache() {
        Map map = this.lastDescriptors;
        synchronized (map) {
            Iterator iter = this.lastDescriptors.values().iterator();
            while (iter.hasNext()) {
                IConnectionDescriptor cd = (IConnectionDescriptor)iter.next();
                this.fireDescriptorChange(cd, IDescriptorListener.EventType.DESCRIPTOR_REMOVE);
            }
            this.lastDescriptors.clear();
        }
    }

    public void shutDown() {
        this.m_scanner.shutDown();
    }

    public static LocalDescriptorProvider getInstance() {
        return m_lastProvider;
    }

    private class LocalScanner
    implements Runnable {
        boolean isRunning;

        private LocalScanner() {
        }

        public void run() {
            this.isRunning = true;
            while (this.isRunning) {
                try {
                    this.scan();
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }

        public void shutDown() {
            this.isRunning = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void scan() {
            HashMap<String, IConnectionDescriptor> newOnes = new HashMap<String, IConnectionDescriptor>();
            IConnectionDescriptor[] props = LocalJVMToolkit.getAttachableJVMs();
            int i = 0;
            while (i < props.length) {
                newOnes.put(LocalDescriptorProvider.this.extractPID(props[i]), props[i]);
                ++i;
            }
            Map map = LocalDescriptorProvider.this.lastDescriptors;
            synchronized (map) {
                Object key;
                Iterator iter = new HashSet(LocalDescriptorProvider.this.lastDescriptors.keySet()).iterator();
                while (iter.hasNext()) {
                    key = iter.next();
                    if (newOnes.containsKey(key)) continue;
                    IConnectionDescriptor cd = (IConnectionDescriptor)LocalDescriptorProvider.this.lastDescriptors.remove(key);
                    LocalDescriptorProvider.this.fireDescriptorChange(cd, IDescriptorListener.EventType.DESCRIPTOR_REMOVE);
                }
                iter = newOnes.keySet().iterator();
                while (iter.hasNext()) {
                    key = iter.next();
                    if (LocalDescriptorProvider.this.lastDescriptors.containsKey(key)) continue;
                    LocalDescriptorProvider.this.fireDescriptorChange((IConnectionDescriptor)newOnes.get(key), IDescriptorListener.EventType.DESCRIPTOR_ADD);
                }
                LocalDescriptorProvider.this.lastDescriptors.clear();
                LocalDescriptorProvider.this.lastDescriptors.putAll(newOnes);
            }
        }
    }
}

