/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.browser.attach;

import com.jrockit.mc.browser.attach.AttachPlugin;
import com.jrockit.mc.browser.attach.LazyServiceURLResolveException;
import com.jrockit.mc.browser.attach.LocalJVMToolkit;
import com.jrockit.mc.browser.attach.Messages;
import com.jrockit.mc.rjmx.ConnectionDescriptorToolkit;
import com.jrockit.mc.rjmx.IConnectionDescriptor;
import com.jrockit.mc.rjmx.internal.PrefsToolkit;
import com.sun.tools.attach.AgentLoadException;
import com.sun.tools.attach.AttachNotSupportedException;
import com.sun.tools.attach.VirtualMachine;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import javax.management.remote.JMXServiceURL;

public class LocalConnectionDescriptor
implements IConnectionDescriptor {
    private static final Object EXTENDED_PROPERTY_KEY_JAVA_VERSION = "com.jrockit.connectioninfo.javaversion";
    private static final Object EXTENDED_PROPERTY_KEY_ADDRESS = "com.jrockit.connectioninfo.address";
    private static final String EXTENDED_PROPERTY_KEY_ATTACHABLE = "com.jrockit.connectioninfo.attachable";
    private static final String EXTENDED_PROPERTY_KEY_DEBUG = "com.jrockit.connectioninfo.debug";
    private static final String SELF_HOST_NAME = "localhost";
    private static final String COULD_NOT_RETRIEVE_URL_ERROR_MESSAGE = "Could not retrieve the in-memory service URL after starting the in-memory agent!";
    private boolean isAutoStartAgent = LocalConnectionDescriptor.fetchAutoStartAgentFromStore();
    private boolean isJRockit = false;
    protected JMXServiceURL url;
    private Map environment = new HashMap();
    private Map extendedProperties = new HashMap();
    private String connectionName;
    private String m_guid = this.createLocalGUID();

    public LocalConnectionDescriptor(String connectionName, Object vmid, String commandline, String address, boolean attachable, boolean isJRockit, String javaVersion, boolean isDebug) {
        this.connectionName = connectionName;
        this.createProps(vmid, commandline, attachable, address, isJRockit, javaVersion, isDebug);
    }

    private String createLocalGUID() {
        return "Local-[PID:" + this.getPID() + ", seq:" + PrefsToolkit.getNextIDSequenceNumber() + "]";
    }

    private void createProps(Object vmid, String name, boolean attachable, String address, boolean isJRockit, String javaVersion, boolean debug) {
        this.isJRockit = isJRockit;
        this.getExtendedProperties().put("com.jrockit.connectioninfo.pid", vmid.toString());
        this.getExtendedProperties().put("com.jrockit.connectioninfo.commandline", name);
        this.getExtendedProperties().put(EXTENDED_PROPERTY_KEY_ADDRESS, address);
        this.getExtendedProperties().put(EXTENDED_PROPERTY_KEY_ATTACHABLE, new Boolean(attachable));
        this.getExtendedProperties().put("com.jrockit.connectioninfo.jrockit", new Boolean(isJRockit));
        this.getExtendedProperties().put(EXTENDED_PROPERTY_KEY_JAVA_VERSION, javaVersion);
        this.getExtendedProperties().put(EXTENDED_PROPERTY_KEY_DEBUG, new Boolean(debug));
        if (address != null) {
            try {
                this.url = new JMXServiceURL(address);
            }
            catch (MalformedURLException e) {
                AttachPlugin.getLogger().log(Level.SEVERE, "Could not get create service URL from a local address!", e);
            }
        } else if (this.isSelfMonitoring()) {
            try {
                this.url = ConnectionDescriptorToolkit.createServiceURL((String)SELF_HOST_NAME, (int)0, (boolean)true);
                this.getExtendedProperties().put("com.jrockit.connectioninfo.is_myself", Boolean.TRUE);
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
    }

    private boolean isSelfMonitoring() {
        return Integer.parseInt((String)this.getExtendedProperties().get("com.jrockit.connectioninfo.pid")) == AttachPlugin.getPID();
    }

    public void startManagementServer() throws IOException {
        if (this.isSelfMonitoring()) {
            return;
        }
        String name = (String)this.getExtendedProperties().get("com.jrockit.connectioninfo.pid");
        try {
            if (!this.isJRockit()) {
                this.isAutoStartAgent = false;
                throw new IOException("Can not auto start the management agent on other JVMs than JRockit. Turning off autostart for this JVM.");
            }
            this.tryJRCMDStyleStartingOfTheAgent(name);
        }
        catch (AgentLoadException x) {
            throw new LazyServiceURLResolveException("Problem starting up management agent on server! " + x.getMessage(), x);
        }
        catch (AttachNotSupportedException x) {
            throw new LazyServiceURLResolveException("Problem starting up management agent on server! " + x.getMessage(), x);
        }
    }

    private boolean isJRockit() {
        return this.isJRockit;
    }

    private void tryJRCMDStyleStartingOfTheAgent(String name) throws AttachNotSupportedException, IOException, AgentLoadException {
        VirtualMachine vm = null;
        try {
            vm = VirtualMachine.attach(name);
            String version = LocalJVMToolkit.executeCommandForPid(vm, name, "version");
            if (version.indexOf("1.4.") > -1 || version.indexOf("R26") > -1) {
                throw new LazyServiceURLResolveException("Connecting through the local agent is only supported by JRockit R27.1 5.0 and above.");
            }
            LocalJVMToolkit.executeCommandForPid(vm, name, "start_management_server");
            JMXServiceURL inMemURL = LocalJVMToolkit.getInMemoryURLFromPID(Integer.parseInt(name));
            if (inMemURL == null) {
                AttachPlugin.getLogger().log(Level.SEVERE, COULD_NOT_RETRIEVE_URL_ERROR_MESSAGE);
                throw new LazyServiceURLResolveException(COULD_NOT_RETRIEVE_URL_ERROR_MESSAGE);
            }
            this.url = inMemURL;
        }
        finally {
            if (vm != null) {
                vm.detach();
            }
        }
    }

    public JMXServiceURL createJMXServiceURL() throws IOException {
        if (this.url == null) {
            JMXServiceURL inMemURL = LocalJVMToolkit.getInMemoryURLFromPID(Integer.parseInt(this.getPID()));
            if (inMemURL != null) {
                AttachPlugin.getLogger().info("Found URL! No need to start an Agent!");
                this.url = inMemURL;
            } else if (this.isAutoStartAgent()) {
                if (!this.isAttachable()) {
                    throw new LazyServiceURLResolveException(Messages.LocalConnectionDescriptor_ERROR_MESSAGE_ATTACH_NOT_SUPPORTED);
                }
                AttachPlugin.getLogger().info("No URL found. Attempting to start the Agent!");
                this.startManagementServer();
            } else {
                throw new LazyServiceURLResolveException(Messages.LocalConnectionDescriptor_ERROR_AUTO_START_SWITCHED_OFF);
            }
        }
        return this.url;
    }

    private boolean isAutoStartAgent() {
        return this.isAutoStartAgent;
    }

    public boolean equals(Object obj) {
        if (obj instanceof LocalConnectionDescriptor) {
            LocalConnectionDescriptor that = (LocalConnectionDescriptor)obj;
            String pid = this.getPID();
            if (pid == null) {
                return false;
            }
            return pid.equals(that.getPID());
        }
        return false;
    }

    public String getPID() {
        Object pid = this.getExtendedProperties().get("com.jrockit.connectioninfo.pid");
        if (pid == null) {
            return "0";
        }
        return pid.toString();
    }

    public boolean isAttachable() {
        Boolean isAttachable = (Boolean)this.getExtendedProperties().get(EXTENDED_PROPERTY_KEY_ATTACHABLE);
        return isAttachable != null && isAttachable != false;
    }

    public int hashCode() {
        return this.getPID().hashCode();
    }

    private static final boolean fetchAutoStartAgentFromStore() {
        return AttachPlugin.getDefault().getPreferenceStore().getBoolean("autoStartPreference");
    }

    public Map getEnvironment() {
        return this.environment;
    }

    public Map getExtendedProperties() {
        return this.extendedProperties;
    }

    public String getGUID() {
        return this.m_guid;
    }

    public String getName() {
        return this.connectionName;
    }

    public String toString() {
        return "LocalConnectionDescriptor [PID=" + this.getPID() + "]";
    }
}

