/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.browser.attach;

import com.jrockit.mc.rjmx.ConnectionException;
import com.jrockit.mc.rjmx.IConnectionDescriptor;
import com.jrockit.mc.rjmx.IConnectionHandle;
import com.jrockit.mc.rjmx.JMXDescriptorBuilder;
import com.jrockit.mc.rjmx.core.RJMXPlugin;
import com.jrockit.mc.rjmx.internal.JMXConnectionDescriptor;
import com.jrockit.mc.rjmx.proxy.IProxyOperations;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class AttachPlugin
extends AbstractUIPlugin {
    private static final Logger LOGGER;
    private static AttachPlugin plugin;
    private static final boolean isLocalAttachAvailable;
    private static final int localPID;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    static {
        boolean available;
        LOGGER = Logger.getLogger("com.jrockit.mc.browser.attach");
        try {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("com.jrockit.mc.browser.attach.AttachPlugin");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            ClassLoader loader = clazz.getClassLoader();
            URL toolsJar = AttachPlugin.getToolsJar();
            ClassLoader parent = ClassLoader.getSystemClassLoader();
            if (toolsJar == null) {
                AttachPlugin.getLogger().log(Level.FINE, "Could not locate tools.jar.");
            } else if (parent instanceof URLClassLoader) {
                try {
                    Class<?> clazz2 = class$1;
                    if (clazz2 == null) {
                        try {
                            clazz2 = class$1 = Class.forName("java.net.URLClassLoader");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    Class[] classArray = new Class[1];
                    Class<?> clazz3 = class$2;
                    if (clazz3 == null) {
                        try {
                            clazz3 = class$2 = Class.forName("java.net.URL");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    classArray[0] = clazz3;
                    Method addURL = clazz2.getDeclaredMethod("addURL", classArray);
                    addURL.setAccessible(true);
                    addURL.invoke((Object)parent, toolsJar);
                }
                catch (Exception e) {
                    AttachPlugin.getLogger().log(Level.FINE, "Could not append tools.jar to app classloader.", e);
                }
            }
            Class.forName("com.sun.tools.attach.VirtualMachine", false, loader);
            Class.forName("com.sun.tools.attach.AttachNotSupportedException", false, loader);
            Class.forName("sun.management.ConnectorAddressLink", false, loader);
            Class.forName("sun.jvmstat.monitor.MonitorException", false, loader);
            available = true;
        }
        catch (Throwable t) {
            available = false;
            AttachPlugin.getLogger().log(Level.FINE, "Attach plugin will not be enabled.", t);
        }
        localPID = AttachPlugin.initPID();
        AttachPlugin.getLogger().fine("Acquired local PID. PID resolved to " + localPID);
        isLocalAttachAvailable = available;
    }

    public AttachPlugin() {
        plugin = this;
    }

    private static int initPID() {
        IConnectionHandle model = null;
        IConnectionDescriptor descriptor = new JMXDescriptorBuilder().hostName("localhost").port(0).build();
        try {
            model = RJMXPlugin.getDefault().getConnectionManager().connect(descriptor);
            Class<?> clazz = class$3;
            if (clazz == null) {
                try {
                    clazz = class$3 = Class.forName("com.jrockit.mc.rjmx.proxy.IProxyOperations");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            int n = ((IProxyOperations)model.getService((Class)clazz)).getPID();
            return n;
        }
        catch (Exception e) {
            if (!JMXConnectionDescriptor.SUPPORTS_JMXRMI) {
                AttachPlugin.getLogger().log(Level.INFO, "Could not determine own PID. You are most likely running a 1.4 version, so this is expected.", e);
            } else {
                AttachPlugin.getLogger().log(Level.WARNING, "Could not determine own PID.", e);
            }
        }
        finally {
            if (model != null) {
                try {
                    RJMXPlugin.getDefault().getConnectionManager().disconnect(model);
                }
                catch (ConnectionException connectionException) {}
            }
        }
        return 0;
    }

    public static AttachPlugin getDefault() {
        return plugin;
    }

    public static Logger getLogger() {
        return LOGGER;
    }

    public static boolean isLocalAttachAvailable() {
        return isLocalAttachAvailable;
    }

    private static URL getToolsJar() {
        try {
            String javaHome = System.getProperty("java.home");
            File toolsJarFile = new File(javaHome, "../lib/tools.jar").getCanonicalFile();
            if (toolsJarFile.exists()) {
                return toolsJarFile.toURI().toURL();
            }
        }
        catch (IOException ioe) {
            AttachPlugin.getLogger().log(Level.FINER, "Problem locating tools.jar.", ioe);
        }
        return null;
    }

    public static int getPID() {
        return localPID;
    }
}

