package oracle.i18n.demo.obe.gdkshop;

import oracle.i18n.demo.obe.gdkshop.bean.Customer;

import java.util.List;

import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import oracle.i18n.servlet.ServletHelper;
import oracle.i18n.servlet.Localizer;

public class MyAccountAction extends HttpServlet
{
  public void doPost(HttpServletRequest request, HttpServletResponse response)
  {
    String userid = (String) request.getSession().getAttribute("userid");
    try
    {
      if (userid != null)
      {
        Localizer localizer = ServletHelper.getLocalizerInstance(request);
        request.setAttribute("localizer", localizer);
        List orderLst = ShopAction.getOrders(userid);
        request.setAttribute("orders", orderLst);
        Customer customer = ShopAction.getCustomer(userid);
        request.setAttribute("customer", customer);
        request.getRequestDispatcher("myaccount.jsp").forward(request, response);
      }
      else
        request.getRequestDispatcher("index.jsp").forward(request, response);
    }
    catch (Exception e)
    {
      throw new IllegalStateException(e.getMessage());
    }
  }

  public void doGet(HttpServletRequest request, HttpServletResponse response)
  {
    doPost(request, response);
  }
}
