/*
 * Decompiled with CFR 0.152.
 */
package oracle.i18n.util.builder;

import java.io.Serializable;
import java.util.Vector;
import oracle.i18n.util.GDKOracleMetaData;

public abstract class UnicodeMap
implements Serializable {
    static final long serialVersionUID = GDKOracleMetaData.getOracleVersionID();
    static final int INDEX_ARRAY_SIZE = 256;
    static final int DATA_ARRAY_MAX = 65536;
    static final char HIGH_BYTE_MASK = '\uff00';
    static final char LOW_BYTE_MASK = '\u00ff';
    static final int ONE_BYTE_SHIFT = 8;
    static final int TWO_BYTE_SHIFT = 16;
    static final int LOW_2BYTE_MASK = 65535;
    protected int[] indexArray = null;
    protected int[][] surrogateTable = null;

    protected void setIndexArray(int[] nArray) {
        this.indexArray = new int[256];
        int n = 0;
        while (n < 256) {
            this.indexArray[n] = nArray[n];
            ++n;
        }
    }

    protected void setSurrogateTable(Vector vector) {
        if (vector == null) {
            return;
        }
        int n = vector.size();
        if (n > 0) {
            this.surrogateTable = new int[n][1024];
            int n2 = 0;
            while (n2 < n) {
                System.arraycopy((int[])vector.elementAt(n2), 0, this.surrogateTable[n2], 0, 1024);
                ++n2;
            }
        }
    }
}

