/*
 * Decompiled with CFR 0.152.
 */
package oracle.i18n.util.builder;

import java.io.IOException;
import java.util.HashMap;
import java.util.Vector;
import oracle.i18n.util.ConverterArchive;
import oracle.i18n.util.builder.CharSetParser;
import oracle.i18n.util.builder.LinguisticParser;
import oracle.i18n.util.builder.NLTParserException;
import oracle.i18n.util.builder.OraLinguisticSetter;
import oracle.i18n.util.builder.UnicodeMapChar;

public class LinguisticBuilder {
    private static final String LINGPREFIX = "lx3";
    private static final String CONVERTERDIR = "/oracle/i18n/data/";
    private static final String HEXPREFIX = "0000";
    private static final int SECONDARYDIFFERENCEONLY = -256;
    static final short PRIMARY_BEGIN = 1;
    static final short SECONDARY_BEGIN = 2;
    static final short TERTIARY_BEGIN = 4;
    static final short GAP = 8;
    static final short EQUAL = 16;
    static final short GREATER = 32;
    static final byte SECONDARY_ONLY = 1;
    static final byte TERTIARY_ONLY = 2;
    static final byte OTHERS = 3;
    static final short CS_TERTIARY_DIFF = 25;
    static final short BASE_PRIMARY_PART = 31;
    static final short BASE_SECONDARY_PART = 1;
    static final short BASE_TERTIARY_PART = 1;
    static final short BASE_TERTIARY_VAL = 31;
    static final int FIRST_LEVEL_LENGTH = 256;
    static final int SECOND_LEVEL_LENGTH = 65536;
    static final int TWOBYTESHIFT = 16;
    static final int ONEBYTESHIFT = 8;
    static final int LOWBYTEMASK = 255;
    static final int HIGHBYTEMASK = 65280;
    static final int LOWTWOBYTEMASK = 65535;
    static final int HIGHTWOBYTEMASK = -65536;

    public static void buildGLB(String string, String string2, String string3, boolean bl) throws IOException {
        block11: {
            LinguisticParser linguisticParser = null;
            try {
                linguisticParser = new LinguisticParser(string3);
            }
            catch (NLTParserException nLTParserException) {
                System.err.println(nLTParserException.getMessage());
                return;
            }
            OraLinguisticSetter oraLinguisticSetter = new OraLinguisticSetter();
            try {
                Object object;
                oraLinguisticSetter.setVersion(linguisticParser.getVersion());
                oraLinguisticSetter.setSortName(linguisticParser.getName());
                oraLinguisticSetter.setSortId(linguisticParser.getId());
                oraLinguisticSetter.setBaseSortId(linguisticParser.getBaseSortId());
                oraLinguisticSetter.setBaseSortName(linguisticParser.getBaseSortName());
                Vector vector = linguisticParser.getMajorSort();
                if (vector == null) {
                    oraLinguisticSetter.setMonolingual(false);
                    oraLinguisticSetter.setReverseSec(linguisticParser.getReverseSecondary());
                    oraLinguisticSetter.setSwapWithNext(linguisticParser.getSwapWithNext());
                    oraLinguisticSetter.setCanonicalEq(linguisticParser.getCanonicalEquivalence());
                    oraLinguisticSetter.setHangulJamo(linguisticParser.getHangulJamoComp());
                    object = new int[1024][];
                    Vector vector2 = new Vector();
                    Vector vector3 = new Vector();
                    int[] nArray = new int[65536];
                    LinguisticBuilder.processCollationRules(linguisticParser, oraLinguisticSetter, nArray, (int[][])object, vector3);
                    LinguisticBuilder.processExpandingRules(linguisticParser, oraLinguisticSetter, nArray, vector2);
                    LinguisticBuilder.processContextSensitiveRules(linguisticParser, oraLinguisticSetter, nArray);
                    if (oraLinguisticSetter.isCanonicalEq()) {
                        LinguisticBuilder.processDecomposition(nArray, (int[][])object, vector2, vector3, oraLinguisticSetter, string3);
                    }
                    oraLinguisticSetter.setExpandingTable(vector2);
                    oraLinguisticSetter.setContractTable(vector3);
                    Vector[] vectorArray = new Vector[16];
                    OraLinguisticSetter.compressSurrogateTables((int[][])object, nArray, vectorArray);
                    oraLinguisticSetter.setSurrogateTable(vectorArray);
                    int[] nArray2 = new int[256];
                    int n = OraLinguisticSetter.compressIntArray(nArray, nArray2);
                    oraLinguisticSetter.setCollationLevel1(nArray2);
                    oraLinguisticSetter.setCollationLevel2(n, nArray);
                    oraLinguisticSetter.setLatinOneTable();
                } else {
                    int n;
                    oraLinguisticSetter.setMonolingual(true);
                    object = linguisticParser.getMinorSort();
                    int[] nArray = new int[65536];
                    if (vector != null) {
                        int n2 = 0;
                        n = vector.size();
                        n2 = 0;
                        while (n2 < n) {
                            int n3;
                            Object[] objectArray = (Object[])vector.elementAt(n2);
                            int[] nArray3 = (int[])objectArray[0];
                            int[] nArray4 = (int[])objectArray[1];
                            char c = (char)(nArray3[0] & 0xFFFF);
                            int n4 = nArray4[0];
                            objectArray = (Object[])((HashMap)object).get(new Integer(nArray3[0]));
                            int n5 = objectArray == null ? 0 : ((int[])objectArray[0])[0];
                            nArray[c] = n3 = LinguisticBuilder.combineKey(n4, 1, n5);
                            ++n2;
                        }
                    }
                    LinguisticBuilder.processSpeicalLetters(linguisticParser, oraLinguisticSetter, nArray);
                    LinguisticBuilder.processCombinationLetters(linguisticParser, oraLinguisticSetter, nArray);
                    int[] nArray5 = new int[256];
                    n = OraLinguisticSetter.compressIntArray(nArray, nArray5);
                    oraLinguisticSetter.setCollationLevel1(nArray5);
                    oraLinguisticSetter.setCollationLevel2(n, nArray);
                    LinguisticBuilder.processBaseLetters(linguisticParser, oraLinguisticSetter);
                }
                object = new ConverterArchive();
                if (bl) {
                    ((ConverterArchive)object).insertObjtoFile(string, LinguisticBuilder.formatFileName(oraLinguisticSetter.getId()) + ".glb", oraLinguisticSetter);
                    break block11;
                }
                ((ConverterArchive)object).insertSingleObj(string2, oraLinguisticSetter, CONVERTERDIR + LinguisticBuilder.formatFileName(oraLinguisticSetter.getId()) + ".glb");
            }
            catch (NLTParserException nLTParserException) {
                System.out.println(nLTParserException.getMessage());
            }
            catch (IOException iOException) {
                System.err.println(iOException.getMessage());
            }
        }
    }

    private static int combineKey(int n, int n2, int n3) {
        if (((long)n & 0xFFFFFFFFL) >= 0xFFF00000L) {
            return n;
        }
        return (n << 16) + (n2 << 8) + n3;
    }

    /*
     * Unable to fully structure code
     */
    private static void processCollationRules(LinguisticParser var0, OraLinguisticSetter var1_1, int[] var2_2, int[][] var3_3, Vector var4_4) throws NLTParserException {
        block38: {
            var5_5 = 0L;
            var7_6 = 0;
            var8_7 = 0;
            var9_8 = var0.getCollationRules((byte)1);
            var10_9 = 0;
            var11_10 = 0;
            if (var9_8 != null) {
                var10_9 = var9_8.size();
                var8_7 = 0;
                var5_5 = 0;
                var7_6 = 1;
                var11_10 = 0;
                while (var11_10 < var10_9) {
                    var14_11 = (int[])var9_8.elementAt(var11_10);
                    if (var14_11.length != 2) {
                        System.out.println("bug!!!");
                    }
                    if (((var15_12 = var14_11[0]) & 2) == 0) {
                        System.out.println("bug!!!");
                    }
                    if ((var15_12 & 8) != 0) {
                        var7_6 += var14_11[1];
                    } else {
                        if ((var15_12 & 16) == 0) {
                            ++var7_6;
                        }
                        var2_2[var14_11[1] & 65535] = var16_13 = LinguisticBuilder.combineKey((int)var5_5, var7_6, var8_7);
                    }
                    ++var11_10;
                }
            }
            if ((var9_8 = var0.getCollationRules((byte)2)) != null) {
                var10_9 = var9_8.size();
                var7_6 = 0;
                var5_5 = 0;
                var8_7 = 31;
                var15_12 = 0;
                var11_10 = 0;
                while (var11_10 < var10_9) {
                    var14_11 = (int[])var9_8.elementAt(var11_10);
                    var15_12 = var14_11[0];
                    if (var14_11.length != 2 || (var15_12 & 4) == 0) {
                        System.out.println("bug!!!!");
                    }
                    if ((var15_12 & 8) != 0) {
                        var8_7 += var14_11[1];
                    } else {
                        if ((var15_12 & 16) == 0) {
                            ++var8_7;
                        }
                        var2_2[var14_11[1] & 65535] = var16_13 = LinguisticBuilder.combineKey((int)var5_5, var7_6, var8_7);
                    }
                    ++var11_10;
                }
            }
            if ((var9_8 = var0.getCollationRules((byte)3)) == null) break block38;
            var10_9 = var9_8.size();
            var5_5 = 31L;
            var7_6 = 1;
            var8_7 = 1;
            var17_14 = false;
            var18_15 = false;
            var19_16 = false;
            var11_10 = 0;
            while (var11_10 < var10_9) {
                var14_11 = (int[])var9_8.elementAt(var11_10);
                var17_14 = false;
                var18_15 = false;
                var19_16 = false;
                var20_19 = var14_11.length;
                if (var20_19 < 2) {
                    System.out.println("BUG!!!");
                }
                if (((var15_12 = var14_11[0]) & 16) != 0) ** GOTO lbl-1000
                if ((var15_12 & 1) != 0) {
                    var7_6 = 1;
                    var8_7 = 1;
                    var17_14 = true;
                    var5_5 = var5_5 < 65471L || var5_5 >= 0xFFF00000L ? ++var5_5 : 0xFFF00001L;
                }
                if ((var15_12 & 2) != 0) {
                    var18_15 = true;
                    var8_7 = 1;
                    ++var7_6;
                }
                if ((var15_12 & 4) != 0) {
                    var19_16 = true;
                    ++var8_7;
                }
                if ((var15_12 & 8) != 0) {
                    if (var19_16) {
                        var8_7 += var14_11[1] - 1;
                    } else if (var18_15) {
                        var7_6 += var14_11[1] - 1;
                    } else if (var17_14) {
                        var5_5 += (long)(var14_11[1] - 1);
                    }
                    if (var5_5 >= 65472L && var5_5 < 0xFFF00000L) {
                        var5_5 = 0xFFF00000L + (long)var14_11[1];
                    }
                } else lbl-1000:
                // 2 sources

                {
                    var16_13 = LinguisticBuilder.combineKey((int)var5_5, var7_6, var8_7);
                    if (var20_19 == 2) {
                        var2_2[var14_11[1] & 65535] = var16_13;
                    } else if (var20_19 == 3 && var14_11[1] >= 55296 && var14_11[1] <= 56319 && var14_11[2] >= 56320 && var14_11[2] <= 57343) {
                        OraLinguisticSetter.processSurrogate(var3_3, var14_11[1], var14_11[2], var16_13);
                    } else {
                        var21_20 = new int[--var20_19 + 3];
                        var21_20[0] = var20_19;
                        var21_20[1] = var16_13;
                        var21_20[2] = 0;
                        var12_17 = 3;
                        while (var12_17 < var20_19 + 3) {
                            var21_20[var12_17] = var14_11[var12_17 - 2];
                            ++var12_17;
                        }
                        if (var2_2[var14_11[1]] != 0) {
                            if (var1_1.isContracting(var2_2[var14_11[1]])) {
                                var22_21 = var1_1.getIndex(var2_2[var14_11[1]]);
                                var23_23 = (int[])var4_4.elementAt(var22_21);
                                var12_17 = 0;
                                while (var12_17 < var23_23[2] + 1) {
                                    var24_25 = (int[])var4_4.elementAt(var22_21 + var12_17);
                                    if (var20_19 >= var24_25[0]) {
                                        var21_20[2] = var24_25[2] + 1;
                                        break;
                                    }
                                    ++var12_17;
                                }
                                var4_4.insertElementAt(var21_20, var22_21 + var12_17);
                                var13_18 = 0;
                                while (var13_18 < var12_17) {
                                    var24_25 = (int[])var4_4.elementAt(var22_21 + var13_18);
                                    var24_25[2] = var24_25[2] + 1;
                                    ++var13_18;
                                }
                            } else {
                                var21_20[2] = 1;
                                var22_22 = new int[]{1, var2_2[var14_11[1]], 0, var14_11[1]};
                                var23_24 = var4_4.size();
                                var4_4.addElement(var21_20);
                                var4_4.addElement(var22_22);
                                var2_2[var14_11[1]] = var16_13 = -4128768 + (var23_24 & 65535);
                            }
                        } else {
                            var22_21 = var4_4.size();
                            var4_4.addElement(var21_20);
                            var2_2[var14_11[1]] = var16_13 = -4128768 + (var22_21 & 65535);
                        }
                    }
                }
                ++var11_10;
            }
        }
    }

    private static void processExpandingRules(LinguisticParser linguisticParser, OraLinguisticSetter oraLinguisticSetter, int[] nArray, Vector vector) throws NLTParserException {
        Vector vector2 = linguisticParser.getExpandingRules();
        if (vector2 == null) {
            return;
        }
        int n = vector2.size();
        if (n == 0) {
            return;
        }
        int n2 = 0;
        while (n2 < n) {
            int n3;
            int n4;
            Object[] objectArray = (Object[])vector2.elementAt(n2);
            int[] nArray2 = (int[])objectArray[0];
            int[] nArray3 = (int[])objectArray[1];
            String string = (String)objectArray[2];
            int n5 = 0;
            if (string != null) {
                if (string.equalsIgnoreCase("G")) {
                    n5 = 1;
                } else if (string.equalsIgnoreCase("L")) {
                    n5 = -1;
                }
            }
            int n6 = 0;
            if (objectArray[3] != null) {
                n6 = (Integer)objectArray[3];
            }
            int n7 = 0;
            int n8 = 0;
            if (n6 == 2) {
                n7 = 1;
            } else if (n6 == 3) {
                n8 = 1;
            }
            char c = (char)nArray2[0];
            Vector<Integer> vector3 = new Vector<Integer>();
            int n9 = 0;
            while (n9 < nArray3.length) {
                n4 = nArray[nArray3[n9]];
                if (n4 == 0) {
                    n4 = -65536;
                    vector3.addElement(new Integer(n4 += n5 * n7 << 8 + n5 * n8));
                } else if (!oraLinguisticSetter.isExpanding(n4)) {
                    vector3.addElement(new Integer(n4 += n5 * n7 << 8 + n5 * n8));
                } else {
                    n3 = oraLinguisticSetter.getIndex(n4);
                    int[] nArray4 = (int[])vector.elementAt(n3);
                    int n10 = 0;
                    while (n10 < nArray4.length) {
                        vector3.addElement(new Integer(nArray4[n10] + n5 * n7 << 8 + n5 * n8));
                        ++n10;
                    }
                }
                ++n9;
            }
            n4 = vector.size();
            nArray[nArray2[0]] = n3 = -4063232 + (n4 & 0xFFFF);
            vector.addElement(vector3);
            ++n2;
        }
    }

    private static void processContextSensitiveRules(LinguisticParser linguisticParser, OraLinguisticSetter oraLinguisticSetter, int[] nArray) throws NLTParserException {
        Vector vector = linguisticParser.getContextSensitiveRules();
        if (vector == null) {
            return;
        }
        int n = vector.size();
        if (n == 0) {
            return;
        }
        boolean bl = true;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        Vector<int[]> vector2 = new Vector<int[]>();
        int n6 = 0;
        while (n6 < n) {
            block12: {
                int n7;
                int[] nArray2;
                block13: {
                    block14: {
                        int n8;
                        int[] nArray3;
                        block11: {
                            nArray3 = (int[])vector.elementAt(n6);
                            n8 = nArray3[0];
                            nArray2 = new int[5];
                            if (nArray3.length != 3 && nArray3.length != 4) {
                                return;
                            }
                            if ((n8 & 1) == 0) break block11;
                            bl = true;
                            n3 = nArray3[1];
                            if (nArray3.length == 3) {
                                n4 = 0;
                                n5 = nArray3[2];
                            } else {
                                n4 = nArray3[2];
                                n5 = nArray3[3];
                            }
                            break block12;
                        }
                        if (!bl) {
                            // empty if block
                        }
                        bl = false;
                        n2 = (n8 & 0x10) != 0 ? 0 : 25;
                        n7 = nArray3[nArray3.length - 1];
                        int n9 = nArray[n5] + n2;
                        nArray2[0] = n7;
                        nArray2[1] = 0;
                        nArray2[2] = n9;
                        nArray2[3] = n3;
                        nArray2[4] = n4;
                        if (oraLinguisticSetter.isContextSensitive(nArray[n7])) break block13;
                        if (nArray[n7] != 0) break block14;
                        nArray[n7] = -3997696 + vector2.size();
                        vector2.addElement(nArray2);
                        break block12;
                    }
                    if (nArray2[3] != 0) break block12;
                    nArray2[4] = 0;
                    nArray2[3] = 0;
                    if (n7 != n5) {
                        // empty if block
                    }
                    nArray2[2] = nArray[n7];
                    nArray[n7] = -3997696 + vector2.size();
                    vector2.addElement(nArray2);
                    break block12;
                }
                int n10 = oraLinguisticSetter.getIndex(nArray[n7]);
                int n11 = 0;
                int[] nArray4 = null;
                n11 = 0;
                while (n11 < ((int[])vector2.elementAt(n10))[1] + 1) {
                    nArray4 = (int[])vector2.elementAt(n10 + n11);
                    if (nArray2[3] <= nArray4[3] && nArray2[4] <= nArray4[4]) {
                        nArray2[1] = nArray4[1] + 1;
                        break;
                    }
                    ++n11;
                }
                vector2.insertElementAt(nArray2, n10 + n11);
                int n12 = n10;
                while (n12 < n10 + n11) {
                    nArray4 = (int[])vector2.elementAt(n12);
                    nArray4[1] = nArray4[1] + 1;
                    ++n12;
                }
            }
            ++n6;
        }
        oraLinguisticSetter.setContextSensitiveTable(vector2);
    }

    private static void processSpeicalLetters(LinguisticParser linguisticParser, OraLinguisticSetter oraLinguisticSetter, int[] nArray) throws NLTParserException {
        Vector vector = linguisticParser.getSpecialLetter();
        Vector vector2 = null;
        if (vector != null && vector.size() > 0) {
            int n = vector.size();
            vector2 = new Vector();
            Object[] objectArray = null;
            int n2 = 0;
            int n3 = 0;
            while (n3 < n) {
                objectArray = (Object[])vector.elementAt(n3);
                Vector<Integer> vector3 = new Vector<Integer>();
                int[] nArray2 = (int[])objectArray[0];
                int[] nArray3 = (int[])objectArray[1];
                int[] nArray4 = (int[])objectArray[2];
                int n4 = 0;
                while (n4 < nArray3.length) {
                    vector3.addElement(new Integer(LinguisticBuilder.combineKey(nArray3[n4], 1, nArray4[n4])));
                    ++n4;
                }
                vector2.addElement(vector3);
                nArray[nArray2[0]] = n2 = -4063232 + (n3 & 0xFF);
                ++n3;
            }
            oraLinguisticSetter.setExpandingTable(vector2);
        }
    }

    private static void processCombinationLetters(LinguisticParser linguisticParser, OraLinguisticSetter oraLinguisticSetter, int[] nArray) throws NLTParserException {
        Vector vector = linguisticParser.getCombinationLetter();
        if (vector != null && vector.size() > 0) {
            int n = vector.size();
            Vector<int[]> vector2 = new Vector<int[]>();
            Object[] objectArray = null;
            int n2 = 0;
            while (n2 < n) {
                int n3;
                objectArray = (Object[])vector.elementAt(n2);
                int[] nArray2 = (int[])objectArray[0];
                int[] nArray3 = (int[])objectArray[1];
                int[] nArray4 = (int[])objectArray[2];
                int n4 = LinguisticBuilder.combineKey(nArray3[0], 1, nArray4[0]);
                int n5 = nArray[nArray2[0]];
                int[] nArray5 = new int[nArray2.length + 3];
                int n6 = nArray5[0] = nArray2.length;
                nArray5[1] = n4;
                nArray5[2] = 0;
                int n7 = 0;
                while (n7 < nArray2.length) {
                    nArray5[n7 + 3] = nArray2[n7];
                    ++n7;
                }
                if (nArray[nArray2[0]] != 0) {
                    int[] nArray6;
                    if (oraLinguisticSetter.isContracting(nArray[nArray2[0]])) {
                        int[] nArray7;
                        n3 = oraLinguisticSetter.getIndex(nArray[nArray2[0]]);
                        nArray6 = (int[])vector2.elementAt(n3);
                        n7 = 0;
                        while (n7 < nArray6[2] + 1) {
                            nArray7 = (int[])vector2.elementAt(n3 + n7);
                            if (n6 >= nArray7[0]) {
                                nArray5[2] = nArray7[2] + 1;
                                break;
                            }
                            ++n7;
                        }
                        vector2.insertElementAt(nArray5, n3 + n7);
                        int n8 = 0;
                        while (n8 < n7) {
                            nArray7 = (int[])vector2.elementAt(n3 + n8);
                            nArray7[2] = nArray7[2] + 1;
                            ++n8;
                        }
                    } else {
                        nArray5[2] = 1;
                        nArray6 = new int[]{1, nArray[nArray2[0]], 0, nArray2[0]};
                        n3 = vector2.size();
                        vector2.addElement(nArray5);
                        vector2.addElement(nArray6);
                        nArray[nArray2[0]] = -4128768 + (n3 & 0xFF);
                    }
                } else {
                    n3 = vector2.size();
                    vector2.addElement(nArray5);
                    nArray[nArray2[0]] = -4128768 + (n3 & 0xFF);
                }
                ++n2;
            }
            oraLinguisticSetter.setContractTable(vector2);
        }
    }

    private static void processBaseLetters(LinguisticParser linguisticParser, OraLinguisticSetter oraLinguisticSetter) throws NLTParserException {
        Vector vector = linguisticParser.getBaseLetter();
        Object var4_3 = null;
        if (vector != null) {
            UnicodeMapChar unicodeMapChar = new UnicodeMapChar(vector);
            oraLinguisticSetter.setBaseLetterTable(unicodeMapChar);
        }
    }

    private static int getSurrogate(int[][] nArray, int n, int n2) {
        int n3 = n - 55296;
        int n4 = n2 - 56320;
        return nArray[n3][n4];
    }

    private static void processDecomposition(int[] nArray, int[][] nArray2, Vector vector, Vector vector2, OraLinguisticSetter oraLinguisticSetter, String string) throws NLTParserException {
        String string2 = string.substring(0, string.length() - 11);
        CharSetParser charSetParser = new CharSetParser(string2 + "lx207d0.nlt");
        Vector vector3 = charSetParser.getDecomposition();
        if (vector3 == null) {
            return;
        }
        Object[] objectArray = null;
        int n = vector3.size();
        int n2 = 0;
        while (n2 < n) {
            objectArray = (Object[])vector3.elementAt(n2);
            int[] nArray3 = (int[])objectArray[0];
            int[] nArray4 = (int[])objectArray[1];
            String string3 = (String)objectArray[2];
            if (string3 == null) {
                int n3;
                int n4;
                if (nArray3[0] > 65535) {
                    n4 = (nArray3[0] & 0xFFFF0000) >>> 16;
                    n3 = nArray3[0] & 0xFFFF;
                } else {
                    n4 = 0;
                    n3 = nArray3[0];
                }
                int n5 = 1;
                if ((nArray[n3] & 0xFFFF0000) == 0) {
                    Object object;
                    int n6;
                    int n7 = vector.size();
                    int n8 = -4063232 + n7;
                    int n9 = nArray4.length;
                    if (n4 == 0) {
                        nArray[n3] = n8;
                    } else {
                        OraLinguisticSetter.processSurrogate(nArray2, n4, n3, n8);
                        if (nArray[n4] == 0) {
                            nArray[n4] = -3866624;
                        }
                    }
                    Vector vector4 = new Vector();
                    n8 = nArray[nArray4[0]];
                    n5 = 1;
                    if (oraLinguisticSetter.isSurrogate(n8)) {
                        n8 = LinguisticBuilder.getSurrogate(nArray2, nArray4[0], nArray4[1]);
                        n5 = 2;
                    }
                    if (oraLinguisticSetter.isExpanding(n8)) {
                        n6 = oraLinguisticSetter.getIndex(n8);
                        object = (Vector)vector.elementAt(n6);
                        int n10 = 0;
                        while (n10 < ((Vector)object).size()) {
                            vector4.addElement(((Vector)object).elementAt(n10));
                            ++n10;
                        }
                    } else if (oraLinguisticSetter.isContracting(n8)) {
                        n6 = oraLinguisticSetter.getIndex(n8);
                        object = (int[])vector2.elementAt(n6);
                        int n11 = n6 + object[2] + 1;
                        while (n6 < n11) {
                            object = (int[])vector2.elementAt(n6);
                            if (object[0] <= n9) {
                                int n12 = 0;
                                n12 = 0;
                                while (n12 < object[0]) {
                                    if (object[3 + n12] != nArray4[n12]) break;
                                    ++n12;
                                }
                                if (n12 == object[0]) {
                                    n5 = n12;
                                    vector4.addElement(new Integer((int)object[1]));
                                    break;
                                }
                            }
                            ++n6;
                        }
                        if (n6 == n11) {
                            // empty if block
                        }
                    } else if ((n8 & 0xFF00) == 0 && (n8 & 0xFF) == 0) {
                        if (n9 >= 2) {
                            if (oraLinguisticSetter.isSurrogate(nArray4[0]) && n9 > 1) {
                                vector4.addElement(new Integer(-65536));
                                vector4.addElement(new Integer(nArray4[0] << 16));
                                vector4.addElement(new Integer(-65536));
                                vector4.addElement(new Integer(nArray4[1] << 16));
                                n5 = 2;
                            } else {
                                vector4.addElement(new Integer(-65536));
                                vector4.addElement(new Integer(nArray4[0] << 16));
                            }
                            while (n5 < n9) {
                                if ((nArray[nArray4[n5]] & 0xFFFFFF00) != 0) {
                                    vector4.addElement(new Integer(nArray[nArray4[n5++]] & 0xFFFFFF00));
                                    continue;
                                }
                                vector4.addElement(new Integer(-65536));
                                vector4.addElement(new Integer(nArray4[n5++] << 16));
                            }
                        } else {
                            vector4.addElement(new Integer(-65536));
                            vector4.addElement(new Integer(nArray4[0] << 16));
                        }
                    } else {
                        vector4.addElement(new Integer(nArray[nArray4[0]]));
                        n5 = 1;
                    }
                    while (n5 < n9) {
                        if ((nArray[nArray4[n5]] & 0xFFFFFF00) != 0) {
                            vector4.addElement(new Integer(nArray[nArray4[n5++]] & 0xFFFFFF00));
                            continue;
                        }
                        vector4.addElement(new Integer(nArray4[n5++] << 16));
                    }
                    vector.addElement(vector4);
                }
            }
            ++n2;
        }
    }

    private static int compressCharArray(char[] cArray, int[] nArray) {
        nArray[0] = 0;
        int n = 256;
        int n2 = 1;
        while (n2 < 256) {
            int n3;
            int n4 = 0;
            while (n4 < n) {
                n3 = 0;
                while (n3 < (256 < n - n4 ? 256 : n - n4)) {
                    char c = cArray[n4 + n3];
                    int n5 = n2 << 8;
                    char c2 = cArray[n5 | n3];
                    if (c != c2) break;
                    ++n3;
                }
                if (n3 == (256 < n - n4 ? 256 : n - n4)) break;
                ++n4;
            }
            nArray[n2] = (short)n4;
            n3 = (n2 << 8) + (n - n4);
            while (n3 < n2 + 1 << 8) {
                cArray[n++] = cArray[n3];
                ++n3;
            }
            ++n2;
        }
        return n;
    }

    private static String formatFileName(int n) {
        String string = Integer.toHexString(n);
        String string2 = HEXPREFIX.substring(0, HEXPREFIX.length() - string.length()) + string;
        return LINGPREFIX + string2;
    }

    public static void main(String[] stringArray) {
        try {
            LinguisticBuilder.buildGLB("C:\\lbuilder\\Workspace\\CollationPerf\\classes\\oracle\\i18n\\data\\", null, "c:\\ogs\\src\\oracle\\i18n\\data\\lx30034.nlt", true);
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
        }
    }
}

