/*
 * Decompiled with CFR 0.152.
 */
package oracle.i18n.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Properties;

class ResourceBundleUtil {
    private static final byte[] BYTES_MAGIC = new byte[]{-54, -2, -70, -66};
    private static final byte[] BYTES_VERSIONS = new byte[]{0, 0, 0, 46};
    private static final byte[] BYTES_C01 = new byte[]{10, 0, 6, 0, 15};
    private static final byte[] BYTES_C02 = new byte[]{9, 0, 5, 0, 16};
    private static final byte[] BYTES_C03 = new byte[]{7, 0, 17};
    private static final byte[] BYTES_C04 = new byte[]{7, 0, 18};
    private static final byte[] BYTES_C05 = new byte[]{7, 0, 19};
    private static final byte[] BYTES_C06 = new byte[]{7, 0, 20};
    private static final byte[] BYTES_C15 = new byte[]{12, 0, 9, 0, 10};
    private static final byte[] BYTES_C16 = new byte[]{12, 0, 7, 0, 8};
    private static final byte[] BYTES_CLASS_ATTRIBUTES = new byte[]{0, 33, 0, 5, 0, 6, 0, 0, 0, 1, 0, 26, 0, 7, 0, 8, 0, 0, 0, 3, 0, 1, 0, 9, 0, 10, 0, 1, 0, 11, 0, 0, 0, 17, 0, 1, 0, 1, 0, 0, 0, 5, 42, -73, 0, 1, -79, 0, 0, 0, 0, 0, 1, 0, 12, 0, 13, 0, 1, 0, 11, 0, 0, 0, 16, 0, 1, 0, 1, 0, 0, 0, 4, -78, 0, 2, -80, 0, 0, 0, 0, 0, 8, 0, 14, 0, 10, 0, 1, 0, 11};
    private static final byte[] BYTES_METHOD_ATTRIBUTES = new byte[]{0, 7, 0, 0};
    private static final byte[] BYTES_ANEWARRAY_01 = new byte[]{5, -67, 0, 4, 89, 3};
    private static final byte[] BYTES_ANEWARRAY_02 = new byte[]{83, 89, 4};
    private static final byte[] BYTES_FOOTER = new byte[]{-77, 0, 2, -79, 0, 0, 0, 0, 0, 0};

    static final byte[] getClassByteArray(String string, Properties properties) {
        int n = properties.size();
        if (n == 0) {
            return new byte[0];
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            byteArrayOutputStream.write(BYTES_MAGIC);
            byteArrayOutputStream.write(BYTES_VERSIONS);
            ResourceBundleUtil.writeUb2((char)(4 * n + 21), byteArrayOutputStream);
            byteArrayOutputStream.write(BYTES_C01);
            byteArrayOutputStream.write(BYTES_C02);
            byteArrayOutputStream.write(BYTES_C03);
            byteArrayOutputStream.write(BYTES_C04);
            byteArrayOutputStream.write(BYTES_C05);
            byteArrayOutputStream.write(BYTES_C06);
            ResourceBundleUtil.writeString("m", byteArrayOutputStream);
            ResourceBundleUtil.writeString("[[Ljava/lang/Object;", byteArrayOutputStream);
            ResourceBundleUtil.writeString("<init>", byteArrayOutputStream);
            ResourceBundleUtil.writeString("()V", byteArrayOutputStream);
            ResourceBundleUtil.writeString("Code", byteArrayOutputStream);
            ResourceBundleUtil.writeString("getContents", byteArrayOutputStream);
            ResourceBundleUtil.writeString("()[[Ljava/lang/Object;", byteArrayOutputStream);
            ResourceBundleUtil.writeString("<clinit>", byteArrayOutputStream);
            byteArrayOutputStream.write(BYTES_C15);
            byteArrayOutputStream.write(BYTES_C16);
            ResourceBundleUtil.writeString("[Ljava/lang/Object;", byteArrayOutputStream);
            ResourceBundleUtil.writeString("java/lang/Object", byteArrayOutputStream);
            ResourceBundleUtil.writeString(string.replace('.', '/'), byteArrayOutputStream);
            ResourceBundleUtil.writeString("java/util/ListResourceBundle", byteArrayOutputStream);
            int n2 = 0;
            Enumeration<?> enumeration = properties.propertyNames();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                String string3 = properties.getProperty(string2);
                byteArrayOutputStream.write(8);
                ResourceBundleUtil.writeUb2((char)(22 + n2 * 4), byteArrayOutputStream);
                ResourceBundleUtil.writeString(string2, byteArrayOutputStream);
                byteArrayOutputStream.write(8);
                ResourceBundleUtil.writeUb2((char)(24 + n2 * 4), byteArrayOutputStream);
                ResourceBundleUtil.writeString(string3, byteArrayOutputStream);
                ++n2;
            }
            byteArrayOutputStream.write(BYTES_CLASS_ATTRIBUTES);
            int n3 = 21 * n + 10;
            ResourceBundleUtil.writeUb4(n3 + 12, byteArrayOutputStream);
            byteArrayOutputStream.write(BYTES_METHOD_ATTRIBUTES);
            ResourceBundleUtil.writeUb4(n3, byteArrayOutputStream);
            byteArrayOutputStream.write(17);
            ResourceBundleUtil.writeUb2((char)n, byteArrayOutputStream);
            byteArrayOutputStream.write(new byte[]{-67, 0, 3});
            n2 = 0;
            while (n2 < n) {
                byteArrayOutputStream.write(89);
                byteArrayOutputStream.write(17);
                ResourceBundleUtil.writeUb2((char)n2, byteArrayOutputStream);
                byteArrayOutputStream.write(BYTES_ANEWARRAY_01);
                byteArrayOutputStream.write(19);
                ResourceBundleUtil.writeUb2((char)(22 + n2 * 4 - 1), byteArrayOutputStream);
                byteArrayOutputStream.write(BYTES_ANEWARRAY_02);
                byteArrayOutputStream.write(19);
                ResourceBundleUtil.writeUb2((char)(24 + n2 * 4 - 1), byteArrayOutputStream);
                byteArrayOutputStream.write(new byte[]{83, 83});
                ++n2;
            }
            byteArrayOutputStream.write(BYTES_FOOTER);
        }
        catch (IOException iOException) {}
        return byteArrayOutputStream.toByteArray();
    }

    private static void writeStringLength(byte[] byArray, ByteArrayOutputStream byteArrayOutputStream) {
        byteArrayOutputStream.write((byte)((char)byArray.length & 0xFF00) >> 8);
        byteArrayOutputStream.write((byte)((char)byArray.length & 0xFF));
    }

    private static void writeUb2(char c, ByteArrayOutputStream byteArrayOutputStream) {
        byteArrayOutputStream.write((byte)((c & 0xFF00) >> 8));
        byteArrayOutputStream.write((byte)(c & 0xFF));
    }

    private static void writeUb4(int n, ByteArrayOutputStream byteArrayOutputStream) {
        byteArrayOutputStream.write((byte)((n & 0xFF000000) >> 24));
        byteArrayOutputStream.write((byte)((n & 0xFF0000) >> 16));
        byteArrayOutputStream.write((byte)((n & 0xFF00) >> 8));
        byteArrayOutputStream.write((byte)(n & 0xFF));
    }

    private static void writeString(String string, ByteArrayOutputStream byteArrayOutputStream) throws IOException, UnsupportedEncodingException {
        byteArrayOutputStream.write(new byte[]{1});
        byte[] byArray = string.getBytes("UTF-8");
        ResourceBundleUtil.writeStringLength(byArray, byteArrayOutputStream);
        byteArrayOutputStream.write(byArray);
    }

    private ResourceBundleUtil() {
    }
}

