/*
 * Decompiled with CFR 0.152.
 */
package oracle.i18n.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import oracle.i18n.text.OraBoot;
import oracle.i18n.text.OraLanguage;
import oracle.i18n.text.OraMapTable;
import oracle.i18n.util.Sort;

public class LocaleMapper {
    private static final OraMapTable ISO_ORACLE_NAME_MAPPING = OraMapTable.getInstance(1);
    private static final OraMapTable EMAIL_CHARSET_MAPPING = OraMapTable.getInstance(3);
    public static final int ORACLE = 1;
    public static final int IANA = 2;
    public static final int JAVA = 3;
    public static final int EMAIL_WINDOWS = 4;
    public static final int EMAIL_UNIX = 5;
    public static final int WINDOWS = 6;
    public static final int UNIX = 7;
    private static final Set m_excShortToOraLang = new HashSet(2);
    private static final Locale EN_LOCALE;

    private LocaleMapper() {
    }

    public static String[] getAvailableIANACharacterSets() {
        return CachedArray.ianaCharacterSets.getArray();
    }

    public static String[] getAvailableOraCharacterSets() {
        return CachedArray.oraCharacterSets.getArray();
    }

    public static String getIANACharacterSet(int n, String string) {
        HashMap hashMap = null;
        if (n == 1) {
            hashMap = ISO_ORACLE_NAME_MAPPING.getHashMapAttribute("ORACLE_2_IANA");
        } else if (n == 3) {
            hashMap = ISO_ORACLE_NAME_MAPPING.getHashMapAttribute("JAVA_CHARSET_2_IANA_CHARSET");
        } else {
            return null;
        }
        return (String)hashMap.get(string.toUpperCase(Locale.US));
    }

    public static String getJavaCharacterSet(int n, String string) {
        HashMap hashMap = null;
        if (n == 1) {
            hashMap = ISO_ORACLE_NAME_MAPPING.getHashMapAttribute("NLS_CHARSET_2_JAVA_CHARSET");
        } else if (n == 2) {
            hashMap = ISO_ORACLE_NAME_MAPPING.getHashMapAttribute("IANA_CHARSET_2_JAVA_CHARSET");
        } else {
            return null;
        }
        return (String)hashMap.get(string.toUpperCase(Locale.US));
    }

    public static String getOraCharacterSet(int n, String string) {
        HashMap hashMap = null;
        if (n == 2) {
            String string2;
            hashMap = ISO_ORACLE_NAME_MAPPING.getHashMapAttribute("IANA_2_ORACLE");
            String string3 = (String)hashMap.get(string2 = string.toUpperCase(Locale.US));
            if (string3 != null) {
                return string3;
            }
            if (string2.startsWith("X-ORACLE-") && string2.length() > 9) {
                string3 = string2.substring(9).toUpperCase(Locale.US);
                if (OraBoot.getInstance().getCharSetId(string3) != null) {
                    return string3;
                }
            }
            return null;
        }
        if (n == 3) {
            hashMap = ISO_ORACLE_NAME_MAPPING.getHashMapAttribute("JAVA_CHARSET_2_NLS_CHARSET");
            return (String)hashMap.get(string.toUpperCase(Locale.US));
        }
        return null;
    }

    public static Locale getJavaLocale(String string, String string2) {
        String string3;
        Serializable serializable;
        Object object;
        if (string == null) {
            return null;
        }
        String string4 = string;
        String string5 = EN_LOCALE.getLanguage();
        if (!string.equals("") && (string5 = (String)(object = ISO_ORACLE_NAME_MAPPING.getHashMapAttribute("ORACLE_LANG_2_ISO_A2_LANG")).get(string.toUpperCase(Locale.US))) == null) {
            return null;
        }
        object = null;
        if (string2 == null || (object = string2.toUpperCase(Locale.US)) == null || ((String)object).equals("")) {
            serializable = OraBoot.getInstance();
            object = ((OraBoot)serializable).getTerritoryName(OraLanguage.getInstance(string).getDefaultTerritoryId());
        }
        if ((string3 = (String)(serializable = ISO_ORACLE_NAME_MAPPING.getHashMapAttribute("ORACLE_TERR_2_ISO_A2_TERR")).get(object)) == null) {
            return null;
        }
        return new Locale(string5, string3);
    }

    public static String getOraLanguageFromShortName(String string) {
        return (String)CachedShortToOraLanguage.map.getMap().get(string.toUpperCase(Locale.US));
    }

    public static String getOraLanguage(Locale locale) {
        HashMap hashMap;
        String string;
        String string2;
        if (locale == null) {
            return null;
        }
        HashMap hashMap2 = ISO_ORACLE_NAME_MAPPING.getHashMapAttribute("ISO_A2_LANG_2_ORACLE_LANG");
        String string3 = (String)hashMap2.get(string2 = locale.getLanguage().equals("") ? EN_LOCALE.getLanguage() : locale.getLanguage());
        if (string3 == null) {
            return null;
        }
        String string4 = locale.getCountry();
        if (string4.equals("")) {
            string4 = EN_LOCALE.getCountry();
        }
        if ((string = (String)(hashMap = ISO_ORACLE_NAME_MAPPING.getHashMapAttribute("ISO_LOCALE_2_ORACLE_LOCALE")).get(string2 + "_" + string4)) != null) {
            return string.substring(0, string.indexOf(95));
        }
        return string3;
    }

    public static String getOraTerritory(Locale locale) {
        Cloneable cloneable;
        HashMap hashMap;
        if (locale == null) {
            return null;
        }
        String string = locale.getLanguage();
        if (string.equals("")) {
            string = EN_LOCALE.getLanguage();
        } else {
            hashMap = ISO_ORACLE_NAME_MAPPING.getHashMapAttribute("ISO_A2_LANG_2_ORACLE_LANG");
        }
        hashMap = ISO_ORACLE_NAME_MAPPING.getHashMapAttribute("ISO_A2_TERR_2_ORACLE_TERR");
        String string2 = locale.getCountry();
        if (string2.equals("") && (string2 = (String)(cloneable = ISO_ORACLE_NAME_MAPPING.getHashMapAttribute("ISO_LANGUAGE_DEFAULT_TERRITORY")).get(string)) == null) {
            return null;
        }
        cloneable = new Locale(string, string2);
        HashMap hashMap2 = ISO_ORACLE_NAME_MAPPING.getHashMapAttribute("ISO_LOCALE_2_ORACLE_LOCALE");
        String string3 = (String)hashMap2.get(((Locale)cloneable).toString());
        if (string3 != null) {
            return string3.substring(string3.indexOf(95) + 1);
        }
        return (String)hashMap.get(string2);
    }

    public static String[] getIANACharSetFromLocale(int n, Locale locale) {
        return LocaleMapper.getIANACharSetFromOraLang(n, LocaleMapper.getOraLanguage(locale));
    }

    public static String[] getIANACharSetFromOraLang(int n, String string) {
        String[] stringArray = LocaleMapper.getOraCharSetFromOraLang(n, string);
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (stringArray[n2] != null) {
                arrayList.add(LocaleMapper.getIANACharacterSet(1, stringArray[n2]));
            }
            ++n2;
        }
        return arrayList.toArray(new String[0]);
    }

    public static String[] getOraCharSetFromOraLang(int n, String string) {
        String[] stringArray = null;
        switch (n) {
            case 4: {
                HashMap hashMap = EMAIL_CHARSET_MAPPING.getHashMapAttribute("EMAIL_LANG_2_CHARSET_WIN");
                stringArray = (String[])hashMap.get(string);
                if (stringArray != null) break;
                return new String[]{"UTF8"};
            }
            case 5: {
                HashMap hashMap = EMAIL_CHARSET_MAPPING.getHashMapAttribute("EMAIL_LANG_2_CHARSET");
                stringArray = (String[])hashMap.get(string);
                if (stringArray != null) break;
                return new String[]{"UTF8"};
            }
            case 6: {
                stringArray = OraLanguage.getInstance(string).getLocalCharsetsWin();
                break;
            }
            case 7: {
                stringArray = OraLanguage.getInstance(string).getLocalCharacterSets();
                break;
            }
            default: {
                return new String[0];
            }
        }
        return stringArray;
    }

    public static String getOraLangFromJavaLang(String string) {
        if (string == null) {
            return null;
        }
        HashMap hashMap = ISO_ORACLE_NAME_MAPPING.getHashMapAttribute("ISO_A2_LANG_2_ORACLE_LANG");
        return hashMap != null ? hashMap.get(string.toLowerCase(Locale.US)) : null;
    }

    public static String getJavaLangFromOraLang(String string) {
        if (string == null) {
            return null;
        }
        HashMap hashMap = ISO_ORACLE_NAME_MAPPING.getHashMapAttribute("ORACLE_LANG_2_ISO_A2_LANG");
        return hashMap != null ? hashMap.get(string.toUpperCase(Locale.US)) : null;
    }

    public static String getOraTerrFromJavaTerr(String string) {
        if (string == null) {
            return null;
        }
        HashMap hashMap = ISO_ORACLE_NAME_MAPPING.getHashMapAttribute("ISO_A2_TERR_2_ORACLE_TERR");
        return hashMap != null ? hashMap.get(string.toUpperCase(Locale.US)) : null;
    }

    public static String getJavaTerrFromOraTerr(String string) {
        if (string == null) {
            return null;
        }
        HashMap hashMap = ISO_ORACLE_NAME_MAPPING.getHashMapAttribute("ORACLE_TERR_2_ISO_A2_TERR");
        return hashMap != null ? hashMap.get(string.toUpperCase(Locale.US)) : null;
    }

    static /* synthetic */ OraMapTable access$000() {
        return ISO_ORACLE_NAME_MAPPING;
    }

    static {
        m_excShortToOraLang.add("NUMERIC DATE LANGUAGE");
        m_excShortToOraLang.add("BENGALI");
        EN_LOCALE = new Locale("en", "US");
    }

    private static class CachedShortToOraLanguage {
        public static final CachedShortToOraLanguage map = new CachedShortToOraLanguage();
        private final Map m_shortToOraLanguageMap = new HashMap();

        private CachedShortToOraLanguage() {
            String[] stringArray = OraBoot.getInstance().availableLanguages();
            int n = 0;
            while (n < stringArray.length) {
                if (!m_excShortToOraLang.contains(stringArray[n])) {
                    this.m_shortToOraLanguageMap.put(OraLanguage.getInstance(stringArray[n]).getISOAbbreviation(), stringArray[n]);
                }
                ++n;
            }
        }

        public Map getMap() {
            return this.m_shortToOraLanguageMap;
        }
    }

    private static class CachedArray {
        public static final CachedArray ianaCharacterSets = new CachedArray(LocaleMapper.access$000().getHashMapAttribute("IANA_2_ORACLE").keySet());
        public static final CachedArray oraCharacterSets = new CachedArray(LocaleMapper.access$000().getHashMapAttribute("ORACLE_2_IANA").keySet());
        private final String[] m_array;

        private CachedArray(Set set) {
            this.m_array = new String[set.size()];
            int n = 0;
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                this.m_array[n] = (String)iterator.next();
                ++n;
            }
            Sort.quickSort(this.m_array, 0, this.m_array.length - 1);
        }

        public String[] getArray() {
            return this.m_array;
        }
    }
}

