/*
 * Decompiled with CFR 0.152.
 */
package oracle.i18n.util.CharConvBuilder;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import oracle.i18n.text.converter.CharacterConverter12Byte;
import oracle.i18n.util.CharConvBuilder.MappingSetter;
import oracle.sql.converter.CharacterConverters;

public class MultiByte12MapSetter
extends MappingSetter {
    static final int ENTRYWIDTH = 18;
    static final int MAXCHARVALUE = 65535;
    int m_ucsReplacement;
    Vector mapStore;
    CharacterConverter12Byte m_charConv;

    MultiByte12MapSetter(CharacterConverters characterConverters, CharacterConverter12Byte characterConverter12Byte, int n, int n2) throws IOException {
        super(n);
        this.m_ucsReplacement = n2;
        this.mapStore = new Vector();
        this.m_charConv = characterConverter12Byte;
        if (characterConverters != null) {
            Vector vector = new Vector(65535, 28671);
            characterConverters.extractCodepoints(vector);
            int n3 = 0;
            while (n3 < vector.size()) {
                int[] nArray = (int[])vector.elementAt(n3);
                this.set(nArray[0], nArray[1]);
                ++n3;
            }
        }
    }

    MultiByte12MapSetter(int n, int n2, int n3) {
        super(n);
        this.mapStore = new Vector();
    }

    boolean set(int n, int n2) throws IOException {
        if (n > 65535) {
            this.printErrorMsg("***** Error: source code point " + MappingSetter.intToHex8(n) + " is too big for 1-2 byte converter");
            return false;
        }
        n2 = (int)MappingSetter.convertUTF32toUTF16((long)n2 & 0xFFFFFFFFL);
        int[] nArray = new int[]{n, n2};
        this.mapStore.addElement(nArray);
        return true;
    }

    void finish() {
        this.buildMapping();
    }

    void buildMapping() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int[] nArray;
        int n6 = 8;
        int n7 = 8;
        int n8 = (1 << n6) - 1;
        int n9 = (1 << n7) - 1;
        int n10 = 1 << n6;
        char[] cArray = new char[n10];
        char[][] cArray2 = new char[n10][2];
        int n11 = 0;
        while (n11 < n10) {
            cArray[n11] = 65535;
            cArray2[n11][0] = (char)n9;
            cArray2[n11][1] = '\u0000';
            ++n11;
        }
        int n12 = this.mapStore.size();
        Hashtable<Integer, Integer> hashtable = new Hashtable<Integer, Integer>();
        Hashtable hashtable2 = new Hashtable();
        n11 = 0;
        while (n11 < n12) {
            nArray = (int[])this.mapStore.elementAt(n11);
            n5 = nArray[1];
            if (n5 != -1) {
                n4 = nArray[0];
                if (hashtable.get(new Integer(n5)) == null) {
                    hashtable.put(new Integer(n5), new Integer(n4));
                } else {
                    hashtable2.put(new Integer(n5), hashtable.get(new Integer(n5)));
                }
                n3 = n4 >> n7 & n8;
                cArray[n3] = '\u0001';
                n2 = n4 & n9;
                if (n2 < cArray2[n3][0]) {
                    cArray2[n3][0] = (char)n2;
                }
                if (n2 > cArray2[n3][1]) {
                    cArray2[n3][1] = (char)n2;
                }
            }
            ++n11;
        }
        int n13 = n = n9 + 1;
        int n14 = 0;
        n11 = 0;
        while (n11 < n10) {
            if (cArray[n11] != '\uffff') {
                int n15 = cArray2[n11][0];
                cArray[n11] = (char)(n13 - (n14 < n15 ? n14 : n15));
                n13 = cArray[n11] + n;
                n14 = n - cArray2[n11][1] - 1;
            }
            ++n11;
        }
        int[] nArray2 = new int[n13];
        n11 = 0;
        while (n11 < n13) {
            nArray2[n11] = -1;
            ++n11;
        }
        n12 = this.mapStore.size();
        n11 = 0;
        while (n11 < n12) {
            nArray = (int[])this.mapStore.elementAt(n11);
            n5 = nArray[1];
            if (n5 != -1) {
                n4 = nArray[0];
                n3 = n4 >> n7 & n8;
                n2 = n4 & n9;
                int n16 = cArray[n3] + n2;
                nArray2[n16] = n5;
            }
            ++n11;
        }
        this.setArray2(nArray2);
        this.setArray(cArray);
        this.setDuplicateMapping(hashtable2);
    }

    void setArray2(int[] nArray) {
        int n = nArray.length;
        this.m_charConv.m_ucsCharLevel2 = new int[n];
        int n2 = 0;
        while (n2 < n) {
            this.m_charConv.m_ucsCharLevel2[n2] = nArray[n2];
            ++n2;
        }
    }

    void setArray(char[] cArray) {
        int n = cArray.length;
        this.m_charConv.m_ucsCharLevel1 = new char[n];
        int n2 = 0;
        while (n2 < n) {
            this.m_charConv.m_ucsCharLevel1[n2] = cArray[n2];
            ++n2;
        }
    }

    void setDuplicateMapping(Hashtable hashtable) {
        Enumeration enumeration = hashtable.keys();
        this.m_charConv.extraUnicodeToOracleMapping = new int[hashtable.size()][2];
        int n = 0;
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            this.m_charConv.extraUnicodeToOracleMapping[n][0] = (Integer)k;
            this.m_charConv.extraUnicodeToOracleMapping[n++][1] = (Integer)hashtable.get(k);
        }
    }
}

