/*
 * Decompiled with CFR 0.152.
 */
package oracle.i18n.text.converter;

import java.io.CharConversionException;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import oracle.i18n.text.converter.CharacterConverterOGS;
import oracle.i18n.util.GDKMessage;
import oracle.i18n.util.GDKOracleMetaData;

public class CharacterConverter1Byte
extends CharacterConverterOGS {
    static final long serialVersionUID = GDKOracleMetaData.getOracleVersionID();
    static final int ORACHARMASK = 255;
    static final int UCSCHARWIDTH = 16;
    public int m_ucsReplacement = 0;
    public int[] m_ucsChar = null;
    public char[] m_oraCharLevel1 = null;
    public char[] m_oraCharSurrogateLevel = null;
    public char[] m_oraCharLevel2 = null;
    public byte m_oraCharReplacement = 0;
    protected transient boolean noSurrogate = true;
    protected transient boolean strictASCII = true;

    public CharacterConverter1Byte() {
        this.m_groupId = 0;
        this.averageCharsPerByte = 1.0f;
        this.maxCharsPerByte = 1.0f;
        this.maxBytesPerChar = 1.0f;
    }

    int toUnicode(byte by) throws SQLException {
        int n = this.m_ucsChar[by & 0xFF];
        if (n == -1) {
            throw new SQLException(GDKMessage.getORAMessage(17154), null, 17154);
        }
        return n;
    }

    int toUnicodeWithReplacement(byte by) {
        int n = this.m_ucsChar[by & 0xFF];
        if (n == -1) {
            return this.m_ucsReplacement;
        }
        return n;
    }

    byte toOracleCharacter(char c, char c2) throws SQLException {
        int n = c >>> 8 & 0xFF;
        int n2 = c & 0xFF;
        int n3 = c2 >>> 8 & 0xFF;
        int n4 = c2 & 0xFF;
        if (this.m_oraCharLevel1[n] != '\uffff' && this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n] + n2] != '\uffff' && this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n] + n2] + n3] != '\uffff' && this.m_oraCharLevel2[this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n] + n2] + n3] + n4] != '\uffff') {
            return (byte)this.m_oraCharLevel2[this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n] + n2] + n3] + n4];
        }
        throw new SQLException(GDKMessage.getORAMessage(17155), null, 17155);
    }

    byte toOracleCharacter(char c) throws SQLException {
        int n = c >>> 8 & 0xFF;
        int n2 = c & 0xFF;
        if (this.m_oraCharLevel1[n] != '\uffff' && this.m_oraCharLevel2[this.m_oraCharLevel1[n] + n2] != '\uffff') {
            return (byte)this.m_oraCharLevel2[this.m_oraCharLevel1[n] + n2];
        }
        throw new SQLException(GDKMessage.getORAMessage(17155), null, 17155);
    }

    byte toOracleCharacterWithReplacement(char c, char c2) {
        int n = c >>> 8 & 0xFF;
        int n2 = c & 0xFF;
        int n3 = c2 >>> 8 & 0xFF;
        int n4 = c2 & 0xFF;
        if (this.m_oraCharLevel1[n] != '\uffff' && this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n] + n2] != '\uffff' && this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n] + n2] + n3] != '\uffff' && this.m_oraCharLevel2[this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n] + n2] + n3] + n4] != '\uffff') {
            return (byte)this.m_oraCharLevel2[this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n] + n2] + n3] + n4];
        }
        return this.m_oraCharReplacement;
    }

    byte toOracleCharacterWithReplacement(char c) {
        int n = c >>> 8 & 0xFF;
        int n2 = c & 0xFF;
        if (this.m_oraCharLevel1[n] != '\uffff' && this.m_oraCharLevel2[this.m_oraCharLevel1[n] + n2] != '\uffff') {
            return (byte)this.m_oraCharLevel2[this.m_oraCharLevel1[n] + n2];
        }
        return this.m_oraCharReplacement;
    }

    public String toUnicodeString(byte[] byArray, int n, int n2) throws SQLException {
        int n3 = n + n2;
        StringBuffer stringBuffer = new StringBuffer(n2);
        int n4 = n;
        while (n4 < n3) {
            int n5 = this.m_ucsChar[byArray[n4] & 0xFF];
            if (n5 == -1) {
                throw new SQLException(GDKMessage.getORAMessage(17154), null, 17154);
            }
            stringBuffer.append((char)n5);
            ++n4;
        }
        return stringBuffer.toString();
    }

    public String toUnicodeStringWithReplacement(byte[] byArray, int n, int n2) {
        int n3 = n + n2;
        StringBuffer stringBuffer = new StringBuffer(n2);
        int n4 = n;
        while (n4 < n3) {
            int n5 = this.m_ucsChar[byArray[n4] & 0xFF];
            if (n5 == -1) {
                stringBuffer.append((char)this.m_ucsReplacement);
            } else {
                stringBuffer.append((char)n5);
            }
            ++n4;
        }
        return stringBuffer.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public byte[] toOracleString(String string) throws SQLException {
        int n = string.length();
        if (n == 0) {
            return new byte[0];
        }
        char[] cArray = new char[n];
        string.getChars(0, n, cArray, 0);
        byte[] byArray = new byte[n * 4];
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            if (cArray[n3] >= '\ud800' && cArray[n3] < '\udc00') {
                if (n3 + 1 >= n || cArray[n3 + 1] < '\udc00' || cArray[n3 + 1] > '\udfff') throw new SQLException(GDKMessage.getORAMessage(17155), null, 17155);
                if (this.noSurrogate) {
                    throw new SQLException(GDKMessage.getORAMessage(17155), null, 17155);
                }
                byArray[n2++] = this.toOracleCharacter(cArray[n3], cArray[n3 + 1]);
                ++n3;
            } else {
                byArray[n2++] = this.strictASCII && cArray[n3] < '\u0080' ? (byte)cArray[n3] : this.toOracleCharacter(cArray[n3]);
            }
            ++n3;
        }
        if (n2 >= byArray.length) return byArray;
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, 0, byArray2, 0, n2);
        return byArray2;
    }

    public byte[] toOracleStringWithReplacement(String string) {
        int n = string.length();
        if (n == 0) {
            return new byte[0];
        }
        char[] cArray = new char[n];
        string.getChars(0, n, cArray, 0);
        byte[] byArray = new byte[n * 4];
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            if (cArray[n3] >= '\ud800' && cArray[n3] < '\udc00') {
                if (n3 + 1 < n && cArray[n3 + 1] >= '\udc00' && cArray[n3 + 1] <= '\udfff') {
                    byArray[n2++] = this.noSurrogate ? this.m_oraCharReplacement : this.toOracleCharacterWithReplacement(cArray[n3], cArray[n3 + 1]);
                    ++n3;
                } else {
                    byArray[n2++] = this.m_oraCharReplacement;
                }
            } else {
                byArray[n2++] = this.strictASCII && cArray[n3] < '\u0080' ? (byte)cArray[n3] : this.toOracleCharacterWithReplacement(cArray[n3]);
            }
            ++n3;
        }
        if (n2 < byArray.length) {
            byte[] byArray2 = new byte[n2];
            System.arraycopy(byArray, 0, byArray2, 0, n2);
            return byArray2;
        }
        return byArray;
    }

    protected boolean isOraCharacterReplacement(char c, char c2) {
        if (c2 != '\u0000') {
            return this.toOracleCharacterWithReplacement(c, c2) == this.m_oraCharReplacement;
        }
        return this.toOracleCharacterWithReplacement(c) == this.m_oraCharReplacement;
    }

    public void buildUnicodeToOracleMapping() {
        int n;
        int n2;
        int n3;
        int n4;
        char[] cArray;
        Object object;
        Enumeration enumeration;
        int n5;
        this.m_oraCharLevel1 = new char[256];
        this.m_oraCharSurrogateLevel = null;
        this.m_oraCharLevel2 = null;
        Vector vector = new Vector(45055, 12287);
        Hashtable hashtable = new Hashtable();
        Hashtable hashtable2 = new Hashtable();
        int n6 = this.m_ucsChar.length;
        char c = '\u0000';
        char c2 = '\u0000';
        int n7 = 0;
        while (n7 < 256) {
            this.m_oraCharLevel1[n7] = 65535;
            ++n7;
        }
        n7 = 0;
        while (n7 < n6) {
            n5 = this.m_ucsChar[n7];
            if (n5 != -1) {
                enumeration = (Enumeration)new int[2];
                enumeration[0] = n5;
                enumeration[1] = (Enumeration)n7;
                vector.addElement(enumeration);
                this.storeMappingRange(n5, hashtable, hashtable2);
            }
            ++n7;
        }
        if (this.extraUnicodeToOracleMapping != null) {
            n6 = this.extraUnicodeToOracleMapping.length;
            n7 = 0;
            while (n7 < n6) {
                n5 = this.extraUnicodeToOracleMapping[n7][0];
                this.storeMappingRange(n5, hashtable, hashtable2);
                ++n7;
            }
        }
        enumeration = hashtable.keys();
        int n8 = 0;
        int n9 = 0;
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            cArray = (char[])hashtable.get(object);
            if (cArray == null) continue;
            n8 += 256;
        }
        enumeration = hashtable2.keys();
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            cArray = (char[])hashtable2.get(object);
            if (cArray == null) continue;
            n9 += 256;
        }
        if (n8 != 0) {
            this.m_oraCharSurrogateLevel = new char[n8];
        }
        if (n9 != 0) {
            this.m_oraCharLevel2 = new char[n9];
        }
        n7 = 0;
        while (n7 < n8) {
            this.m_oraCharSurrogateLevel[n7] = 65535;
            ++n7;
        }
        n7 = 0;
        while (n7 < n9) {
            this.m_oraCharLevel2[n7] = 65535;
            ++n7;
        }
        n7 = 0;
        while (n7 < vector.size()) {
            int[] nArray = (int[])vector.elementAt(n7);
            n4 = nArray[0] >> 24 & 0xFF;
            n3 = nArray[0] >> 16 & 0xFF;
            n2 = nArray[0] >> 8 & 0xFF;
            n = nArray[0] & 0xFF;
            if (n4 >= 216 && n4 < 220) {
                if (this.m_oraCharLevel1[n4] == '\uffff') {
                    this.m_oraCharLevel1[n4] = c2;
                    c2 = (char)(c2 + 256);
                }
                if (this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n4] + n3] == '\uffff') {
                    this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n4] + n3] = c2;
                    c2 = (char)(c2 + 256);
                }
                if (this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n4] + n3] + n2] == '\uffff') {
                    this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n4] + n3] + n2] = c;
                    c = (char)(c + 256);
                }
                if (this.m_oraCharLevel2[this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n4] + n3] + n2] + n] == '\uffff') {
                    this.m_oraCharLevel2[this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n4] + n3] + n2] + n] = (char)(nArray[1] & 0xFFFF);
                }
            } else {
                if (this.m_oraCharLevel1[n2] == '\uffff') {
                    this.m_oraCharLevel1[n2] = c;
                    c = (char)(c + 256);
                }
                if (this.m_oraCharLevel2[this.m_oraCharLevel1[n2] + n] == '\uffff') {
                    this.m_oraCharLevel2[this.m_oraCharLevel1[n2] + n] = (char)(nArray[1] & 0xFFFF);
                }
            }
            ++n7;
        }
        if (this.extraUnicodeToOracleMapping != null) {
            n6 = this.extraUnicodeToOracleMapping.length;
            n7 = 0;
            while (n7 < n6) {
                n5 = this.extraUnicodeToOracleMapping[n7][0];
                n4 = n5 >>> 24 & 0xFF;
                n3 = n5 >>> 16 & 0xFF;
                n2 = n5 >>> 8 & 0xFF;
                n = n5 & 0xFF;
                if (n4 >= 216 && n4 < 220) {
                    if (this.m_oraCharLevel1[n4] == '\uffff') {
                        this.m_oraCharLevel1[n4] = c2;
                        c2 = (char)(c2 + 256);
                    }
                    if (this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n4] + n3] == '\uffff') {
                        this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n4] + n3] = c2;
                        c2 = (char)(c2 + 256);
                    }
                    if (this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n4] + n3] + n2] == '\uffff') {
                        this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n4] + n3] + n2] = c;
                        c = (char)(c + 256);
                    }
                    this.m_oraCharLevel2[this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n4] + n3] + n2] + n] = (char)(this.extraUnicodeToOracleMapping[n7][1] & 0xFF);
                } else {
                    if (this.m_oraCharLevel1[n2] == '\uffff') {
                        this.m_oraCharLevel1[n2] = c;
                        c = (char)(c + 256);
                    }
                    this.m_oraCharLevel2[this.m_oraCharLevel1[n2] + n] = (char)(this.extraUnicodeToOracleMapping[n7][1] & 0xFFFF);
                }
                ++n7;
            }
        }
        this.noSurrogate = this.m_oraCharSurrogateLevel == null;
        this.strictASCII = true;
        n7 = 0;
        while (n7 < 128) {
            if (this.m_oraCharLevel2[n7] != n7) {
                this.strictASCII = false;
                break;
            }
            ++n7;
        }
    }

    public void extractCodepoints(Vector vector) {
        int n = 0;
        int n2 = 255;
        int n3 = n;
        while (n3 <= n2) {
            try {
                int[] nArray = new int[]{n3, this.toUnicode((byte)n3)};
                vector.addElement(nArray);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            ++n3;
        }
    }

    public void extractExtraMappings(Vector vector) {
        if (this.extraUnicodeToOracleMapping == null) {
            return;
        }
        int n = 0;
        while (n < this.extraUnicodeToOracleMapping.length) {
            int[] nArray = new int[]{this.extraUnicodeToOracleMapping[n][0], this.extraUnicodeToOracleMapping[n][1]};
            vector.addElement(nArray);
            ++n;
        }
    }

    public boolean hasExtraMappings() {
        return this.extraUnicodeToOracleMapping != null;
    }

    public char getOraChar1ByteRep() {
        return (char)this.m_oraCharReplacement;
    }

    public char getOraChar2ByteRep() {
        return '\u0000';
    }

    public int getUCS2CharRep() {
        return this.m_ucsReplacement;
    }

    public int ByteToCharConvert(byte[] byArray, int n, int n2, char[] cArray, int n3, int n4) throws IOException, CharConversionException, IndexOutOfBoundsException {
        return 0;
    }

    public int CharToByteConvert(char[] cArray, int n, int n2, byte[] byArray, int n3, int n4) throws IOException, CharConversionException, IndexOutOfBoundsException {
        return 0;
    }
}

