/*
 * Decompiled with CFR 0.152.
 */
package oracle.i18n.text;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.FieldPosition;
import java.text.ParseException;
import java.text.ParsePosition;
import oracle.i18n.text.OraDecimal;
import oracle.i18n.text.OraDecimalFormatPattern;
import oracle.i18n.text.OraDecimalFormatSymbols;
import oracle.i18n.text.OraNumberFormat;
import oracle.i18n.text.OraTerritory;
import oracle.i18n.util.GDKMessage;
import oracle.i18n.util.OraLocaleInfo;

public class OraDecimalFormat
extends OraNumberFormat {
    private static final int JAVA_DOUBLE_INTEGER_DIGITS = 309;
    private static final int JAVA_DOUBLE_FRACTION_DIGITS = 340;
    private boolean useDefaultPattern;
    private OraDecimalFormatPattern oraDecPatPos;
    private OraDecimalFormatPattern oraDecPatNeg;
    private String ora_lang;
    private String ora_terr;
    private OraDecimalFormatSymbols symbols;
    private boolean decimalSeparatorShown = true;

    public OraDecimalFormat() {
        this.initialize(OraLocaleInfo.getDefault(), 0);
    }

    OraDecimalFormat(OraLocaleInfo oraLocaleInfo, int n) {
        this.initialize(oraLocaleInfo, n);
    }

    public OraDecimalFormat(String string) throws ParseException {
        OraTerritory oraTerritory = OraLocaleInfo.getDefault().getOraTerritory();
        this.ora_terr = oraTerritory.getName();
        this.ora_lang = OraLocaleInfo.getDefault().getOraLanguage().getName();
        this.symbols = new OraDecimalFormatSymbols(oraTerritory);
        this.applyPattern(string);
    }

    public OraDecimalFormat(String string, OraDecimalFormatSymbols oraDecimalFormatSymbols) throws ParseException {
        OraTerritory oraTerritory = OraLocaleInfo.getDefault().getOraTerritory();
        this.ora_terr = oraTerritory.getName();
        this.ora_lang = OraLocaleInfo.getDefault().getOraLanguage().getName();
        this.symbols = (OraDecimalFormatSymbols)oraDecimalFormatSymbols.clone();
        this.applyPattern(string);
    }

    public void applyPattern(String string) throws ParseException {
        if (string == null || string.equals("")) {
            throw new ParseException(GDKMessage.getMessage(5087), -1);
        }
        if (string.equals("DNF")) {
            this.useDefaultPattern = true;
            OraTerritory oraTerritory = OraTerritory.getInstance(this.ora_lang, this.ora_terr);
            this.oraDecPatPos = new OraDecimalFormatPattern(oraTerritory.getNLSNumberFormatPositive());
            this.oraDecPatNeg = new OraDecimalFormatPattern(oraTerritory.getNLSNumberFormatNegative());
        } else if (string.equals("DCF")) {
            this.useDefaultPattern = true;
            OraTerritory oraTerritory = OraTerritory.getInstance(this.ora_lang, this.ora_terr);
            this.oraDecPatPos = new OraDecimalFormatPattern(oraTerritory.getNLSCurrencyFormatPositive());
            this.oraDecPatNeg = new OraDecimalFormatPattern(oraTerritory.getNLSCurrencyFormatNegative());
        } else {
            ParsePosition parsePosition;
            String string2;
            String string3;
            int n = string.indexOf(59);
            if (n < 0) {
                string3 = string;
                string2 = null;
            } else {
                if (n == 0 || n + 1 == string.length()) {
                    ParsePosition parsePosition2 = new ParsePosition(0);
                    throw new ParseException(GDKMessage.getMessage(5088), n);
                }
                string3 = string.substring(0, n);
                string2 = string.substring(n + 1);
            }
            if (this.oraDecPatPos == null || !this.oraDecPatPos.pattern.equals(string3)) {
                parsePosition = new ParsePosition(0);
                this.oraDecPatPos = new OraDecimalFormatPattern(string3, false, parsePosition);
                if (parsePosition.getErrorIndex() >= 0) {
                    throw new ParseException(GDKMessage.getMessage(5088), parsePosition.getErrorIndex());
                }
            }
            this.useDefaultPattern = false;
            if (n < 0) {
                this.oraDecPatNeg = (OraDecimalFormatPattern)this.oraDecPatPos.clone();
            } else if (this.oraDecPatNeg == null || !this.oraDecPatNeg.pattern.equals(string2)) {
                parsePosition = new ParsePosition(0);
                this.oraDecPatNeg = new OraDecimalFormatPattern(string2, false, parsePosition);
                if (parsePosition.getErrorIndex() >= 0) {
                    throw new ParseException(GDKMessage.getMessage(5088), parsePosition.getErrorIndex());
                }
            }
        }
    }

    public StringBuffer format(BigDecimal bigDecimal, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        OraDecimalFormatPattern oraDecimalFormatPattern;
        boolean bl = bigDecimal.signum() < 0;
        OraDecimalFormatPattern oraDecimalFormatPattern2 = oraDecimalFormatPattern = bl ? this.oraDecPatNeg : this.oraDecPatPos;
        if (this.useDefaultPattern) {
            return this.formatDefault(stringBuffer, fieldPosition, bl, false, new OraDecimal(bigDecimal, oraDecimalFormatPattern.numberOfDigitsRHS, false), oraDecimalFormatPattern);
        }
        return this.format(stringBuffer, fieldPosition, bigDecimal.signum() < 0, false, new OraDecimal(bigDecimal, oraDecimalFormatPattern.isTmOn ? -1 : oraDecimalFormatPattern.numberOfDigitsRHS, oraDecimalFormatPattern.useScientificNotation), oraDecimalFormatPattern);
    }

    public StringBuffer format(BigInteger bigInteger, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        OraDecimalFormatPattern oraDecimalFormatPattern;
        boolean bl = bigInteger.signum() < 0;
        OraDecimalFormatPattern oraDecimalFormatPattern2 = oraDecimalFormatPattern = bl ? this.oraDecPatNeg : this.oraDecPatPos;
        if (this.useDefaultPattern) {
            return this.formatDefault(stringBuffer, fieldPosition, bl, true, new OraDecimal(bigInteger, oraDecimalFormatPattern.numberOfDigitsRHS, false), oraDecimalFormatPattern);
        }
        return this.format(stringBuffer, fieldPosition, bl, true, new OraDecimal(bigInteger, oraDecimalFormatPattern.isTmOn ? -1 : oraDecimalFormatPattern.numberOfDigitsRHS, oraDecimalFormatPattern.useScientificNotation), oraDecimalFormatPattern);
    }

    public StringBuffer format(double d, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        OraDecimalFormatPattern oraDecimalFormatPattern;
        boolean bl = d < 0.0;
        OraDecimalFormatPattern oraDecimalFormatPattern2 = oraDecimalFormatPattern = bl ? this.oraDecPatNeg : this.oraDecPatPos;
        if (bl) {
            d = -d;
        }
        if (Double.isNaN(d)) {
            if (fieldPosition.getField() == 0) {
                fieldPosition.setBeginIndex(stringBuffer.length());
            } else {
                fieldPosition.setBeginIndex(0);
            }
            stringBuffer.append(this.symbols.getNaN());
            if (fieldPosition.getField() == 0) {
                fieldPosition.setEndIndex(stringBuffer.length());
            } else {
                fieldPosition.setEndIndex(0);
            }
            return stringBuffer;
        }
        if (this.useDefaultPattern) {
            if (Double.isInfinite(d)) {
                return this.formatInfinity(stringBuffer, fieldPosition, bl, oraDecimalFormatPattern);
            }
            return this.formatDefault(stringBuffer, fieldPosition, bl, false, new OraDecimal(d, oraDecimalFormatPattern.numberOfDigitsRHS, false), oraDecimalFormatPattern);
        }
        if (Double.isInfinite(d)) {
            return this.formatInfinity(stringBuffer, fieldPosition, bl, oraDecimalFormatPattern);
        }
        return this.format(stringBuffer, fieldPosition, bl, false, new OraDecimal(d, oraDecimalFormatPattern.isTmOn ? -1 : oraDecimalFormatPattern.numberOfDigitsRHS, oraDecimalFormatPattern.useScientificNotation), oraDecimalFormatPattern);
    }

    public StringBuffer format(long l, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        OraDecimalFormatPattern oraDecimalFormatPattern;
        boolean bl = l < 0L;
        OraDecimalFormatPattern oraDecimalFormatPattern2 = oraDecimalFormatPattern = bl ? this.oraDecPatNeg : this.oraDecPatPos;
        if (bl) {
            l = -l;
        }
        if (this.useDefaultPattern) {
            return this.formatDefault(stringBuffer, fieldPosition, bl, true, new OraDecimal(l, oraDecimalFormatPattern.numberOfDigitsRHS, false), oraDecimalFormatPattern);
        }
        return this.format(stringBuffer, fieldPosition, bl, true, new OraDecimal(l, oraDecimalFormatPattern.isTmOn ? -1 : oraDecimalFormatPattern.numberOfDigitsRHS, oraDecimalFormatPattern.useScientificNotation), oraDecimalFormatPattern);
    }

    public Number parse(String string, ParsePosition parsePosition) {
        int n;
        int n2 = string.length();
        int n3 = parsePosition.getIndex();
        StringBuffer stringBuffer = new StringBuffer(n2);
        if (n3 + 1 == n2 && string.charAt(n3) == this.symbols.getNaN()) {
            parsePosition.setIndex(n2);
            return new Double(Double.NaN);
        }
        if (this.useDefaultPattern) {
            n = this.parseDefault(stringBuffer, string, n3);
        } else {
            n = this.parse(stringBuffer, string, n3, this.oraDecPatPos, false);
            if (n >= 0) {
                stringBuffer.delete(0, stringBuffer.length());
                n = this.parse(stringBuffer, string, n3, this.oraDecPatNeg, true);
                if (n >= 0) {
                    parsePosition.setIndex(n3);
                    parsePosition.setErrorIndex(n);
                    throw new IllegalArgumentException(GDKMessage.getMessage(5089));
                }
            }
        }
        parsePosition.setIndex(n2);
        switch (n) {
            case -1: {
                BigInteger bigInteger = new BigInteger(stringBuffer.toString());
                long l = bigInteger.longValue();
                if ((long)bigInteger.signum() * l >= 0L && l <= Long.MAX_VALUE && l >= Long.MIN_VALUE) {
                    return new Long(l);
                }
                return bigInteger;
            }
            case -2: {
                return new BigDecimal(stringBuffer.toString());
            }
            case -21: {
                return this.toBigDecimal(stringBuffer);
            }
            case -3: {
                return new Long(0L);
            }
            case -5: {
                return new Double(Double.POSITIVE_INFINITY);
            }
            case -6: {
                return new Double(Double.NEGATIVE_INFINITY);
            }
        }
        parsePosition.setIndex(n3);
        parsePosition.setErrorIndex(n);
        throw new IllegalArgumentException(GDKMessage.getMessage(5089));
    }

    public boolean isDecimalSeparatorAlwaysShown() {
        return this.decimalSeparatorShown;
    }

    public void setDecimalSeparatorAlwaysShown(boolean bl) {
        this.decimalSeparatorShown = bl;
    }

    public OraDecimalFormatSymbols getOraDecimalFormatSymbols() {
        return this.symbols;
    }

    public void setOraDecimalFormatSymbols(OraDecimalFormatSymbols oraDecimalFormatSymbols) {
        this.symbols = oraDecimalFormatSymbols;
    }

    public String toPattern() {
        StringBuffer stringBuffer = this.oraDecPatPos.equals(this.oraDecPatNeg) ? new StringBuffer(this.oraDecPatPos.pattern) : new StringBuffer(this.oraDecPatPos.pattern + ";" + this.oraDecPatNeg.pattern);
        int n = stringBuffer.length() - 1;
        while (n >= 0) {
            if (!this.decimalSeparatorShown && (stringBuffer.charAt(n) == 'D' || stringBuffer.charAt(n) == '.') || !this.isGroupingUsed() && (stringBuffer.charAt(n) == 'G' || stringBuffer.charAt(n) == ',')) {
                stringBuffer.deleteCharAt(n);
            }
            --n;
        }
        return stringBuffer.toString();
    }

    void setMaximumIntegerDigits(int n) {
        super.setMaximumIntegerDigits(Math.min(n, 309));
    }

    void setMinimumIntegerDigits(int n) {
        super.setMinimumIntegerDigits(Math.min(n, 309));
    }

    void setMaximumFractionDigits(int n) {
        super.setMaximumFractionDigits(Math.min(n, 340));
    }

    void setMinimumFractionDigits(int n) {
        super.setMinimumFractionDigits(Math.min(n, 340));
    }

    public Object clone() {
        OraDecimalFormat oraDecimalFormat = (OraDecimalFormat)super.clone();
        oraDecimalFormat.oraDecPatPos = (OraDecimalFormatPattern)this.oraDecPatPos.clone();
        oraDecimalFormat.oraDecPatNeg = (OraDecimalFormatPattern)this.oraDecPatNeg.clone();
        oraDecimalFormat.symbols = (OraDecimalFormatSymbols)this.symbols.clone();
        return oraDecimalFormat;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof OraDecimalFormat) || !super.equals(object)) {
            return false;
        }
        OraDecimalFormat oraDecimalFormat = (OraDecimalFormat)object;
        return this.decimalSeparatorShown == oraDecimalFormat.decimalSeparatorShown && this.oraDecPatPos.equals(oraDecimalFormat.oraDecPatPos) && this.oraDecPatNeg.equals(oraDecimalFormat.oraDecPatNeg) && this.ora_lang.equals(oraDecimalFormat.ora_lang) && this.ora_terr.equals(oraDecimalFormat.ora_terr) && this.symbols.equals(oraDecimalFormat.symbols) && this.useDefaultPattern == oraDecimalFormat.useDefaultPattern;
    }

    public int hashCode() {
        return this.oraDecPatNeg.pattern.hashCode();
    }

    private void initialize(OraLocaleInfo oraLocaleInfo, int n) {
        this.useDefaultPattern = true;
        OraTerritory oraTerritory = oraLocaleInfo.getOraTerritory();
        this.ora_terr = oraTerritory.getName();
        this.ora_lang = oraLocaleInfo.getLanguage();
        if (n == 1) {
            this.oraDecPatPos = new OraDecimalFormatPattern(oraTerritory.getNLSCurrencyFormatPositive());
            this.oraDecPatNeg = new OraDecimalFormatPattern(oraTerritory.getNLSCurrencyFormatNegative());
        } else {
            this.oraDecPatPos = new OraDecimalFormatPattern(oraTerritory.getNLSNumberFormatPositive());
            this.oraDecPatNeg = new OraDecimalFormatPattern(oraTerritory.getNLSNumberFormatNegative());
        }
        this.symbols = new OraDecimalFormatSymbols(oraTerritory);
    }

    private StringBuffer formatInfinity(StringBuffer stringBuffer, FieldPosition fieldPosition, boolean bl, OraDecimalFormatPattern oraDecimalFormatPattern) {
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        int n = 0;
        int n2 = stringBuffer.length();
        String string = oraDecimalFormatPattern.useDollar ? "$" : (oraDecimalFormatPattern.useIntlCurrency ? this.symbols.getInternationalCurrencySymbol() : this.symbols.getCurrencySymbol());
        int n3 = 1;
        while (n3 <= 4) {
            switch (oraDecimalFormatPattern.getNthComponent(n3)) {
                case 1: {
                    n = stringBuffer.length();
                    if (fieldPosition.getField() == 0) {
                        fieldPosition.setBeginIndex(n);
                    } else {
                        fieldPosition.setBeginIndex(0);
                    }
                    stringBuffer.append(this.symbols.getInfinity());
                    if (fieldPosition.getField() == 0) {
                        fieldPosition.setEndIndex(stringBuffer.length());
                        break;
                    }
                    fieldPosition.setEndIndex(0);
                    break;
                }
                case 2: {
                    bl4 = true;
                    if (!bl) break;
                    stringBuffer.append('-');
                    break;
                }
                case 3: {
                    stringBuffer.append(' ');
                    break;
                }
                case 4: {
                    if (oraDecimalFormatPattern.useDollar) {
                        stringBuffer.insert(n, string);
                        if (fieldPosition.getField() == -1 || fieldPosition.getEndIndex() == 0) break;
                        fieldPosition.setBeginIndex(fieldPosition.getBeginIndex() + string.length());
                        fieldPosition.setEndIndex(fieldPosition.getEndIndex() + string.length());
                        break;
                    }
                    stringBuffer.append(string);
                    break;
                }
                case 5: {
                    if (bl) {
                        stringBuffer.append('(');
                    }
                    bl2 = true;
                    bl4 = true;
                    break;
                }
                case 6: {
                    if (bl) {
                        stringBuffer.append('<');
                    }
                    bl3 = true;
                    bl4 = true;
                    break;
                }
            }
            ++n3;
        }
        if (bl) {
            if (!bl4) {
                stringBuffer.insert(n2, '-');
            } else if (bl2) {
                stringBuffer.append(')');
            } else if (bl3) {
                stringBuffer.append('>');
            }
        }
        return stringBuffer;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private StringBuffer formatDefault(StringBuffer stringBuffer, FieldPosition fieldPosition, boolean bl, boolean bl2, OraDecimal oraDecimal, OraDecimalFormatPattern oraDecimalFormatPattern) {
        int n = oraDecimalFormatPattern.internalFormat;
        int n2 = oraDecimalFormatPattern.numberOfDigitsRHS;
        String string = oraDecimalFormatPattern.groupingSizes;
        int n3 = oraDecimal.exponent;
        int n4 = oraDecimal.numberOfDigitsLHS;
        int n5 = oraDecimal.numberOfDigitsRHS;
        int n6 = oraDecimal.numberOfDigits;
        boolean bl3 = false;
        boolean bl4 = false;
        int n7 = stringBuffer.length();
        fieldPosition.setBeginIndex(0);
        fieldPosition.setEndIndex(0);
        int n8 = 1;
        while (n8 <= 4) {
            switch (oraDecimalFormatPattern.getNthComponent(n8)) {
                case 1: {
                    int n9;
                    int n10 = 0;
                    if (fieldPosition.getField() == 0) {
                        fieldPosition.setBeginIndex(stringBuffer.length());
                    }
                    if (n4 > 0) {
                        int n11;
                        int n12;
                        int n13;
                        if (string.length() == 1) {
                            n9 = string.charAt(0) - 48;
                            n13 = n9 - n4 % n9;
                            n12 = n4 > n6 ? n6 : n4;
                            n10 = 0;
                            while (n10 < n12) {
                                stringBuffer.append(oraDecimal.digits[n10]);
                                if (++n13 % n9 == 0 && n10 + 1 < n4 && this.isGroupingUsed()) {
                                    stringBuffer.append(this.symbols.getGroupingSeparator());
                                }
                                ++n10;
                            }
                            n11 = n10;
                            while (n11 < n4) {
                                stringBuffer.append('0');
                                if (++n13 % n9 == 0 && n11 + 1 < n4 && this.isGroupingUsed()) {
                                    stringBuffer.append(this.symbols.getGroupingSeparator());
                                }
                                ++n11;
                            }
                        } else {
                            if (string.length() != 2) throw new IllegalArgumentException(GDKMessage.getMessage(5084));
                            n9 = string.charAt(0) - 48;
                            n13 = string.charAt(1) - 48;
                            n12 = n13 - (n4 - n9) % n13;
                            n11 = n4 > n6 ? n6 : n4;
                            n10 = 0;
                            while (n10 < n4 - n9) {
                                if (n10 < n11) {
                                    stringBuffer.append(oraDecimal.digits[n10]);
                                } else {
                                    stringBuffer.append('0');
                                }
                                if (++n12 % n13 == 0 && n10 + 1 < n4 - n9 && this.isGroupingUsed()) {
                                    stringBuffer.append(this.symbols.getGroupingSeparator());
                                }
                                ++n10;
                            }
                            if (n4 > n9 && this.isGroupingUsed()) {
                                stringBuffer.append(this.symbols.getGroupingSeparator());
                            }
                            while (n10 < n4) {
                                if (n10 < n11) {
                                    stringBuffer.append(oraDecimal.digits[n10]);
                                } else {
                                    stringBuffer.append('0');
                                }
                                ++n10;
                            }
                            n10 = n11;
                        }
                    } else if (oraDecimalFormatPattern.numberOfLeadingZeros > 0) {
                        stringBuffer.append('0');
                    }
                    if (fieldPosition.getField() == 0) {
                        fieldPosition.setEndIndex(stringBuffer.length());
                    }
                    if (bl2) break;
                    if (this.decimalSeparatorShown) {
                        stringBuffer.append(this.symbols.getDecimalSeparator());
                    }
                    if (oraDecimalFormatPattern.numberOfTrailingZeros <= 0 && n5 <= 0) break;
                    if (fieldPosition.getField() == 1) {
                        fieldPosition.setBeginIndex(stringBuffer.length());
                    }
                    if (n4 < 0) {
                        n9 = 0;
                        while (n9 < -n4) {
                            stringBuffer.append('0');
                            ++n9;
                        }
                    }
                    while (n10 < n6) {
                        stringBuffer.append(oraDecimal.digits[n10]);
                        ++n10;
                    }
                    if (oraDecimalFormatPattern.numberOfTrailingZeros > 0) {
                        n10 = 0;
                        while (n10 < oraDecimalFormatPattern.numberOfDigitsRHS - n5) {
                            stringBuffer.append('0');
                            ++n10;
                        }
                    }
                    if (fieldPosition.getField() != 1) break;
                    fieldPosition.setEndIndex(stringBuffer.length());
                    break;
                }
                case 2: {
                    bl4 = true;
                    if (!bl) break;
                    stringBuffer.append('-');
                    break;
                }
                case 3: {
                    stringBuffer.append(' ');
                    break;
                }
                case 4: {
                    stringBuffer.append(this.symbols.getCurrencySymbol());
                    break;
                }
                case 5: {
                    stringBuffer.append('(');
                    bl3 = true;
                    bl4 = true;
                    break;
                }
            }
            ++n8;
        }
        if (!bl) return stringBuffer;
        if (!bl4) {
            stringBuffer.insert(n7, '-');
            if (fieldPosition.getField() == -1 || fieldPosition.getEndIndex() == 0) return stringBuffer;
            fieldPosition.setBeginIndex(fieldPosition.getBeginIndex() + 1);
            fieldPosition.setEndIndex(fieldPosition.getEndIndex() + 1);
            return stringBuffer;
        } else {
            if (!bl3) return stringBuffer;
            stringBuffer.append(')');
        }
        return stringBuffer;
    }

    private StringBuffer format(StringBuffer stringBuffer, FieldPosition fieldPosition, boolean bl, boolean bl2, OraDecimal oraDecimal, OraDecimalFormatPattern oraDecimalFormatPattern) {
        char c;
        char c2;
        char c3;
        char c4;
        char c5;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        char c6 = oraDecimalFormatPattern.usePeriod ? (char)'.' : (char)this.symbols.getDecimalSeparator();
        char c7 = c5 = oraDecimalFormatPattern.useComma ? (char)',' : (char)this.symbols.getGroupingSeparator();
        String string = oraDecimalFormatPattern.useDollar ? "$" : (oraDecimalFormatPattern.useIntlCurrency ? this.symbols.getInternationalCurrencySymbol() : this.symbols.getCurrencySymbol());
        int n5 = stringBuffer.length();
        if (bl) {
            c4 = '(';
            c3 = ')';
            c2 = '<';
            c = '>';
        } else {
            c = ' ';
            c2 = ' ';
            c3 = ' ';
            c4 = ' ';
        }
        fieldPosition.setBeginIndex(0);
        fieldPosition.setEndIndex(0);
        if (!oraDecimalFormatPattern.isTmOn && !oraDecimalFormatPattern.useScientificNotation && oraDecimal.numberOfDigitsLHS > oraDecimalFormatPattern.numberOfDigitsLHS) {
            int n6 = 0;
            while (n6 < oraDecimalFormatPattern.outputStringSize) {
                stringBuffer.append('#');
                ++n6;
            }
            return stringBuffer;
        }
        int n7 = oraDecimalFormatPattern.outputStringSize;
        if (!(oraDecimalFormatPattern.useScientificNotation || oraDecimalFormatPattern.isBOn && oraDecimal.isZero)) {
            if (oraDecimalFormatPattern.numberOfLeadingZeros > oraDecimal.numberOfDigitsLHS) {
                n2 = oraDecimalFormatPattern.numberOfLeadingZeros - (oraDecimal.numberOfDigitsLHS > 0 ? oraDecimal.numberOfDigitsLHS : 0);
                n = oraDecimalFormatPattern.numberOfDigitsLHS - oraDecimalFormatPattern.numberOfLeadingZeros;
            } else {
                n = oraDecimalFormatPattern.numberOfDigitsLHS - (oraDecimal.numberOfDigitsLHS > 0 ? oraDecimal.numberOfDigitsLHS : 0);
            }
            if (n3 < oraDecimalFormatPattern.numberOfGroups) {
                while (n3 < oraDecimalFormatPattern.numberOfGroups && oraDecimalFormatPattern.groupingSeparatorPositions[n3] <= n) {
                    ++n3;
                }
            }
        }
        int n8 = 1;
        while (n8 <= 4) {
            switch (oraDecimalFormatPattern.getNthComponent(n8)) {
                case 1: {
                    int n9;
                    int n10 = 0;
                    n4 = stringBuffer.length();
                    if (fieldPosition.getField() == 0) {
                        fieldPosition.setBeginIndex(n4);
                    }
                    int n11 = 0;
                    while (n11 < n2) {
                        stringBuffer.append('0');
                        if (n3 < oraDecimalFormatPattern.numberOfGroups && ++n == oraDecimalFormatPattern.groupingSeparatorPositions[n3]) {
                            if (this.isGroupingUsed()) {
                                stringBuffer.append(c5);
                                --n7;
                            }
                            ++n3;
                        }
                        ++n11;
                    }
                    n7 -= n2;
                    if (oraDecimal.isZero) {
                        if (!oraDecimalFormatPattern.isBOn && (oraDecimalFormatPattern.isTmOn || oraDecimalFormatPattern.numberOfDigitsRHS == 0)) {
                            stringBuffer.append('0');
                            --n7;
                        }
                    } else {
                        int n12 = oraDecimal.numberOfDigitsLHS > oraDecimal.numberOfDigits ? oraDecimal.numberOfDigits : (oraDecimal.numberOfDigitsLHS > 0 ? oraDecimal.numberOfDigitsLHS : 0);
                        n10 = 0;
                        while (n10 < n12) {
                            stringBuffer.append(oraDecimal.digits[n10]);
                            if (!oraDecimalFormatPattern.useScientificNotation && n3 < oraDecimalFormatPattern.numberOfGroups && ++n == oraDecimalFormatPattern.groupingSeparatorPositions[n3]) {
                                if (this.isGroupingUsed()) {
                                    stringBuffer.append(c5);
                                    --n7;
                                }
                                ++n3;
                            }
                            ++n10;
                        }
                        n9 = n10;
                        while (n9 < oraDecimal.numberOfDigitsLHS) {
                            stringBuffer.append('0');
                            if (!oraDecimalFormatPattern.useScientificNotation && n3 < oraDecimalFormatPattern.numberOfGroups && ++n == oraDecimalFormatPattern.groupingSeparatorPositions[n3]) {
                                if (this.isGroupingUsed()) {
                                    stringBuffer.append(c5);
                                    --n7;
                                }
                                ++n3;
                            }
                            ++n9;
                        }
                        n7 -= n9;
                    }
                    if (fieldPosition.getField() == 0) {
                        fieldPosition.setEndIndex(stringBuffer.length());
                    }
                    if (!oraDecimalFormatPattern.isVOn && (oraDecimalFormatPattern.isDecimalSeparatorOn || oraDecimalFormatPattern.isTmOn && oraDecimal.numberOfDigitsRHS > 0) && this.decimalSeparatorShown) {
                        stringBuffer.append(c6);
                        --n7;
                    }
                    if (fieldPosition.getField() == 1) {
                        fieldPosition.setBeginIndex(stringBuffer.length());
                    }
                    n = 0;
                    if (oraDecimal.numberOfDigitsRHS > 0) {
                        if (oraDecimal.numberOfDigitsLHS < 0) {
                            n = 0;
                            while (n < -oraDecimal.numberOfDigitsLHS) {
                                stringBuffer.append('0');
                                ++n;
                            }
                        }
                        while (n10 < oraDecimal.numberOfDigits) {
                            ++n;
                            stringBuffer.append(oraDecimal.digits[n10]);
                            ++n10;
                        }
                    }
                    while (n < oraDecimalFormatPattern.numberOfTrailingZeros) {
                        stringBuffer.append('0');
                        ++n;
                    }
                    if (!oraDecimalFormatPattern.isFmOn) {
                        while (n < oraDecimalFormatPattern.numberOfDigitsRHS) {
                            stringBuffer.append('0');
                            ++n;
                        }
                    }
                    n7 -= n;
                    if (fieldPosition.getField() == 1) {
                        fieldPosition.setEndIndex(stringBuffer.length());
                    }
                    if (!oraDecimalFormatPattern.useScientificNotation) break;
                    n7 -= 4;
                    stringBuffer.append('E');
                    if (oraDecimal.exponent < 0) {
                        stringBuffer.append('-');
                        n9 = -oraDecimal.exponent;
                    } else {
                        stringBuffer.append('+');
                        n9 = oraDecimal.exponent;
                    }
                    if (n9 < 99) {
                        stringBuffer.append((char)(48 + n9 / 10));
                        stringBuffer.append((char)(48 + n9 % 10));
                        break;
                    }
                    stringBuffer.append(new Integer(n9).toString());
                    --n7;
                    break;
                }
                case 2: {
                    bl5 = true;
                    --n7;
                    if (bl) {
                        stringBuffer.append('-');
                        break;
                    }
                    if (oraDecimalFormatPattern.isSignOn) {
                        stringBuffer.append('+');
                        break;
                    }
                    if (!oraDecimalFormatPattern.isFmOn) {
                        stringBuffer.append(' ');
                        break;
                    }
                    ++n7;
                    break;
                }
                case 3: {
                    stringBuffer.append(' ');
                    --n7;
                    break;
                }
                case 4: {
                    if (oraDecimalFormatPattern.useDollar) {
                        stringBuffer.insert(n4, string);
                        if (fieldPosition.getField() != -1 && fieldPosition.getEndIndex() != 0) {
                            fieldPosition.setBeginIndex(fieldPosition.getBeginIndex() + string.length());
                            fieldPosition.setEndIndex(fieldPosition.getEndIndex() + string.length());
                        }
                    } else {
                        stringBuffer.append(string);
                    }
                    n7 -= string.length();
                    break;
                }
                case 5: {
                    if (bl || !oraDecimalFormatPattern.isFmOn) {
                        stringBuffer.append(c4);
                    }
                    n7 -= 2;
                    bl3 = true;
                    bl5 = true;
                    break;
                }
                case 6: {
                    if (bl || !oraDecimalFormatPattern.isFmOn) {
                        stringBuffer.append(c2);
                    }
                    n7 -= 2;
                    bl4 = true;
                    bl5 = true;
                    break;
                }
            }
            ++n8;
        }
        if (!(!bl || bl5 || oraDecimalFormatPattern.isBOn && oraDecimal.isZero)) {
            stringBuffer.insert(n5, '-');
            --n7;
        } else if (bl || !oraDecimalFormatPattern.isFmOn) {
            if (bl3) {
                stringBuffer.append(c3);
            } else if (bl4) {
                stringBuffer.append(c);
            }
        }
        if (!oraDecimalFormatPattern.isTmOn && n7 < 0) {
            throw new IllegalArgumentException(GDKMessage.getMessage(5084));
        }
        if (!oraDecimalFormatPattern.isFmOn && !oraDecimalFormatPattern.isTmOn && n7 > 0) {
            StringBuffer stringBuffer2 = new StringBuffer(n7);
            n = 0;
            while (n < n7) {
                stringBuffer2.append(' ');
                ++n;
            }
            stringBuffer.insert(n5, (Object)stringBuffer2);
            if (fieldPosition.getField() != -1 && fieldPosition.getEndIndex() != 0) {
                fieldPosition.setBeginIndex(fieldPosition.getBeginIndex() + n7);
                fieldPosition.setEndIndex(fieldPosition.getEndIndex() + n7);
            }
        }
        return stringBuffer;
    }

    /*
     * Unable to fully structure code
     */
    private int parseDefault(StringBuffer var1_1, String var2_2, int var3_3) {
        var4_4 = var2_2.length();
        var10_5 = false;
        var11_6 = false;
        var12_7 = false;
        var13_8 = 0;
        var14_9 = 2;
        var15_10 = new int[]{-1, -1};
        var5_11 = var3_3;
        while (var5_11 < var4_4 && Character.isWhitespace(var2_2.charAt(var5_11))) {
            ++var5_11;
        }
        if (var5_11 >= var4_4) {
            return 0;
        }
        var7_12 = var2_2.charAt(var5_11);
        if (var7_12 == '-' || var7_12 == '(') {
            ++var5_11;
            var10_5 = true;
            var12_7 = true;
            var13_8 = 1;
            if (var7_12 == '(') {
                var11_6 = true;
            }
        } else if (var7_12 == '+') {
            ++var5_11;
            var12_7 = true;
            var14_9 = 1;
        }
        var16_13 = var10_5 != false ? this.oraDecPatNeg : this.oraDecPatPos;
        var6_14 = var5_11;
        while (true) {
            block36: {
                var9_16 = false;
                var8_15 = false;
                var17_17 = 1;
                while (var15_10[var13_8] < 0 && var17_17 <= 4) {
                    block0 : switch (var16_13.getNthComponent(var17_17)) {
                        case 1: {
                            var18_18 = 0;
                            var19_19 = 0;
                            var20_20 = 0;
                            var21_21 = 0;
                            var22_22 = var16_13.groupingSizes;
                            if (var5_11 < var4_4 && var2_2.charAt(var5_11) == this.symbols.getInfinity()) {
                                var8_15 = true;
                                ++var5_11;
                                break;
                            }
                            if (var22_22.length() != 1) ** GOTO lbl48
                            var20_20 = var21_21 = var22_22.charAt(0) - 48;
                            ** GOTO lbl79
lbl48:
                            // 1 sources

                            if (var22_22.length() != 2) ** GOTO lbl52
                            var20_20 = var22_22.charAt(0) - 48;
                            var21_21 = var22_22.charAt(1) - 48;
                            if (true) ** GOTO lbl79
lbl52:
                            // 1 sources

                            throw new IllegalArgumentException(GDKMessage.getMessage(5084));
                            do {
                                if (Character.isDigit(var7_12 = var2_2.charAt(var5_11))) {
                                    if (var9_16 && var19_19 >= var16_13.numberOfDigitsRHS) {
                                        var15_10[var13_8] = var5_11;
                                        break block0;
                                    }
                                    ++var19_19;
                                    if (!this.isParseIntegerOnly() || !var9_16) {
                                        var1_1.append(Character.digit(var7_12, 10));
                                    }
                                } else if (var7_12 == this.symbols.getDecimalSeparator()) {
                                    if (var9_16 || var18_18 > 0 && var19_19 - var18_18 != var20_20 || var18_18 == 0 && var19_19 > var20_20) {
                                        var15_10[var13_8] = var5_11;
                                        break block0;
                                    }
                                    var9_16 = true;
                                    var19_19 = 0;
                                    if (!this.isParseIntegerOnly()) {
                                        var1_1.append('.');
                                    }
                                } else {
                                    if (var7_12 != this.symbols.getGroupingSeparator() || Character.isWhitespace(var7_12) && (var9_16 || var5_11 + 1 >= var4_4 || !Character.isDigit(var2_2.charAt(var5_11 + 1)))) break block0;
                                    if (var9_16 || var18_18 > 0 && var19_19 - var18_18 != var21_21 || var18_18 == 0 && var19_19 > var21_21) {
                                        var15_10[var13_8] = var5_11;
                                        break block0;
                                    }
                                    var18_18 = var19_19;
                                }
                                ++var5_11;
lbl79:
                                // 3 sources

                            } while (var5_11 < var4_4);
                            break;
                        }
                        case 2: {
                            if (var12_7) {
                                if (var5_11 == var6_14) break;
                                var15_10[var13_8] = var6_14 - 1;
                                break;
                            }
                            if (var5_11 >= var4_4) break;
                            if ((var7_12 = var2_2.charAt(var5_11++)) == '-') {
                                var10_5 = true;
                                break;
                            }
                            if (var7_12 == '+') break;
                            var15_10[var13_8] = var5_11;
                            break;
                        }
                        case 3: {
                            if (var5_11 < var4_4 && Character.isWhitespace(var2_2.charAt(var5_11++))) break;
                            var15_10[var13_8] = var5_11;
                            break;
                        }
                        case 4: {
                            var23_23 = this.symbols.getCurrencySymbol();
                            var24_24 = var23_23.length();
                            if (var5_11 + var24_24 > var4_4 || !var2_2.regionMatches(true, var5_11, var23_23, 0, var24_24)) {
                                var15_10[var13_8] = var5_11;
                                break;
                            }
                            var5_11 += var24_24;
                            break;
                        }
                        case 5: {
                            if (var5_11 == var6_14 && var11_6) break;
                            var15_10[var13_8] = var5_11;
                            break;
                        }
                    }
                    ++var17_17;
                }
                if (var15_10[var13_8] >= 0) break block36;
                if (!var11_6) ** GOTO lbl117
                if (var5_11 >= var4_4 || var2_2.charAt(var5_11) != ')') {
                    var15_10[var13_8] = var5_11;
                } else {
                    ++var5_11;
lbl117:
                    // 2 sources

                    if (var5_11 < var4_4) {
                        var15_10[var13_8] = var5_11;
                    } else {
                        if (var8_15) {
                            return var10_5 != false ? -6 : -5;
                        }
                        if (var10_5) {
                            var1_1.insert(0, '-');
                        }
                        if (var9_16 && !this.isParseIntegerOnly()) {
                            return -2;
                        }
                        return -1;
                    }
                }
            }
            if (++var13_8 >= var14_9 || var16_13.equals(this.oraDecPatNeg)) break;
            var16_13 = this.oraDecPatNeg;
            var5_11 = var6_14;
            if (var1_1.length() <= 0) continue;
            var1_1.delete(0, var1_1.length());
        }
        return var10_5 != false ? var15_10[1] : var15_10[0];
    }

    /*
     * Enabled aggressive block sorting
     */
    private int parse(StringBuffer stringBuffer, String string, int n, OraDecimalFormatPattern oraDecimalFormatPattern, boolean bl) {
        char c;
        int n2 = string.length();
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        char c2 = oraDecimalFormatPattern.usePeriod ? (char)'.' : (char)this.symbols.getDecimalSeparator();
        char c3 = c = oraDecimalFormatPattern.useComma ? (char)',' : (char)this.symbols.getGroupingSeparator();
        String string2 = oraDecimalFormatPattern.useDollar ? "$" : (oraDecimalFormatPattern.useIntlCurrency ? this.symbols.getInternationalCurrencySymbol() : this.symbols.getCurrencySymbol());
        int n3 = n;
        while (n3 < n2 && Character.isWhitespace(string.charAt(n3))) {
            ++n3;
        }
        if (n3 == n2) {
            if (!oraDecimalFormatPattern.isBOn) return n3;
            stringBuffer.append('0');
            return -3;
        }
        if (n3 > n2) {
            return n3;
        }
        char c4 = string.charAt(n3);
        if (c4 == '-') {
            if (!bl) {
                return n3;
            }
            ++n3;
            bl6 = true;
        } else if (c4 == '+') {
            ++n3;
            bl6 = true;
        }
        int n4 = n3;
        int n5 = 1;
        while (n5 <= 4) {
            switch (oraDecimalFormatPattern.getNthComponent(n5)) {
                case 1: {
                    boolean bl8 = false;
                    int n6 = 0;
                    int n7 = 0;
                    int n8 = 0;
                    boolean bl9 = false;
                    int n9 = 0;
                    int n10 = 0;
                    if (n3 < n2 && string.charAt(n3) == this.symbols.getInfinity()) {
                        bl2 = true;
                        ++n3;
                        break;
                    }
                    while (n3 < n2) {
                        c4 = string.charAt(n3);
                        if (Character.isDigit(c4)) {
                            ++n9;
                            if (!this.isParseIntegerOnly() || !bl3 && !bl7) {
                                stringBuffer.append(Character.digit(c4, 10));
                            }
                        } else if (c4 == c2) {
                            if (bl3) return n3;
                            if (!this.decimalSeparatorShown) {
                                return n3;
                            }
                            bl3 = true;
                            n7 = n9;
                            n9 = 0;
                            if (!this.isParseIntegerOnly()) {
                                stringBuffer.append('.');
                            }
                        } else if (c4 == c) {
                            if (bl3 || bl7 || !this.isGroupingUsed()) {
                                if (!Character.isWhitespace(c4)) return n3;
                                break;
                            }
                            if (Character.isWhitespace(c4) && (n3 + 1 >= n2 || !Character.isDigit(string.charAt(n3 + 1)))) break;
                            n10 = n9;
                            while (n6 < oraDecimalFormatPattern.numberOfGroups && oraDecimalFormatPattern.groupingSeparatorPositions[n6++] <= n9) {
                            }
                        } else if (c4 == 'E' || c4 == 'e') {
                            if (bl7) {
                                return n3;
                            }
                            bl7 = true;
                            if (bl3) {
                                n8 = n9;
                            } else {
                                n7 = n9;
                            }
                            n9 = 0;
                            if (!this.isParseIntegerOnly()) {
                                stringBuffer.append('E');
                            }
                        } else {
                            if (c4 != '-' && c4 != '+' || !bl7) break;
                            if (n9 > 0) {
                                return n3;
                            }
                            stringBuffer.append(c4);
                        }
                        ++n3;
                    }
                    if (!bl7) {
                        if (!bl3) {
                            n7 = n9;
                        } else {
                            n8 = n9;
                        }
                    }
                    int n11 = oraDecimalFormatPattern.numberOfGroups > 0 ? oraDecimalFormatPattern.numberOfDigitsLHS - oraDecimalFormatPattern.groupingSeparatorPositions[oraDecimalFormatPattern.numberOfGroups - 1] : oraDecimalFormatPattern.numberOfDigitsLHS;
                    if (oraDecimalFormatPattern.numberOfDigitsLHS < n7) return n3;
                    if (oraDecimalFormatPattern.numberOfDigitsRHS < n8) return n3;
                    if (n10 > 0) {
                        if (n11 != n7 - n10) return n3;
                    }
                    if (n10 != 0 || n11 >= n7) break;
                    return n3;
                }
                case 2: {
                    if (bl6) {
                        if (n3 != n4) return n4 - 1;
                        break;
                    }
                    if (n3 >= n2 || !((c4 = string.charAt(n3++)) == '-' ? !bl : c4 != '+')) break;
                    return n3;
                }
                case 3: {
                    if (n3 >= n2) return n3;
                    if (Character.isWhitespace(string.charAt(n3++))) break;
                    return n3;
                }
                case 4: {
                    int n12 = string2.length();
                    if (n3 + n12 > n2) return n3;
                    if (!string.regionMatches(true, n3, string2, 0, n12)) {
                        return n3;
                    }
                    n3 += n12;
                    break;
                }
                case 5: {
                    if (n3 >= n2) return n3;
                    if (string.charAt(n3++) != '(') {
                        return n3;
                    }
                    bl4 = true;
                    break;
                }
                case 6: {
                    if (n3 >= n2) return n3;
                    if (string.charAt(n3++) != '<') {
                        return n3;
                    }
                    bl5 = true;
                    break;
                }
            }
            ++n5;
        }
        if (bl4) {
            if (n3 >= n2) return n3;
            if (string.charAt(n3) != ')') return n3;
        }
        if (bl5) {
            if (n3 >= n2) return n3;
            if (string.charAt(n3) != '>') {
                return n3;
            }
        }
        if (bl4 || bl5) {
            ++n3;
        }
        if (n3 < n2) {
            return n3;
        }
        if (bl2) {
            if (!bl) return -5;
            return -6;
        }
        if (bl) {
            stringBuffer.insert(0, '-');
        }
        if (!bl3) {
            if (!bl7) return -1;
        }
        if (this.isParseIntegerOnly()) return -1;
        if (!bl7) return -2;
        return -21;
    }

    private BigDecimal toBigDecimal(StringBuffer stringBuffer) {
        int n;
        String string = stringBuffer.toString();
        int n2 = string.charAt((n = string.indexOf(69)) + 1) == '+' ? new Integer(string.substring(n + 2, string.length())).intValue() : new Integer(string.substring(n + 1, string.length())).intValue();
        stringBuffer.delete(n, string.length());
        if (n2 == 0) {
            return new BigDecimal(stringBuffer.toString());
        }
        int n3 = string.indexOf(46);
        if (n3 >= 0) {
            stringBuffer.deleteCharAt(n3);
            n2 -= n - n3 - 1;
        }
        if (n2 <= 0) {
            return new BigDecimal(new BigInteger(stringBuffer.toString()), -n2);
        }
        int n4 = 0;
        while (n4 < n2) {
            stringBuffer.append('0');
            ++n4;
        }
        return new BigDecimal(new BigInteger(stringBuffer.toString()), 0);
    }
}

