/*
 * Decompiled with CFR 0.152.
 */
package oracle.i18n.text;

import java.math.BigDecimal;
import java.math.BigInteger;

final class OraDecimal {
    int numberOfDigitsLHS = 0;
    int numberOfDigitsRHS = 0;
    int numberOfDigits = 0;
    int exponent = 0;
    char[] digits;
    boolean isZero = false;

    OraDecimal(BigDecimal bigDecimal, int n, boolean bl) {
        this.setDigits(bigDecimal, n, bl);
    }

    OraDecimal(BigInteger bigInteger, int n, boolean bl) {
        this.setDigits(bigInteger, n, bl);
    }

    OraDecimal(double d, int n, boolean bl) {
        this.setDigits(d, n, bl);
    }

    OraDecimal(long l, int n, boolean bl) {
        this.setDigits(l, n, bl);
    }

    private void setDigits(BigDecimal bigDecimal, int n, boolean bl) {
        String string = bigDecimal.toString();
        int n2 = 0;
        int n3 = string.length();
        if (string.charAt(0) == '-') {
            ++n2;
        }
        while (n2 < n3) {
            char c = string.charAt(n2);
            if (c != '.' && c != '0') break;
            ++n2;
        }
        if (n2 == n3) {
            this.isZero = true;
            return;
        }
        int n4 = n3 - 1;
        while (n4 > n2 && string.charAt(n4) == '0') {
            --n4;
        }
        int n5 = string.indexOf(46);
        if (n5 < 0) {
            n5 = n3;
        }
        this.numberOfDigits = n4 - n2;
        this.numberOfDigitsLHS = n5 - n2;
        int n6 = this.numberOfDigitsRHS = n4 >= n5 ? n4 - n5 : 0;
        if (n5 < n2) {
            ++this.numberOfDigits;
            ++this.numberOfDigitsLHS;
        } else if (string.indexOf(46) < 0) {
            ++this.numberOfDigits;
        }
        this.digits = new char[this.numberOfDigits];
        int n7 = 0;
        if (n5 < n4) {
            int n8 = n2;
            while (n8 < n5) {
                this.digits[n7++] = string.charAt(n8);
                ++n8;
            }
            if (n5 > n2) {
                ++n8;
            }
            while (n8 <= n4) {
                this.digits[n7++] = string.charAt(n8);
                ++n8;
            }
        } else {
            int n9 = n2;
            while (n9 <= n4) {
                this.digits[n7++] = string.charAt(n9);
                ++n9;
            }
        }
        if (bl) {
            this.exponent += this.numberOfDigitsLHS - 1;
            this.numberOfDigitsLHS = 1;
            this.numberOfDigitsRHS = this.numberOfDigits - 1;
        }
        if (n >= 0 && this.numberOfDigitsRHS > n) {
            this.round(n, bl);
        }
    }

    private void setDigits(BigInteger bigInteger, int n, boolean bl) {
        int n2 = 0;
        String string = bigInteger.toString();
        this.numberOfDigits = string.length();
        if (this.numberOfDigits == 1 && string.charAt(0) == '0') {
            this.isZero = true;
            return;
        }
        this.numberOfDigitsLHS = this.numberOfDigits;
        int n3 = this.numberOfDigitsLHS - 1;
        while (n3 > 0 && string.charAt(n3) == '0') {
            --this.numberOfDigits;
            --n3;
        }
        if (string.charAt(0) == '-') {
            n2 = 1;
            --this.numberOfDigits;
            --this.numberOfDigitsLHS;
        }
        this.digits = new char[this.numberOfDigits];
        int n4 = 0;
        while (n4 < this.numberOfDigits) {
            this.digits[n4] = string.charAt(n2++);
            ++n4;
        }
        if (bl) {
            this.exponent = this.numberOfDigitsLHS - 1;
            this.numberOfDigitsLHS = 1;
            this.numberOfDigitsRHS = this.numberOfDigits - 1;
        }
        if (n >= 0 && this.numberOfDigitsRHS > n) {
            this.round(n, bl);
        }
    }

    private void setDigits(double d, int n, boolean bl) {
        int n2 = 0;
        boolean bl2 = false;
        boolean bl3 = false;
        if (d == 0.0) {
            this.isZero = true;
            return;
        }
        String string = Double.toString(d);
        this.digits = new char[string.length()];
        int n3 = 0;
        while (n3 < string.length()) {
            char c = string.charAt(n3);
            if (c == '.') {
                this.numberOfDigitsLHS = this.numberOfDigits;
                bl2 = true;
            } else {
                if (c == 'E' || c == 'e') {
                    this.exponent = Integer.valueOf(string.substring(n3 + 1));
                    break;
                }
                if (!bl3) {
                    boolean bl4 = bl3 = c != '0';
                }
                if (bl3) {
                    this.digits[this.numberOfDigits++] = c;
                }
                if (!bl3 && bl2) {
                    ++n2;
                }
            }
            ++n3;
        }
        while (this.numberOfDigits > 0 && this.digits[this.numberOfDigits - 1] == '0') {
            --this.numberOfDigits;
        }
        if (this.numberOfDigitsLHS == 0) {
            this.numberOfDigitsLHS = -n2;
            this.numberOfDigitsRHS = this.numberOfDigits + n2;
        } else {
            this.numberOfDigitsLHS += this.exponent;
            if (this.numberOfDigits > this.numberOfDigitsLHS) {
                this.numberOfDigitsRHS = this.numberOfDigits - this.numberOfDigitsLHS;
            }
        }
        if (bl) {
            this.exponent = this.numberOfDigitsLHS - 1;
            this.numberOfDigitsLHS = 1;
            this.numberOfDigitsRHS = this.numberOfDigits - 1;
        }
        if (n >= 0 && this.numberOfDigitsRHS > n) {
            this.round(n, bl);
        }
    }

    private void setDigits(long l, int n, boolean bl) {
        if (l == 0L) {
            this.isZero = true;
            return;
        }
        String string = Long.toString(l);
        this.digits = string.toCharArray();
        this.numberOfDigitsLHS = this.numberOfDigits = this.digits.length;
        while (this.numberOfDigits > 0 && this.digits[this.numberOfDigits - 1] == '0') {
            --this.numberOfDigits;
        }
        if (bl) {
            this.exponent = this.numberOfDigitsLHS - 1;
            this.numberOfDigitsLHS = 1;
            this.numberOfDigitsRHS = this.numberOfDigits - 1;
        }
        if (n >= 0 && this.numberOfDigitsRHS > n) {
            this.round(n, bl);
        }
    }

    private void round(int n, boolean bl) {
        int n2 = this.numberOfDigits;
        int n3 = n + this.numberOfDigitsLHS;
        if (n3 < 0) {
            this.numberOfDigits = 0;
            this.numberOfDigitsLHS = -n;
        } else {
            int n4 = this.digits[n3] - 48;
            int n5 = 0;
            if (n4 > 4) {
                n5 = 1;
                int n6 = n3 - 1;
                while (n5 > 0 && n6 >= 0) {
                    int n7 = this.digits[n6] - 48 + n5;
                    this.digits[n6] = (char)(48 + n7 % 10);
                    n5 = n7 / 10;
                    --n6;
                }
                if (n5 > 0) {
                    this.digits[0] = 49;
                    this.numberOfDigits = 1;
                    if (bl) {
                        ++this.exponent;
                    } else {
                        ++this.numberOfDigitsLHS;
                    }
                } else {
                    this.numberOfDigits = n3;
                    while (this.numberOfDigits > 0 && this.digits[this.numberOfDigits - 1] == '0') {
                        --this.numberOfDigits;
                    }
                }
            } else {
                this.numberOfDigits = n3;
                while (this.numberOfDigits > 0 && this.digits[this.numberOfDigits - 1] == '0') {
                    --this.numberOfDigits;
                }
            }
        }
        if (this.numberOfDigits == 0) {
            this.isZero = true;
            this.numberOfDigitsRHS = 0;
            this.numberOfDigitsLHS = 0;
        }
        this.numberOfDigitsRHS = n2 == this.numberOfDigits ? n : (this.numberOfDigits > this.numberOfDigitsLHS ? this.numberOfDigits - this.numberOfDigitsLHS : 0);
    }
}

