/*
 * Decompiled with CFR 0.152.
 */
package oracle.i18n.text;

import java.io.UTFDataFormatException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.sql.SQLException;
import oracle.gss.util.NLSError;
import oracle.i18n.text.OraCharset;
import oracle.i18n.text.OraCharsetDecoder;
import oracle.i18n.text.OraCharsetEncoder;

class OraCharsetAL32UTF8
extends OraCharset {
    OraCharsetAL32UTF8(String string, int n) {
        super(string, n);
    }

    public boolean contains(Charset charset) {
        return true;
    }

    public CharsetDecoder newDecoder() {
        return new OraCharsetDecoder(this, 1.0f, 1.0f);
    }

    public CharsetEncoder newEncoder() {
        return new OraCharsetEncoder(this, 1.0f, 4.0f);
    }

    String toStringWithReplacement(byte[] byArray, int n, int n2) {
        try {
            char[] cArray = new char[byArray.length];
            int n3 = OraCharset.AL32UTF8ToJavaChar(byArray, n, n2, cArray, OraCharset.CharacterConverterBehavior.REPLACEMENT);
            return new String(cArray, 0, n3);
        }
        catch (UTFDataFormatException uTFDataFormatException) {
            return "";
        }
    }

    String toString(byte[] byArray, int n, int n2) throws SQLException {
        try {
            char[] cArray = new char[byArray.length];
            int n3 = OraCharset.AL32UTF8ToJavaChar(byArray, n, n2, cArray, OraCharset.CharacterConverterBehavior.REPORT_ERROR);
            return new String(cArray, 0, n3);
        }
        catch (UTFDataFormatException uTFDataFormatException) {
            NLSError.throwSQLException(17037, this);
            return "";
        }
    }

    byte[] convertWithReplacement(String string) {
        char[] cArray = string.toCharArray();
        byte[] byArray = new byte[cArray.length * 3];
        int n = OraCharset.javaCharsToAL32UTF8(cArray, 0, cArray.length, byArray, 0);
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, 0, byArray2, 0, n);
        return byArray2;
    }

    byte[] convert(String string) throws SQLException {
        return this.convertWithReplacement(string);
    }
}

