/*
 * Decompiled with CFR 0.152.
 */
package oracle.i18n.servlet.localesource;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import oracle.i18n.servlet.ApplicationContext;
import oracle.i18n.text.OraBoot;
import oracle.i18n.text.OraCollator;
import oracle.i18n.text.OraDateFormat;
import oracle.i18n.text.OraNumberFormat;
import oracle.i18n.util.GDKOracleMetaData;
import oracle.i18n.util.LocaleMapper;
import oracle.i18n.util.OraLocaleInfo;

public abstract class LocaleSource
implements Serializable {
    private static final long serialVersionUID = GDKOracleMetaData.getOracleVersionID();
    private static final String LOCALE_DELIMITER_S = new Character('#').toString();
    private static final char LOCALE_SUB_DELIMITER = ';';
    private static final String M_C_LOCALE_DELIMITER;
    private static final String M_C_LOCALE_SUB_DELIMITER;
    private static final char M_C_BACKSLASH = '\\';
    private static final String M_C_DOUBLE_BACKSLASH = "\\\\";
    private static final char M_C_EQUAL = '=';
    private static final String M_C_BACKSLASH_EQUAL = "\\=";
    private static final TimeZone M_C_UTC_TIMEZONE;
    public static final String OBJECT_KEY = "oracle.i18n.servlet.localesource.LocaleSource.sessionkey";
    public static final String IS_ACCESSIBLE_METHOD = "isAccessible";
    public static final String GET_INSTANCE_METHOD = "getInstance";
    private final boolean m_isCached;
    private final boolean m_isReadOnly;
    private final boolean m_isValidated;
    private transient Map m_objects = new HashMap();
    private transient Map m_sobjects = new HashMap();

    protected LocaleSource(Class clazz, boolean bl, boolean bl2, boolean bl3) {
        this.setLocaleSourceClass(clazz);
        this.m_isCached = bl;
        this.m_isReadOnly = bl2;
        this.m_isValidated = bl3;
    }

    public final boolean isCached() {
        return this.m_isCached;
    }

    public final boolean isReadOnly() {
        return this.m_isReadOnly;
    }

    public final boolean isValidated() {
        return this.m_isValidated;
    }

    public abstract boolean store();

    public abstract boolean load();

    public final void setLocale(Locale locale) {
        this.setAttribute(Parameter.LOCALE, (Object)locale);
    }

    public final void setLocale(Locale locale, ApplicationContext applicationContext) {
        if (!this.isValidated() && applicationContext != null) {
            this.setAttribute(Parameter.LOCALE, (Object)applicationContext.fallbackLocale(locale));
        } else {
            this.setAttribute(Parameter.LOCALE, (Object)locale);
        }
    }

    public final void setISOCurrency(String string) {
        this.setAttribute(Parameter.ISO_CURRENCY, (Object)string);
    }

    public final void setCharacterSet(String string) {
        if (string != null) {
            String string2;
            String string3 = OraBoot.getInstance().getCharSetId(string);
            if (string3 != null) {
                this.setAttribute(Parameter.CHARSET, (Object)string);
            }
            if ((string2 = LocaleMapper.getOraCharacterSet(2, string)) != null) {
                this.setAttribute(Parameter.CHARSET, (Object)string2);
            }
        }
    }

    public final void setLocaleSourceClass(Class clazz) {
        this.setAttribute(Parameter.LOCALE_SOURCE, (Object)clazz);
    }

    public final void setTimeZone(TimeZone timeZone) {
        this.setAttribute(Parameter.TIMEZONE, (Object)timeZone);
    }

    public final void setDateTimeFormat(int n, OraDateFormat oraDateFormat) {
        switch (n) {
            case 3: {
                this.setAttribute(Parameter.DATE_TIME_FORMAT, (Object)oraDateFormat);
                break;
            }
            case 1: {
                this.setAttribute(Parameter.LONG_DATE_TIME_FORMAT, (Object)oraDateFormat);
                break;
            }
            default: {
                this.setAttribute(Parameter.DATE_TIME_FORMAT, (Object)oraDateFormat);
            }
        }
    }

    public final void setDateFormat(int n, OraDateFormat oraDateFormat) {
        switch (n) {
            case 3: {
                this.setAttribute(Parameter.DATE_FORMAT, (Object)oraDateFormat);
                break;
            }
            case 1: {
                this.setAttribute(Parameter.LONG_DATE_FORMAT, (Object)oraDateFormat);
                break;
            }
            default: {
                this.setAttribute(Parameter.DATE_FORMAT, (Object)oraDateFormat);
            }
        }
    }

    public final void setTimeFormat(OraDateFormat oraDateFormat) {
        this.setAttribute(Parameter.TIME_FORMAT, (Object)oraDateFormat);
    }

    public final void setWritingDirection(WritingDirection writingDirection) {
        this.setAttribute(Parameter.WRITING_DIRECTION, (Object)writingDirection);
    }

    public final void setCurrencyFormat(OraNumberFormat oraNumberFormat) {
        this.setAttribute(Parameter.CURRENCY_FORMAT, (Object)oraNumberFormat);
    }

    public final void setNumberFormat(OraNumberFormat oraNumberFormat) {
        this.setAttribute(Parameter.NUMBER_FORMAT, (Object)oraNumberFormat);
    }

    public final void setCollator(OraCollator oraCollator) {
        this.setAttribute(Parameter.LINGUISTIC_SORT, (Object)oraCollator);
    }

    protected final synchronized void setAttribute(String string, Object object) {
        this.m_sobjects.put(string, object);
    }

    private final synchronized void setAttribute(Parameter parameter, Object object) {
        this.m_objects.put(parameter, object);
    }

    public final Locale getLocale() {
        return (Locale)this.getAttribute(Parameter.LOCALE);
    }

    public final String getISOCurrency() {
        return (String)this.getAttribute(Parameter.ISO_CURRENCY);
    }

    public final String getCharacterSet() {
        return (String)this.getAttribute(Parameter.CHARSET);
    }

    public final Class getLocaleSourceClass() {
        return (Class)this.getAttribute(Parameter.LOCALE_SOURCE);
    }

    public final TimeZone getTimeZone() {
        return (TimeZone)this.getAttribute(Parameter.TIMEZONE);
    }

    public final OraDateFormat getDateTimeFormat(int n) {
        switch (n) {
            case 3: {
                return (OraDateFormat)this.getAttribute(Parameter.DATE_TIME_FORMAT);
            }
            case 1: {
                return (OraDateFormat)this.getAttribute(Parameter.LONG_DATE_TIME_FORMAT);
            }
        }
        return (OraDateFormat)this.getAttribute(Parameter.DATE_TIME_FORMAT);
    }

    public final OraDateFormat getDateFormat(int n) {
        switch (n) {
            case 3: {
                return (OraDateFormat)this.getAttribute(Parameter.DATE_FORMAT);
            }
            case 1: {
                return (OraDateFormat)this.getAttribute(Parameter.LONG_DATE_FORMAT);
            }
        }
        return (OraDateFormat)this.getAttribute(Parameter.DATE_FORMAT);
    }

    public final OraDateFormat getTimeFormat() {
        return (OraDateFormat)this.getAttribute(Parameter.TIME_FORMAT);
    }

    public final WritingDirection getWritingDirection() {
        return (WritingDirection)this.getAttribute(Parameter.WRITING_DIRECTION);
    }

    public final OraNumberFormat getCurrencyFormat() {
        return (OraNumberFormat)this.getAttribute(Parameter.CURRENCY_FORMAT);
    }

    public final OraNumberFormat getNumberFormat() {
        return (OraNumberFormat)this.getAttribute(Parameter.NUMBER_FORMAT);
    }

    public final OraCollator getCollator() {
        return (OraCollator)this.getAttribute(Parameter.LINGUISTIC_SORT);
    }

    protected final synchronized Object getAttribute(String string) {
        return this.m_sobjects.get(string);
    }

    private final synchronized Object getAttribute(Parameter parameter) {
        return this.m_objects.get(parameter);
    }

    public final void setDefaultValues(Locale locale) {
        this.setDefaultValues(OraLocaleInfo.getInstance(locale));
    }

    public final void setDefaultValues(OraLocaleInfo oraLocaleInfo) {
        this.setDefaultValues(oraLocaleInfo, null, null, null, null, null, null, null, null, null, null, null, null);
    }

    public final void setDefaultValues(OraLocaleInfo oraLocaleInfo, TimeZone timeZone, WritingDirection writingDirection, OraDateFormat oraDateFormat, OraDateFormat oraDateFormat2, OraDateFormat oraDateFormat3, OraDateFormat oraDateFormat4, OraDateFormat oraDateFormat5, OraNumberFormat oraNumberFormat, OraNumberFormat oraNumberFormat2, OraCollator oraCollator, String string, String string2) {
        Object object;
        if (timeZone != null) {
            this.setTimeZone(timeZone);
        } else if (this.getTimeZone() == null) {
            object = oraLocaleInfo.getOraTerritory().getLocalTimeZoneIds()[0];
            this.setTimeZone(object != null ? TimeZone.getTimeZone((String)object) : M_C_UTC_TIMEZONE);
        }
        if (writingDirection != null) {
            this.setWritingDirection(writingDirection);
        } else if (this.getWritingDirection() == null) {
            this.setWritingDirection(oraLocaleInfo.getWritingDirection() == 0 ? WritingDirection.LTR : WritingDirection.RTL);
        }
        if (oraDateFormat != null) {
            this.setDateFormat(3, oraDateFormat);
        } else if (this.getDateFormat(3) == null) {
            object = OraDateFormat.getDateInstance(3, oraLocaleInfo);
            ((OraDateFormat)object).setTimeZone(this.getTimeZone());
            this.setDateFormat(3, (OraDateFormat)object);
        }
        if (oraDateFormat2 != null) {
            this.setDateFormat(1, oraDateFormat2);
        } else if (this.getDateFormat(1) == null) {
            object = OraDateFormat.getDateInstance(1, oraLocaleInfo);
            ((OraDateFormat)object).setTimeZone(this.getTimeZone());
            this.setDateFormat(1, (OraDateFormat)object);
        }
        if (oraDateFormat3 != null) {
            this.setTimeFormat(oraDateFormat3);
        } else if (this.getTimeFormat() == null) {
            object = OraDateFormat.getTimeInstance(oraLocaleInfo);
            ((OraDateFormat)object).setTimeZone(this.getTimeZone());
            this.setTimeFormat((OraDateFormat)object);
        }
        if (oraDateFormat4 != null) {
            this.setDateTimeFormat(3, oraDateFormat4);
        } else if (this.getDateTimeFormat(3) == null) {
            object = OraDateFormat.getDateTimeInstance(3, oraLocaleInfo);
            ((OraDateFormat)object).setTimeZone(this.getTimeZone());
            this.setDateTimeFormat(3, (OraDateFormat)object);
        }
        if (oraDateFormat5 != null) {
            this.setDateTimeFormat(1, oraDateFormat5);
        } else if (this.getDateTimeFormat(1) == null) {
            object = OraDateFormat.getDateTimeInstance(1, oraLocaleInfo);
            ((OraDateFormat)object).setTimeZone(this.getTimeZone());
            this.setDateTimeFormat(1, (OraDateFormat)object);
        }
        if (oraNumberFormat != null) {
            this.setNumberFormat(oraNumberFormat);
        } else if (this.getNumberFormat() == null) {
            this.setNumberFormat(OraNumberFormat.getInstance(oraLocaleInfo));
        }
        if (oraNumberFormat2 != null) {
            this.setCurrencyFormat(oraNumberFormat2);
        } else if (this.getCurrencyFormat() == null) {
            this.setCurrencyFormat(OraNumberFormat.getCurrencyInstance(oraLocaleInfo));
        }
        if (oraCollator != null) {
            this.setCollator(oraCollator);
        } else if (this.getCollator() == null) {
            this.setCollator(oraLocaleInfo.getOraCollator());
        }
        if (string != null) {
            this.setISOCurrency(string);
        } else if (this.getISOCurrency() == null) {
            this.setISOCurrency(oraLocaleInfo.getLocalCurrencies()[0]);
        }
        if (string2 != null) {
            this.setCharacterSet(string2);
        } else if (this.getCharacterSet() == null) {
            this.setCharacterSet(oraLocaleInfo.getLocalCharacterSets()[0]);
        }
    }

    public void setLocaleSource(LocaleSource localeSource) {
        OraCollator oraCollator;
        OraNumberFormat oraNumberFormat;
        OraNumberFormat oraNumberFormat2;
        OraDateFormat oraDateFormat;
        OraDateFormat oraDateFormat2;
        OraDateFormat oraDateFormat3;
        OraDateFormat oraDateFormat4;
        OraDateFormat oraDateFormat5;
        String string;
        String string2;
        WritingDirection writingDirection;
        this.setLocale(localeSource.getLocale());
        TimeZone timeZone = localeSource.getTimeZone();
        if (timeZone != null) {
            this.setTimeZone(timeZone);
        }
        if ((writingDirection = localeSource.getWritingDirection()) != null) {
            this.setWritingDirection(writingDirection);
        }
        if ((string2 = localeSource.getISOCurrency()) != null) {
            this.setISOCurrency(string2);
        }
        if ((string = localeSource.getCharacterSet()) != null) {
            this.setCharacterSet(string);
        }
        if ((oraDateFormat5 = localeSource.getDateFormat(3)) != null) {
            this.setDateFormat(3, (OraDateFormat)oraDateFormat5.clone());
        }
        if ((oraDateFormat4 = localeSource.getDateFormat(1)) != null) {
            this.setDateFormat(1, (OraDateFormat)oraDateFormat4.clone());
        }
        if ((oraDateFormat3 = localeSource.getTimeFormat()) != null) {
            this.setTimeFormat((OraDateFormat)oraDateFormat3.clone());
        }
        if ((oraDateFormat2 = localeSource.getDateTimeFormat(3)) != null) {
            this.setDateTimeFormat(3, (OraDateFormat)oraDateFormat2.clone());
        }
        if ((oraDateFormat = localeSource.getDateTimeFormat(1)) != null) {
            this.setDateTimeFormat(1, (OraDateFormat)oraDateFormat.clone());
        }
        if ((oraNumberFormat2 = localeSource.getNumberFormat()) != null) {
            this.setNumberFormat((OraNumberFormat)oraNumberFormat2.clone());
        }
        if ((oraNumberFormat = localeSource.getCurrencyFormat()) != null) {
            this.setCurrencyFormat((OraNumberFormat)oraNumberFormat.clone());
        }
        if ((oraCollator = localeSource.getCollator()) != null) {
            this.setCollator((OraCollator)oraCollator.clone());
        }
    }

    public static final void resetParameterVariables(Map map) {
        map.put(Parameter.LOCALE, Parameter.LOCALE.toString());
        map.put(Parameter.LANGUAGE, Parameter.LANGUAGE.toString());
        map.put(Parameter.TERRITORY, Parameter.TERRITORY.toString());
        map.put(Parameter.CHARSET, Parameter.CHARSET.toString());
        map.put(Parameter.TIMEZONE, Parameter.TIMEZONE.toString());
        map.put(Parameter.ISO_CURRENCY, Parameter.ISO_CURRENCY.toString());
        map.put(Parameter.LINGUISTIC_SORT, Parameter.LINGUISTIC_SORT.toString());
        map.put(Parameter.DATE_FORMAT, Parameter.DATE_FORMAT.toString());
        map.put(Parameter.LONG_DATE_FORMAT, Parameter.LONG_DATE_FORMAT.toString());
        map.put(Parameter.TIME_FORMAT, Parameter.TIME_FORMAT.toString());
        map.put(Parameter.DATE_TIME_FORMAT, Parameter.DATE_TIME_FORMAT.toString());
        map.put(Parameter.LONG_DATE_TIME_FORMAT, Parameter.LONG_DATE_TIME_FORMAT.toString());
        map.put(Parameter.NUMBER_FORMAT, Parameter.NUMBER_FORMAT.toString());
        map.put(Parameter.CURRENCY_FORMAT, Parameter.CURRENCY_FORMAT.toString());
        map.put(Parameter.WRITING_DIRECTION, Parameter.WRITING_DIRECTION.toString());
        map.put(Parameter.COMMAND, Parameter.COMMAND.toString());
        map.put(Parameter.LOCALE_SOURCE, Parameter.LOCALE_SOURCE.toString());
    }

    public boolean equals(Object object) {
        if (!(object instanceof LocaleSource)) {
            return false;
        }
        LocaleSource localeSource = (LocaleSource)object;
        return this.m_objects.equals(localeSource.m_objects) && this.m_sobjects.equals(localeSource.m_sobjects);
    }

    public int hashCode() {
        int n = 37;
        n = 37 * n + (this.isCached() ? 1 : 0);
        n = 37 * n + (this.isReadOnly() ? 1 : 0);
        n = 37 * n + (this.isValidated() ? 1 : 0);
        n = 37 * n + this.m_objects.hashCode();
        return 37 * n + this.m_sobjects.hashCode();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        Object object;
        objectOutputStream.defaultWriteObject();
        Parameter[] parameterArray = Parameter.toArray();
        int n = 0;
        int n2 = Parameter.size();
        while (n < n2) {
            if (parameterArray[n].equals(Parameter.LINGUISTIC_SORT)) {
                object = (OraCollator)this.m_objects.get(parameterArray[n]);
                if (object != null) {
                    objectOutputStream.writeUTF(((OraCollator)object).getName());
                    objectOutputStream.writeUTF(((OraCollator)object).getCharSet());
                    objectOutputStream.writeInt(((OraCollator)object).getStrength());
                    objectOutputStream.writeInt(((OraCollator)object).getComposition());
                } else {
                    objectOutputStream.writeUTF("");
                    objectOutputStream.writeUTF("");
                    objectOutputStream.writeInt(0);
                    objectOutputStream.writeInt(0);
                }
            } else {
                objectOutputStream.writeObject(this.m_objects.get(parameterArray[n]));
            }
            ++n;
        }
        objectOutputStream.writeInt(this.m_sobjects.size());
        object = null;
        Iterator iterator = this.m_sobjects.keySet().iterator();
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            objectOutputStream.writeUTF((String)object);
            objectOutputStream.writeObject(this.getAttribute((String)object));
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.m_objects = new HashMap();
        Parameter[] parameterArray = Parameter.toArray();
        Object object = null;
        int n = 0;
        int n2 = Parameter.size();
        while (n < n2) {
            if (parameterArray[n].equals(Parameter.LINGUISTIC_SORT)) {
                String string = objectInputStream.readUTF();
                String string2 = objectInputStream.readUTF();
                int n3 = objectInputStream.readInt();
                int n4 = objectInputStream.readInt();
                if (!string.equals("")) {
                    OraCollator oraCollator = OraCollator.getInstance(string, string2);
                    oraCollator.setStrength(n3);
                    oraCollator.setComposition(n4);
                    this.m_objects.put(parameterArray[n], oraCollator);
                }
            } else {
                object = objectInputStream.readObject();
                if (object != null) {
                    this.m_objects.put(parameterArray[n], object);
                }
            }
            ++n;
        }
        int n5 = objectInputStream.readInt();
        this.m_sobjects = new HashMap();
        int n6 = 0;
        while (n6 < n5) {
            this.setAttribute(objectInputStream.readUTF(), objectInputStream.readObject());
            ++n6;
        }
    }

    static {
        String string = Integer.toHexString(35);
        M_C_LOCALE_DELIMITER = "\\u" + new String("000" + string).substring(string.length() - 1);
        string = Integer.toHexString(59);
        M_C_LOCALE_SUB_DELIMITER = "\\u" + new String("000" + string).substring(string.length() - 1);
        M_C_UTC_TIMEZONE = TimeZone.getTimeZone("GMT");
    }

    public static class Parameter {
        private static int m_nextOrdinal = 0;
        public static final Parameter LOCALE = new Parameter("locale");
        public static final Parameter LANGUAGE = new Parameter("language");
        public static final Parameter TERRITORY = new Parameter("territory");
        public static final Parameter CHARSET = new Parameter("charset");
        public static final Parameter TIMEZONE = new Parameter("timezone");
        public static final Parameter ISO_CURRENCY = new Parameter("iso-currency");
        public static final Parameter LINGUISTIC_SORT = new Parameter("linguistic-sort");
        public static final Parameter DATE_FORMAT = new Parameter("date-format");
        public static final Parameter LONG_DATE_FORMAT = new Parameter("long-date-format");
        public static final Parameter TIME_FORMAT = new Parameter("time-format");
        public static final Parameter DATE_TIME_FORMAT = new Parameter("date-time-format");
        public static final Parameter LONG_DATE_TIME_FORMAT = new Parameter("long-date-time-format");
        public static final Parameter NUMBER_FORMAT = new Parameter("number-format");
        public static final Parameter CURRENCY_FORMAT = new Parameter("currency-format");
        public static final Parameter WRITING_DIRECTION = new Parameter("writing-direction");
        public static final Parameter COMMAND = new Parameter("command", false);
        public static final Parameter LOCALE_SOURCE = new Parameter("locale-source");
        private static final Parameter[] m_array = new Parameter[]{LOCALE, LANGUAGE, TERRITORY, CHARSET, TIMEZONE, ISO_CURRENCY, LINGUISTIC_SORT, DATE_FORMAT, LONG_DATE_FORMAT, TIME_FORMAT, DATE_TIME_FORMAT, LONG_DATE_TIME_FORMAT, NUMBER_FORMAT, CURRENCY_FORMAT, WRITING_DIRECTION, COMMAND, LOCALE_SOURCE};
        private final int m_ordinal = m_nextOrdinal++;
        private String m_name;
        private boolean m_serial;

        private Parameter(String string) {
            this(string, true);
        }

        private Parameter(String string, boolean bl) {
            this.m_name = string;
            this.m_serial = bl;
        }

        public String toString() {
            return this.m_name;
        }

        public static final int size() {
            return m_nextOrdinal;
        }

        public static final Parameter[] toArray() {
            return m_array;
        }
    }

    public static class Alignment
    implements Serializable {
        public static final Alignment START = new Alignment("START");
        public static final Alignment END = new Alignment("END");
        private final String m_name;

        private Alignment(String string) {
            this.m_name = string;
        }

        public Alignment getAlignment(String string) {
            return !string.toUpperCase(Locale.US).equals("END") ? START : END;
        }

        public String toString() {
            return this.m_name;
        }

        public int hashCode() {
            return this.m_name.hashCode();
        }
    }

    public static class WritingDirection
    implements Serializable {
        public static final WritingDirection LTR = new WritingDirection("LTR");
        public static final WritingDirection RTL = new WritingDirection("RTL");
        private final String m_name;

        private WritingDirection(String string) {
            this.m_name = string;
        }

        public static WritingDirection getWritingDirection(String string) {
            return !string.toUpperCase(Locale.US).equals("RTL") ? LTR : RTL;
        }

        public final String toString() {
            return this.m_name;
        }

        public boolean equals(Object object) {
            if (!(object instanceof WritingDirection)) {
                return false;
            }
            WritingDirection writingDirection = (WritingDirection)object;
            return writingDirection.toString().equals(this.toString());
        }

        public int hashCode() {
            return this.m_name.hashCode();
        }
    }
}

