/*
 * Decompiled with CFR 0.152.
 */
package oracle.i18n.servlet.filter;

import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import oracle.i18n.servlet.ApplicationContext;
import oracle.i18n.servlet.GeneralHelper;
import oracle.i18n.servlet.ServletHelper;
import oracle.i18n.servlet.filter.ServletRequestWrapper;
import oracle.i18n.servlet.localesource.LocaleSource;

public class ServletResponseWrapper
extends HttpServletResponseWrapper {
    private static final String M_C_COMMAND_CLEAN = "clean";
    private static final String M_C_CHARSET = "charset=";
    private final ServletRequestWrapper m_request;
    private final ApplicationContext m_appctx;
    private final LocaleSource m_locsrc;
    private boolean m_isSetLocale = false;
    private boolean m_isSetContentType = false;
    private String m_charset = null;
    private PrintWriter writer = null;

    public ServletResponseWrapper(ServletRequestWrapper servletRequestWrapper, HttpServletResponse httpServletResponse) {
        super(httpServletResponse);
        this.m_request = servletRequestWrapper;
        this.m_appctx = ServletHelper.getApplicationContextInstance((HttpServletRequest)servletRequestWrapper);
        this.m_locsrc = (LocaleSource)servletRequestWrapper.getSession().getAttribute("oracle.i18n.servlet.localesource.LocaleSource.sessionkey");
        if (this.m_locsrc.isCached()) {
            servletRequestWrapper.getSession().setAttribute("oracle.i18n.servlet.filter.cache", (Object)this.m_locsrc);
        } else {
            servletRequestWrapper.getSession().removeAttribute("oracle.i18n.servlet.filter.cache");
        }
    }

    public void setContentType(String string) {
        int n = string.indexOf(59);
        int n2 = string.indexOf(M_C_CHARSET);
        String string2 = n > 0 ? string.substring(0, n) : string;
        try {
            if (!this.m_appctx.isIANAPageCharacterSetForcedSet() && n > 0 && n2 > 0) {
                this.m_charset = GeneralHelper.getIANACharacterSetFromCs(string.substring(n2 + M_C_CHARSET.length()));
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        if (this.m_charset == null) {
            this.m_charset = this.m_request.getCharacterEncoding();
        }
        super.setContentType(string2 + ";" + M_C_CHARSET + this.m_charset);
        this.m_isSetContentType = true;
    }

    public String getCharacterEncoding() {
        if (this.m_charset == null) {
            this.m_charset = this.m_request.getCharacterEncoding();
        }
        return this.m_charset;
    }

    public void setLocale(Locale locale) {
        super.setLocale(locale);
        this.m_charset = this.m_appctx.getIANAPageCharacterSet(locale, null);
        this.m_isSetLocale = true;
    }

    public Locale getLocale() {
        if (this.m_isSetLocale) {
            return super.getLocale();
        }
        return this.m_locsrc.getLocale();
    }
}

