/*
 * Decompiled with CFR 0.152.
 */
package oracle.i18n.servlet.filter;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import oracle.i18n.servlet.ApplicationContext;
import oracle.i18n.servlet.ServletHelper;
import oracle.i18n.servlet.localesource.LocaleSource;
import oracle.i18n.servlet.localesource.NonCachedUserInput;
import oracle.i18n.util.LocaleMapper;

public class ServletRequestWrapper
extends HttpServletRequestWrapper {
    private static final String M_C_COMMAND_STORE = "store";
    private static final String M_C_COMMAND_CLEAN = "clean";
    private static final String M_C_USER_AGENT = "User-Agent";
    private static final String M_C_ISO_8859_1 = "iso-8859-1";
    private static final Map M_C_EMPTY_MAP = new HashMap();
    private final ApplicationContext m_appctx;
    private final LocaleSource m_locsrc;
    private final Map m_pmap;
    private final String m_orgcharset;
    private String m_pagecharset = null;
    static /* synthetic */ Class class$oracle$i18n$servlet$localesource$UserInput;

    public ServletRequestWrapper(HttpServletRequest httpServletRequest) throws IOException {
        super(httpServletRequest);
        String string = super.getCharacterEncoding();
        this.m_orgcharset = string != null ? string : M_C_ISO_8859_1;
        this.m_pmap = Collections.synchronizedMap(new HashMap(super.getParameterMap()));
        this.m_appctx = ServletHelper.getApplicationContextInstance(httpServletRequest);
        if (this.m_appctx != null) {
            this.runCommand(httpServletRequest);
            this.m_locsrc = this.getCurrentLocale(httpServletRequest);
            this.getCharacterEncoding();
            httpServletRequest.getSession().setAttribute("oracle.i18n.servlet.localesource.LocaleSource.sessionkey", (Object)this.m_locsrc);
        } else {
            this.m_locsrc = null;
        }
    }

    private boolean runCommand(HttpServletRequest httpServletRequest) {
        String string = this.getRawParameter(this.m_appctx.getParameterName(LocaleSource.Parameter.COMMAND));
        if (string == null || string.equals("")) {
            return false;
        }
        if (string.equals(M_C_COMMAND_STORE)) {
            LocaleSource localeSource = NonCachedUserInput.getInstance((HttpServletRequest)this);
            List list = this.m_appctx.getLocaleSourceGetInstanceList();
            try {
                int n = 0;
                while (n < list.size()) {
                    Method method = (Method)list.get(n);
                    LocaleSource localeSource2 = (LocaleSource)method.invoke(null, new Object[]{this});
                    if (localeSource2 != null && !localeSource2.isReadOnly()) {
                        localeSource2.setLocaleSource(localeSource);
                        localeSource2.store();
                    }
                    ++n;
                }
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new RuntimeException(invocationTargetException.getMessage());
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new RuntimeException(illegalAccessException.getMessage());
            }
            httpServletRequest.getSession().removeAttribute("oracle.i18n.servlet.filter.cache");
            return true;
        }
        if (string.equals(M_C_COMMAND_CLEAN)) {
            httpServletRequest.getSession().removeAttribute("oracle.i18n.servlet.filter.cache");
            return true;
        }
        return false;
    }

    public Locale getLocale() {
        return this.m_locsrc.getLocale();
    }

    public Enumeration getLocales() {
        Vector<Locale> vector = new Vector<Locale>(1);
        vector.add(this.m_locsrc.getLocale());
        return vector.elements();
    }

    private String convertToCurrentCharset(String string) {
        try {
            return new String(string.getBytes(this.m_orgcharset), LocaleMapper.getJavaCharacterSet(2, this.getCharacterEncoding()));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalArgumentException(unsupportedEncodingException.getMessage());
        }
    }

    public String getCharacterEncoding() {
        if (this.m_pagecharset != null) {
            return this.m_pagecharset;
        }
        if (this.m_locsrc != null) {
            this.m_pagecharset = this.m_appctx.getIANAPageCharacterSet(this.m_locsrc.getLocale(), super.getHeader(M_C_USER_AGENT));
            return this.m_pagecharset;
        }
        return M_C_ISO_8859_1;
    }

    public String getRawParameter(String string) {
        if (this.m_pmap == null) {
            return null;
        }
        Object v = this.m_pmap.get(string);
        if (v == null) {
            return null;
        }
        if (v.getClass().isArray()) {
            return ((String[])v)[0];
        }
        return (String)v;
    }

    public String getParameter(String string) {
        String string2 = this.getRawParameter(string);
        if (string2 == null) {
            return null;
        }
        return this.convertToCurrentCharset(string2);
    }

    public String[] getParameterValues(String string) {
        if (this.m_pmap == null) {
            return null;
        }
        Object v = this.m_pmap.get(string);
        if (v == null) {
            return null;
        }
        if (v.getClass().isArray()) {
            String[] stringArray = (String[])v;
            String[] stringArray2 = new String[stringArray.length];
            int n = 0;
            while (n < stringArray.length) {
                stringArray2[n] = this.convertToCurrentCharset(stringArray[n]);
                ++n;
            }
            return stringArray2;
        }
        return new String[]{this.convertToCurrentCharset((String)v)};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getParameterMap() {
        if (this.m_pmap == null) {
            return Collections.EMPTY_MAP;
        }
        Map map = this.m_pmap;
        synchronized (map) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>(this.m_pmap.size());
            Iterator iterator = this.m_pmap.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                Object v = this.m_pmap.get(string);
                if (v.getClass().isArray()) {
                    String[] stringArray = (String[])v;
                    String[] stringArray2 = new String[stringArray.length];
                    int n = 0;
                    while (n < stringArray.length) {
                        stringArray2[n] = this.convertToCurrentCharset(stringArray[n]);
                        ++n;
                    }
                    hashMap.put(string, stringArray2);
                    continue;
                }
                hashMap.put(string, this.convertToCurrentCharset((String)v));
            }
            return Collections.unmodifiableMap(hashMap);
        }
    }

    public Enumeration getParameterNames() {
        if (this.m_pmap == null) {
            return Collections.enumeration(Collections.EMPTY_LIST);
        }
        return Collections.enumeration(this.m_pmap.keySet());
    }

    public void setCharacterEncoding(String string) throws UnsupportedEncodingException {
        super.setCharacterEncoding(string);
    }

    private LocaleSource getCurrentLocale(HttpServletRequest httpServletRequest) {
        LocaleSource localeSource = NonCachedUserInput.getInstance((HttpServletRequest)this);
        if (localeSource != null) {
            Object object = httpServletRequest.getSession().getAttribute("oracle.i18n.servlet.filter.cache");
            if (object == null) {
                return localeSource;
            }
            if ((class$oracle$i18n$servlet$localesource$UserInput == null ? (class$oracle$i18n$servlet$localesource$UserInput = ServletRequestWrapper.class$("oracle.i18n.servlet.localesource.UserInput")) : class$oracle$i18n$servlet$localesource$UserInput).equals(object.getClass())) {
                ((LocaleSource)object).setLocaleSource(localeSource);
            }
            return (LocaleSource)object;
        }
        localeSource = (LocaleSource)httpServletRequest.getSession().getAttribute("oracle.i18n.servlet.filter.cache");
        List list = this.m_appctx.getLocaleSourceList();
        List list2 = this.m_appctx.getLocaleSourceGetInstanceList();
        try {
            int n = 0;
            while (n < list.size()) {
                Object object;
                Method[] methodArray = ((Class)list.get(n)).getMethods();
                Object object2 = Boolean.TRUE;
                int n2 = 0;
                while (n2 < methodArray.length) {
                    object = methodArray[n2].getName();
                    if ("isAccessible".equals(object)) {
                        object2 = methodArray[n2].invoke(null, new Object[]{this});
                        break;
                    }
                    ++n2;
                }
                if (Boolean.TRUE.equals(object2)) {
                    if (localeSource == null || !list.get(n).equals(localeSource.getClass())) {
                        object = (Method)list2.get(n);
                        localeSource = (LocaleSource)((Method)object).invoke(null, new Object[]{this});
                        if (localeSource != null && localeSource.load()) {
                            return localeSource;
                        }
                    } else {
                        return localeSource;
                    }
                }
                ++n;
            }
        }
        catch (Exception exception) {}
        return this.m_appctx.getApplicationDefaultLocaleSource();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

