/*
 * Decompiled with CFR 0.152.
 */
package oracle.i18n.servlet;

import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import oracle.i18n.net.URLDecoder;
import oracle.i18n.net.URLEncoder;
import oracle.i18n.servlet.ApplicationContext;
import oracle.i18n.servlet.localesource.LocaleSource;
import oracle.i18n.servlet.localesource.Standalone;
import oracle.i18n.text.OraCollationKey;
import oracle.i18n.text.OraCollator;
import oracle.i18n.text.OraDateFormat;
import oracle.i18n.text.OraDecimalFormat;
import oracle.i18n.text.OraLanguage;
import oracle.i18n.text.OraNumberFormat;
import oracle.i18n.text.OraSimpleDateFormat;
import oracle.i18n.util.LocaleMapper;
import oracle.i18n.util.OraDisplayLocaleInfo;
import oracle.i18n.util.OraLocaleInfo;
import oracle.i18n.util.OraResourceBundle;
import oracle.i18n.util.OraSQLUtil;

public class Localizer {
    private static final transient Map m_commonIanaCharsetsMap = new HashMap();
    private final LocaleSource m_locsrc = new Standalone();
    private final OraLocaleInfo m_oralocaleinfo;
    private final ApplicationContext m_appctx;
    private final OraDisplayLocaleInfo m_odli;
    private final String m_pagecharset;

    public Localizer(Locale locale) {
        this(locale, null, null, null, null, null, null, null, null, null, null, null, null);
    }

    public Localizer(Locale locale, TimeZone timeZone, LocaleSource.WritingDirection writingDirection, OraDateFormat oraDateFormat, OraDateFormat oraDateFormat2, OraDateFormat oraDateFormat3, OraDateFormat oraDateFormat4, OraDateFormat oraDateFormat5, OraNumberFormat oraNumberFormat, OraNumberFormat oraNumberFormat2, OraCollator oraCollator, String string, String string2) {
        this(locale, timeZone, writingDirection, oraDateFormat, oraDateFormat2, oraDateFormat3, oraDateFormat4, oraDateFormat5, oraNumberFormat, oraNumberFormat2, oraCollator, string, string2, null);
    }

    public Localizer(Locale locale, TimeZone timeZone, LocaleSource.WritingDirection writingDirection, OraDateFormat oraDateFormat, OraDateFormat oraDateFormat2, OraDateFormat oraDateFormat3, OraDateFormat oraDateFormat4, OraDateFormat oraDateFormat5, OraNumberFormat oraNumberFormat, OraNumberFormat oraNumberFormat2, OraCollator oraCollator, String string, String string2, ApplicationContext applicationContext) {
        this.m_locsrc.setLocale(locale);
        this.m_oralocaleinfo = OraLocaleInfo.getInstance(locale);
        this.m_locsrc.setDefaultValues(this.m_oralocaleinfo, timeZone, writingDirection, oraDateFormat, oraDateFormat2, oraDateFormat3, oraDateFormat4, oraDateFormat5, oraNumberFormat, oraNumberFormat2, oraCollator, string, string2 != null ? LocaleMapper.getOraCharacterSet(2, string2) : null);
        this.m_appctx = applicationContext;
        this.m_odli = OraDisplayLocaleInfo.getInstance(this.getLocale());
        this.m_pagecharset = "UTF-8";
    }

    public Localizer(LocaleSource localeSource, ApplicationContext applicationContext, String string) {
        this.m_locsrc.setLocaleSource(localeSource);
        this.m_oralocaleinfo = OraLocaleInfo.getInstance(this.m_locsrc.getLocale());
        this.m_locsrc.setDefaultValues(this.m_oralocaleinfo);
        this.m_appctx = applicationContext;
        this.m_odli = OraDisplayLocaleInfo.getInstance(this.getLocale());
        this.m_pagecharset = this.m_appctx != null ? this.m_appctx.getIANAPageCharacterSet(localeSource.getLocale(), string) : "UTF-8";
    }

    public Locale getLocale() {
        return this.m_locsrc.getLocale();
    }

    public String getOraLanguage() {
        return this.m_oralocaleinfo.getLanguage();
    }

    public String getOraTerritory() {
        return this.m_oralocaleinfo.getTerritory();
    }

    public String getOraCharacterSet() {
        return this.m_locsrc.getCharacterSet();
    }

    public String getOraShortLanguage() {
        return this.m_oralocaleinfo.getOraLanguage().getISOAbbreviation();
    }

    public TimeZone getTimeZone() {
        return this.m_locsrc.getTimeZone();
    }

    public LocaleSource.WritingDirection getWritingDirection() {
        return this.m_locsrc.getWritingDirection();
    }

    public String getAlignment(LocaleSource.Alignment alignment) {
        if (this.m_locsrc.getWritingDirection() == LocaleSource.WritingDirection.RTL) {
            if (alignment == LocaleSource.Alignment.START) {
                return "right";
            }
            return "left";
        }
        if (alignment == LocaleSource.Alignment.START) {
            return "left";
        }
        return "right";
    }

    public String getISOCurrency() {
        return this.m_locsrc.getISOCurrency();
    }

    public String getIANACharacterSet() {
        return LocaleMapper.getIANACharacterSet(1, this.m_locsrc.getCharacterSet());
    }

    public String formatDate(Date date, int n) {
        int n2 = n == 2 ? 3 : (n == 0 ? 1 : n);
        return this.m_locsrc.getDateFormat(n2).format(date);
    }

    public Date parseDate(String string, int n) throws ParseException {
        int n2 = n == 2 ? 3 : (n == 0 ? 1 : n);
        return this.m_locsrc.getDateFormat(n2).parse(string);
    }

    public String getDatePattern(int n) {
        int n2 = n == 2 ? 3 : (n == 0 ? 1 : n);
        return ((OraSimpleDateFormat)this.m_locsrc.getDateFormat(n2)).toPattern();
    }

    public String formatTime(Date date) {
        return this.m_locsrc.getTimeFormat().format(date);
    }

    public Date parseTime(String string) throws ParseException {
        return this.m_locsrc.getTimeFormat().parse(string);
    }

    public String getTimePattern() {
        return ((OraSimpleDateFormat)this.m_locsrc.getTimeFormat()).toPattern();
    }

    public String formatDateTime(Date date, int n) {
        int n2 = n == 2 ? 3 : (n == 0 ? 1 : n);
        return this.m_locsrc.getDateTimeFormat(n2).format(date);
    }

    public Date parseDateTime(String string, int n) throws ParseException {
        int n2 = n == 2 ? 3 : (n == 0 ? 1 : n);
        return this.m_locsrc.getDateTimeFormat(n2).parse(string);
    }

    public String getDateTimePattern(int n) {
        int n2 = n == 2 ? 3 : (n == 0 ? 1 : n);
        return ((OraSimpleDateFormat)this.m_locsrc.getDateTimeFormat(n2)).toPattern();
    }

    public String formatNumber(Number number) {
        return this.m_locsrc.getNumberFormat().format(number);
    }

    public Number parseNumber(String string) throws ParseException {
        return this.m_locsrc.getNumberFormat().parse(string);
    }

    public String getNumberPattern() {
        return ((OraDecimalFormat)this.m_locsrc.getNumberFormat()).toPattern();
    }

    public String formatNumber(double d) {
        return this.m_locsrc.getNumberFormat().format(d);
    }

    public String formatNumber(long l) {
        return this.m_locsrc.getNumberFormat().format(l);
    }

    public String formatCurrency(Number number) {
        return this.m_locsrc.getCurrencyFormat().format(number);
    }

    public Number parseCurrency(String string) throws ParseException {
        return this.m_locsrc.getCurrencyFormat().parse(string);
    }

    public String getCurrencyPattern() {
        return ((OraDecimalFormat)this.m_locsrc.getCurrencyFormat()).toPattern();
    }

    public String formatCurrency(double d) {
        return this.m_locsrc.getCurrencyFormat().format(d);
    }

    public String formatCurrency(long l) {
        return this.m_locsrc.getCurrencyFormat().format(l);
    }

    public int compareString(String string, String string2) {
        return this.m_locsrc.getCollator().compare(string, string2);
    }

    public OraCollationKey getCollationKey(String string) {
        return this.m_locsrc.getCollator().getCollationKey(string);
    }

    public String getMessage(String string, Class clazz) {
        return OraResourceBundle.getBundle(clazz.getName(), this.getLocale(), clazz.getClassLoader()).getString(string);
    }

    public String getMessage(String string, String string2) {
        if (this.m_appctx == null) {
            return null;
        }
        return this.getMessage(string, (Class)this.m_appctx.getMessageBundle().get(string2));
    }

    public String getMessage(String string) {
        return this.getMessage(string, "default");
    }

    public String[] getLocalOraLanguages() {
        return this.m_oralocaleinfo.getOraTerritory().getLocalLanguages();
    }

    public String[] getLocalOraTerritories() {
        return this.m_oralocaleinfo.getOraLanguage().getLocalTerritories();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getLocalIANACharacterSets() {
        String[] stringArray;
        OraLanguage oraLanguage = this.m_oralocaleinfo.getOraLanguage();
        if (m_commonIanaCharsetsMap != null && (stringArray = (String[])m_commonIanaCharsetsMap.get(oraLanguage)) != null) {
            return stringArray;
        }
        stringArray = null;
        Map map = m_commonIanaCharsetsMap;
        synchronized (map) {
            stringArray = (String[])m_commonIanaCharsetsMap.get(oraLanguage);
            if (stringArray != null) {
                return stringArray;
            }
            String[] stringArray2 = oraLanguage.getLocalCharacterSets();
            stringArray = new String[stringArray2.length];
            int n = 0;
            while (n < stringArray2.length) {
                stringArray[n] = LocaleMapper.getIANACharacterSet(1, stringArray2[n]);
                ++n;
            }
            m_commonIanaCharsetsMap.put(oraLanguage, stringArray);
        }
        return stringArray;
    }

    public TimeZone[] getLocalTimeZones() {
        return this.m_oralocaleinfo.getLocalTimeZones();
    }

    public String[] getLocalLinguisticSorts() {
        return this.m_oralocaleinfo.getOraLanguage().getLocalLinguisticSorts();
    }

    public String getDisplayLocale(Locale locale) {
        return this.m_odli.getDisplayLocale(locale);
    }

    public String getDisplayLocale(String string, String string2) {
        return this.m_odli.getDisplayLocale(string, string2);
    }

    public String getDisplayLanguage(Locale locale) {
        return this.m_odli.getDisplayLanguage(locale);
    }

    public String getDisplayLanguage(String string) {
        return this.m_odli.getDisplayLanguage(string);
    }

    public String getDisplayCountry(Locale locale) {
        return this.m_odli.getDisplayCountry(locale);
    }

    public String getDisplayCountry(String string) {
        return this.m_odli.getDisplayCountry(string);
    }

    public String getDisplayTerritory(String string) {
        return this.m_odli.getDisplayTerritory(string);
    }

    public String getDisplayTimeZone(TimeZone timeZone) {
        return this.m_odli.getDisplayTimeZone(timeZone);
    }

    public String getDisplayLinguisticSort(String string) {
        return this.m_odli.getDisplayLinguisticSort(string);
    }

    public String getDisplayCharacterSet(String string) {
        return this.m_odli.getDisplayCharacterSet(string);
    }

    public String getDisplayCurrency(String string) {
        return this.m_odli.getDisplayCurrency(string);
    }

    public String encodeURL(String string) {
        try {
            return URLEncoder.encode(string, false, this.m_locsrc.getCharacterSet());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return string;
        }
    }

    public String decodeURL(String string) {
        try {
            return URLDecoder.decode(string, this.m_locsrc.getCharacterSet());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return string;
        }
    }

    public boolean synchronizeLocale(Connection connection) throws SQLException {
        return OraSQLUtil.synchronizeLocale(this.m_locsrc, connection);
    }

    public String getParameterName(LocaleSource.Parameter parameter) {
        return this.m_appctx.getParameterName(parameter);
    }

    public Locale[] getSupportedLocales() {
        return this.m_appctx.getSupportedLocales();
    }

    public String getIANAPageCharacterSet() {
        return this.m_pagecharset;
    }

    public String getIANAPageCharacterSet(Locale locale, String string) {
        return this.m_appctx.getIANAPageCharacterSet(locale, string);
    }

    public Class[] getLocaleSources() {
        return this.m_appctx.getLocaleSources();
    }

    public String[] getSupportedOraLanguages(String string) {
        return this.m_appctx.getSupportedOraLanguages(string);
    }

    public String[] getSupportedOraLanguages() {
        return this.m_appctx.getSupportedOraLanguages();
    }

    public String[] getSupportedOraTerritories(String string) {
        return this.m_appctx.getSupportedOraTerritories(string);
    }

    public String[] getSupportedOraTerritories() {
        return this.m_appctx.getSupportedOraTerritories();
    }

    public String[] getSupportedIANACharacterSets() {
        return this.m_appctx.getSupportedIANACharacterSets();
    }
}

