/*
 * Decompiled with CFR 0.152.
 */
package oracle.i18n.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TimeZone;
import oracle.i18n.servlet.GeneralHelper;
import oracle.i18n.servlet.localesource.ApplicationDefault;
import oracle.i18n.servlet.localesource.LocaleSource;
import oracle.i18n.util.GDKMessage;
import oracle.i18n.util.LocaleMapper;
import oracle.i18n.util.OraLocaleInfo;
import oracle.xml.parser.schema.XMLSchema;
import oracle.xml.parser.schema.XSDBuilder;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLParseException;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ApplicationContext {
    public static final String OBJECT_KEY = "oracle.i18n.servlet.ApplicationContext.contextkey";
    public static final String DEFAULT_GDKAPP = "/WEB-INF/gdkapp.xml";
    private static final String M_C_GDKAPP_XSD = "gdkapp.xsd";
    private static final String M_C_LOCALE_CHARSETS = "locale-charset-maps";
    private static final String M_C_PAGE_CHARSET = "page-charset";
    private static final String M_C_APPLICATION_LOCALE = "application-locales";
    private static final String M_C_LOCALE_DETERMINATION_RULE = "locale-determine-rule";
    private static final String M_C_REWRITE_RULE = "url-rewrite-rule";
    private static final String M_C_LOCALE_PARAMETER_NAME = "locale-parameter-name";
    private static final String M_C_USER_AGENT = "user-agent";
    private static final String M_C_PATTERN = "pattern";
    private static final String M_C_RESULT = "result";
    private static final String M_C_YES = "yes";
    private static final String M_C_MESSAGE_BUNDLES = "message-bundles";
    private static final String M_C_RESOURCE_BUNDLE = "resource-bundle";
    private static final String M_C_NAME = "name";
    private static final String M_C_FALLBACK = "fallback";
    static final String DEFAULT = "default";
    private static final String M_C_UTF_8 = "UTF-8";
    private static final String[] M_C_ZERO_STRING_ARRAY = new String[0];
    private static final TimeZone[] M_C_ZERO_TIMEZONE_ARRAY = new TimeZone[0];
    private static final RE M_C_REWRITE_PATTERN;
    private static final Object[] M_C_REWRITE_RESULT;
    private static final RE M_C_PARAMETER_NAME_PATTERN;
    private static final RE M_C_LOCALE_NAME_PATTERN;
    private static final Map m_paramStrToParameter;
    private int m_hashValue;
    private final ClassLoader m_cloader;
    private final LocaleSource m_appDefaultLocSrc;
    private String m_pageCharset = "UTF-8";
    private boolean m_pageCharsetForceSet = true;
    private Map m_localeCharsetMap = new HashMap();
    private Locale m_applicationDefaultLocale = new Locale("en", "US");
    private Locale[] m_applicationLocales = OraLocaleInfo.getCommonLocales();
    private Set m_applicationLocaleSet = new HashSet();
    private List m_localeDeterminationRuleList = new ArrayList(2);
    private List m_localeDeterminationRuleMethodList = new ArrayList(2);
    private Map m_messageBundleMap = new HashMap();
    private Map m_rewriteRuleMap = new HashMap();
    private final Object[] m_rewriteRule = new Object[]{M_C_REWRITE_PATTERN, M_C_REWRITE_RESULT, new Boolean(false)};
    private Map m_parameterNames = new HashMap(LocaleSource.Parameter.size());
    private String[] m_applicationOraLanguages = M_C_ZERO_STRING_ARRAY;
    private String[] m_applicationOraTerritories = M_C_ZERO_STRING_ARRAY;
    private Map m_applicationOraLanguagesForTerritory = new HashMap();
    private Map m_applicationOraTerritoriesForLanguage = new HashMap();
    private String[] m_applicationIANACharacterSets = M_C_ZERO_STRING_ARRAY;
    static /* synthetic */ Class class$oracle$i18n$servlet$localesource$ApplicationDefault;
    static /* synthetic */ Class class$oracle$i18n$servlet$localesource$UserInput;
    static /* synthetic */ Class class$oracle$i18n$servlet$localesource$HttpAcceptLanguage;
    static /* synthetic */ Class class$java$util$Locale;
    static /* synthetic */ Class class$java$util$List;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Class;
    static /* synthetic */ Class class$oracle$i18n$servlet$localesource$LocaleSource$Parameter;

    public ApplicationContext() throws ClassNotFoundException, RESyntaxException, UnsupportedEncodingException {
        this((String)null);
    }

    public ApplicationContext(String string, Map map, Locale locale, Locale[] localeArray, Class[] classArray, Map map2, Map map3, Map map4, ClassLoader classLoader) throws RESyntaxException, UnsupportedEncodingException {
        this.m_cloader = classLoader != null ? classLoader : this.getClass().getClassLoader();
        this.m_appDefaultLocSrc = ApplicationDefault.getInstance();
        this.initPresetValues();
        this.initPostsetValues(string, map, locale, localeArray, classArray, map2, map3, map4);
    }

    public ApplicationContext(String string) throws ClassNotFoundException, RESyntaxException, UnsupportedEncodingException {
        this(string, null);
    }

    public ApplicationContext(InputStream inputStream) throws ClassNotFoundException, RESyntaxException, UnsupportedEncodingException {
        this(inputStream, null);
    }

    public ApplicationContext(String string, ClassLoader classLoader) throws ClassNotFoundException, RESyntaxException, UnsupportedEncodingException {
        this.m_cloader = classLoader == null ? this.getClass().getClassLoader() : classLoader;
        this.m_appDefaultLocSrc = ApplicationDefault.getInstance();
        this.initPresetValues();
        if (string != null) {
            this.parseStoreOgsApp(string);
        }
        this.initPostsetValues(null, null, null, null, null, null, null, null);
    }

    public ApplicationContext(InputStream inputStream, ClassLoader classLoader) throws ClassNotFoundException, RESyntaxException, UnsupportedEncodingException {
        this.m_cloader = classLoader == null ? this.getClass().getClassLoader() : classLoader;
        this.m_appDefaultLocSrc = ApplicationDefault.getInstance();
        this.initPresetValues();
        if (inputStream != null) {
            this.parseStoreOgsApp(inputStream);
        }
        this.initPostsetValues(null, null, null, null, null, null, null, null);
    }

    public String getIANAPageCharacterSet() {
        return this.m_pageCharset;
    }

    public String getIANAPageCharacterSet(Locale locale, String string) {
        Object object;
        if (!this.m_pageCharset.equals("AUTO-CHARSET")) {
            return this.m_pageCharset;
        }
        Locale locale2 = this.fallbackLocale(locale);
        if (string == null) {
            return LocaleMapper.getIANACharSetFromLocale(6, locale2)[0];
        }
        List list = (List)this.m_localeCharsetMap.get(locale2);
        if (list == null) {
            object = null;
            if (!locale2.getVariant().equals("")) {
                object = new Locale(locale2.getLanguage(), locale2.getCountry());
                list = (List)this.m_localeCharsetMap.get(object);
            }
            if (list == null) {
                object = new Locale(locale.getLanguage(), "");
                list = (List)this.m_localeCharsetMap.get(object);
            }
        }
        if (list == null) {
            return LocaleMapper.getIANACharSetFromLocale(6, locale2)[0];
        }
        object = list.iterator();
        while (object.hasNext()) {
            Object[] objectArray = (Object[])object.next();
            if (!((RE)objectArray[0]).match(string)) continue;
            return (String)objectArray[1];
        }
        return LocaleMapper.getIANACharSetFromLocale(7, locale2)[0];
    }

    public String getParameterName(LocaleSource.Parameter parameter) {
        return (String)this.m_parameterNames.get(parameter);
    }

    public Class[] getLocaleSources() {
        return this.m_localeDeterminationRuleList.toArray(new Class[0]);
    }

    public List getLocaleSourceList() {
        return this.m_localeDeterminationRuleList;
    }

    public List getLocaleSourceGetInstanceList() {
        return this.m_localeDeterminationRuleMethodList;
    }

    public LocaleSource getApplicationDefaultLocaleSource() {
        return this.m_appDefaultLocSrc;
    }

    public Map getMessageBundle() {
        return this.m_messageBundleMap;
    }

    public Locale[] getSupportedLocales() {
        return this.m_applicationLocales;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getSupportedOraLanguages(String string) {
        if (string == null) {
            return this.getSupportedOraLanguages();
        }
        String string2 = string.toUpperCase(Locale.US);
        String[] stringArray = (String[])this.m_applicationOraLanguagesForTerritory.get(string2);
        if (stringArray != null) {
            return stringArray;
        }
        Map map = this.m_applicationOraLanguagesForTerritory;
        synchronized (map) {
            ArrayList<String> arrayList = new ArrayList<String>();
            int n = 0;
            while (n < this.m_applicationLocales.length) {
                String string3 = LocaleMapper.getOraLanguage(this.m_applicationLocales[n]);
                String string4 = LocaleMapper.getOraTerritory(this.m_applicationLocales[n]);
                if (string3 != null && string2.equals(string4) && !arrayList.contains(string3)) {
                    arrayList.add(string3);
                }
                ++n;
            }
            stringArray = arrayList.toArray(new String[0]);
            this.m_applicationOraLanguagesForTerritory.put(string2, stringArray);
        }
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getSupportedOraLanguages() {
        if (this.m_applicationOraLanguages.length > 0) {
            return this.m_applicationOraLanguages;
        }
        String[] stringArray = this.m_applicationOraLanguages;
        synchronized (this.m_applicationOraLanguages) {
            if (this.m_applicationOraLanguages.length == 0) {
                ArrayList<String> arrayList = new ArrayList<String>();
                int n = 0;
                while (n < this.m_applicationLocales.length) {
                    String string = LocaleMapper.getOraLanguage(this.m_applicationLocales[n]);
                    if (string != null && !arrayList.contains(string)) {
                        arrayList.add(string);
                    }
                    ++n;
                }
                this.m_applicationOraLanguages = arrayList.toArray(new String[0]);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.m_applicationOraLanguages;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getSupportedOraTerritories(String string) {
        if (string == null) {
            return this.getSupportedOraTerritories();
        }
        String string2 = string.toUpperCase(Locale.US);
        String[] stringArray = (String[])this.m_applicationOraTerritoriesForLanguage.get(string2);
        if (stringArray != null) {
            return stringArray;
        }
        Map map = this.m_applicationOraTerritoriesForLanguage;
        synchronized (map) {
            ArrayList<String> arrayList = new ArrayList<String>();
            int n = 0;
            while (n < this.m_applicationLocales.length) {
                String string3 = LocaleMapper.getOraTerritory(this.m_applicationLocales[n]);
                String string4 = LocaleMapper.getOraLanguage(this.m_applicationLocales[n]);
                if (string3 != null && string2.equals(string4) && !arrayList.contains(string3)) {
                    arrayList.add(string3);
                }
                ++n;
            }
            stringArray = arrayList.toArray(new String[0]);
            this.m_applicationOraTerritoriesForLanguage.put(string2, stringArray);
        }
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getSupportedOraTerritories() {
        if (this.m_applicationOraTerritories.length > 0) {
            return this.m_applicationOraTerritories;
        }
        String[] stringArray = this.m_applicationOraTerritories;
        synchronized (this.m_applicationOraTerritories) {
            if (this.m_applicationOraTerritories.length == 0) {
                ArrayList<String> arrayList = new ArrayList<String>();
                int n = 0;
                while (n < this.m_applicationLocales.length) {
                    String string = LocaleMapper.getOraTerritory(this.m_applicationLocales[n]);
                    if (string != null && !arrayList.contains(string)) {
                        arrayList.add(string);
                    }
                    ++n;
                }
                this.m_applicationOraTerritories = arrayList.toArray(new String[0]);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.m_applicationOraTerritories;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getSupportedIANACharacterSets() {
        if (this.m_applicationIANACharacterSets.length > 0) {
            return this.m_applicationIANACharacterSets;
        }
        String[] stringArray = this.m_applicationIANACharacterSets;
        synchronized (this.m_applicationIANACharacterSets) {
            if (this.m_applicationIANACharacterSets.length == 0) {
                ArrayList<String> arrayList = new ArrayList<String>();
                int n = 0;
                while (n < this.m_applicationLocales.length) {
                    String[] stringArray2 = LocaleMapper.getIANACharSetFromLocale(7, this.m_applicationLocales[n]);
                    int n2 = 0;
                    while (n2 < stringArray2.length) {
                        if (!arrayList.contains(stringArray2[n2])) {
                            arrayList.add(stringArray2[n2]);
                        }
                        ++n2;
                    }
                    String[] stringArray3 = LocaleMapper.getIANACharSetFromLocale(6, this.m_applicationLocales[n]);
                    int n3 = 0;
                    while (n3 < stringArray3.length) {
                        if (!arrayList.contains(stringArray3[n3])) {
                            arrayList.add(stringArray3[n3]);
                        }
                        ++n3;
                    }
                    ++n;
                }
                this.m_applicationIANACharacterSets = arrayList.toArray(new String[0]);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.m_applicationIANACharacterSets;
        }
    }

    public ClassLoader getClassLoader() {
        return this.m_cloader;
    }

    public Locale fallbackLocale(Locale locale) {
        if (this.m_applicationLocaleSet.contains(locale)) {
            return locale;
        }
        Locale locale2 = null;
        if (!locale.getVariant().equals("") && this.m_applicationLocaleSet.contains(locale2 = new Locale(locale.getLanguage(), locale.getCountry()))) {
            return locale2;
        }
        locale2 = new Locale(locale.getLanguage(), "");
        return this.m_applicationLocaleSet.contains(locale2) ? locale2 : this.m_applicationDefaultLocale;
    }

    public boolean isIANAPageCharacterSetForcedSet() {
        return this.m_pageCharsetForceSet;
    }

    public Class getLocaleSource(String string) {
        Class clazz = null;
        int n = 0;
        while (n < this.m_localeDeterminationRuleList.size()) {
            clazz = (Class)this.m_localeDeterminationRuleList.get(n);
            if (clazz.getName().equals(string)) {
                return clazz;
            }
            ++n;
        }
        return class$oracle$i18n$servlet$localesource$ApplicationDefault == null ? (class$oracle$i18n$servlet$localesource$ApplicationDefault = ApplicationContext.class$("oracle.i18n.servlet.localesource.ApplicationDefault")) : class$oracle$i18n$servlet$localesource$ApplicationDefault;
    }

    public int hashCode() {
        return this.m_hashValue;
    }

    Object[] getRewritingRule(String string) {
        return (Object[])this.m_rewriteRuleMap.get(string);
    }

    Object[] getRewritingRule() {
        return this.getRewritingRule(DEFAULT);
    }

    static RewriteURLVariable[] parseOutputPatternRewriteURL(String string) {
        ArrayList<RewriteURLVariable> arrayList = new ArrayList<RewriteURLVariable>();
        char[] cArray = string.toCharArray();
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < cArray.length) {
            if (cArray[n] == '$' && n + 1 < cArray.length) {
                RewriteURLVariable rewriteURLVariable;
                if ((rewriteURLVariable = RewriteURLVariable.getInstance(cArray[++n])) != null) {
                    if (stringBuffer.length() > 0) {
                        arrayList.add(RewriteURLVariable.getInstance(stringBuffer.toString()));
                        stringBuffer = new StringBuffer();
                    }
                    arrayList.add(rewriteURLVariable);
                } else {
                    stringBuffer.append('$');
                    stringBuffer.append(cArray[n]);
                }
            } else {
                stringBuffer.append(cArray[n]);
            }
            ++n;
        }
        if (stringBuffer.length() > 0) {
            arrayList.add(RewriteURLVariable.getInstance(stringBuffer.toString()));
        }
        return arrayList.toArray(new RewriteURLVariable[0]);
    }

    private void initPresetValues() {
        LocaleSource.resetParameterVariables(this.m_parameterNames);
        this.m_localeDeterminationRuleList.add(class$oracle$i18n$servlet$localesource$UserInput == null ? (class$oracle$i18n$servlet$localesource$UserInput = ApplicationContext.class$("oracle.i18n.servlet.localesource.UserInput")) : class$oracle$i18n$servlet$localesource$UserInput);
        this.m_localeDeterminationRuleList.add(class$oracle$i18n$servlet$localesource$HttpAcceptLanguage == null ? (class$oracle$i18n$servlet$localesource$HttpAcceptLanguage = ApplicationContext.class$("oracle.i18n.servlet.localesource.HttpAcceptLanguage")) : class$oracle$i18n$servlet$localesource$HttpAcceptLanguage);
        try {
            this.m_localeDeterminationRuleMethodList.add((class$oracle$i18n$servlet$localesource$UserInput == null ? (class$oracle$i18n$servlet$localesource$UserInput = ApplicationContext.class$("oracle.i18n.servlet.localesource.UserInput")) : class$oracle$i18n$servlet$localesource$UserInput).getMethod("getInstance", GeneralHelper.ARG_HTTP_SERVLET_REQUEST_CLASS));
            this.m_localeDeterminationRuleMethodList.add((class$oracle$i18n$servlet$localesource$HttpAcceptLanguage == null ? (class$oracle$i18n$servlet$localesource$HttpAcceptLanguage = ApplicationContext.class$("oracle.i18n.servlet.localesource.HttpAcceptLanguage")) : class$oracle$i18n$servlet$localesource$HttpAcceptLanguage).getMethod("getInstance", GeneralHelper.ARG_HTTP_SERVLET_REQUEST_CLASS));
            this.m_localeDeterminationRuleMethodList = Collections.unmodifiableList(this.m_localeDeterminationRuleMethodList);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.getMessage());
        }
        this.m_rewriteRuleMap.put(DEFAULT, this.m_rewriteRule);
    }

    private void initPostsetValues(String string, Map map, Locale locale, Locale[] localeArray, Class[] classArray, Map map2, Map map3, Map map4) throws RESyntaxException, UnsupportedEncodingException {
        Object[] objectArray;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        if (string != null) {
            this.m_pageCharset = GeneralHelper.getIANACharacterSetFromCs(string);
        }
        if (map != null) {
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                object4 = iterator.next();
                if (!(object4 instanceof Locale)) {
                    object3 = GDKMessage.getMessage(5207, (Object)(class$java$util$Locale == null ? (class$java$util$Locale = ApplicationContext.class$("java.util.Locale")) : class$java$util$Locale).getName());
                    throw new IllegalArgumentException((String)object3);
                }
                object3 = map.get(object4);
                if (!(object3 instanceof List)) {
                    throw new IllegalArgumentException(GDKMessage.getMessage(5208, (Object)(class$java$util$List == null ? (class$java$util$List = ApplicationContext.class$("java.util.List")) : class$java$util$List).getName()));
                }
                object2 = (List)object3;
                object = object2.iterator();
                while (object.hasNext()) {
                    objectArray = (Object[])object.next();
                    if (!(objectArray[0] instanceof RE)) {
                        throw new IllegalArgumentException(GDKMessage.getMessage(5209));
                    }
                    if (!(objectArray[1] instanceof String)) {
                        throw new IllegalArgumentException(GDKMessage.getMessage(5210));
                    }
                    objectArray[1] = GeneralHelper.getIANACharacterSetFromCs((String)objectArray[1]);
                }
            }
            this.m_localeCharsetMap = map;
        }
        if (locale != null) {
            this.m_applicationDefaultLocale = locale;
        }
        if (localeArray != null) {
            this.m_applicationLocales = localeArray;
        }
        int n = 0;
        while (n < this.m_applicationLocales.length) {
            this.m_applicationLocaleSet.add(this.m_applicationLocales[n]);
            ++n;
        }
        if (!this.m_applicationLocaleSet.contains(this.m_applicationDefaultLocale)) {
            throw new IllegalArgumentException(GDKMessage.getMessage(5211));
        }
        if (classArray != null) {
            this.m_localeDeterminationRuleList = new ArrayList();
            this.m_localeDeterminationRuleMethodList = new ArrayList();
            int n2 = 0;
            while (n2 < classArray.length) {
                object3 = classArray[n2];
                try {
                    object2 = ((Class)object3).getMethod("getInstance", GeneralHelper.ARG_HTTP_SERVLET_REQUEST_CLASS);
                    this.m_localeDeterminationRuleMethodList.add(object2);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    throw new RuntimeException(noSuchMethodException.getMessage());
                }
                this.m_localeDeterminationRuleList.add(object3);
                ++n2;
            }
            this.m_localeDeterminationRuleMethodList = Collections.unmodifiableList(this.m_localeDeterminationRuleMethodList);
            this.m_localeDeterminationRuleList = Collections.unmodifiableList(this.m_localeDeterminationRuleList);
        }
        if (map4 != null) {
            object4 = map4.keySet().iterator();
            while (object4.hasNext()) {
                object3 = object4.next();
                if (!(object3 instanceof String)) {
                    object2 = GDKMessage.getMessage(5222, (Object)(class$java$lang$String == null ? (class$java$lang$String = ApplicationContext.class$("java.lang.String")) : class$java$lang$String).getName());
                    throw new IllegalArgumentException((String)object2);
                }
                object2 = map4.get(object3);
                if (object2 instanceof Class) continue;
                object = GDKMessage.getMessage(5223, (Object)(class$java$lang$Class == null ? (class$java$lang$Class = ApplicationContext.class$("java.lang.Class")) : class$java$lang$Class).getName());
                throw new IllegalArgumentException((String)object);
            }
            this.m_messageBundleMap = map4;
        }
        if (map2 != null) {
            object4 = map2.keySet().iterator();
            while (object4.hasNext()) {
                object3 = (String)object4.next();
                object2 = map2.get(object3);
                if (object3 == null) {
                    object3 = DEFAULT;
                }
                if (!object2.getClass().isArray()) {
                    throw new IllegalArgumentException(GDKMessage.getMessage(5212));
                }
                object = (Object[])object2;
                if (((Object[])object).length != 3) {
                    throw new IllegalArgumentException(GDKMessage.getMessage(5212));
                }
                objectArray = new Object[]{new RE((String)object[0]), ApplicationContext.parseOutputPatternRewriteURL((String)object[1]), Boolean.valueOf((String)object[2])};
                this.m_rewriteRuleMap.put(object3, objectArray);
            }
            boolean bl = false;
            object2 = this.m_rewriteRuleMap.keySet().iterator();
            while (object2.hasNext()) {
                object = (String)object2.next();
                if (!DEFAULT.equals(object)) continue;
                bl = true;
                break;
            }
            if (!bl) {
                throw new IllegalArgumentException(GDKMessage.getMessage(5212));
            }
        }
        if (map3 != null) {
            object4 = map3.keySet().iterator();
            while (object4.hasNext()) {
                Object e = object4.next();
                if (!(e instanceof LocaleSource.Parameter)) {
                    throw new IllegalArgumentException(GDKMessage.getMessage(5213, (Object)(class$oracle$i18n$servlet$localesource$LocaleSource$Parameter == null ? (class$oracle$i18n$servlet$localesource$LocaleSource$Parameter = ApplicationContext.class$("oracle.i18n.servlet.localesource.LocaleSource$Parameter")) : class$oracle$i18n$servlet$localesource$LocaleSource$Parameter).getName()));
                }
                object2 = map3.get(e);
                if (!(object2 instanceof String)) {
                    throw new IllegalArgumentException(GDKMessage.getMessage(5214, (Object)(class$java$lang$String == null ? (class$java$lang$String = ApplicationContext.class$("java.lang.String")) : class$java$lang$String).getName()));
                }
                if (!M_C_PARAMETER_NAME_PATTERN.match((String)object2)) {
                    throw new IllegalArgumentException(GDKMessage.getMessage(5215));
                }
                this.m_parameterNames.put(e, object2);
            }
        }
        this.m_appDefaultLocSrc.setLocale(this.m_applicationDefaultLocale);
        int n3 = 37;
        n3 = n3 * 37 + this.m_cloader.hashCode();
        n3 = n3 * 37 + this.m_appDefaultLocSrc.hashCode();
        n3 = n3 * 37 + this.m_pageCharset.hashCode();
        n3 = n3 * 37 + (this.m_pageCharsetForceSet ? 1 : 0);
        n3 = n3 * 37 + this.m_applicationDefaultLocale.hashCode();
        n3 = n3 * 37 + this.m_applicationLocaleSet.hashCode();
        n3 = n3 * 37 + this.m_localeDeterminationRuleList.hashCode();
        n3 = n3 * 37 + this.m_messageBundleMap.hashCode();
        this.m_hashValue = n3 = n3 * 37 + this.m_parameterNames.hashCode();
    }

    private void parseStoreOgsApp(Object object) throws ClassNotFoundException, RESyntaxException, UnsupportedEncodingException {
        XMLDocument xMLDocument = null;
        InputStream inputStream = this.getClass().getResourceAsStream(M_C_GDKAPP_XSD);
        XSDBuilder xSDBuilder = null;
        XMLSchema xMLSchema = null;
        try {
            xSDBuilder = new XSDBuilder();
            xMLSchema = (XMLSchema)xSDBuilder.build(inputStream, null);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(exception.getMessage());
        }
        DOMParser dOMParser = new DOMParser();
        dOMParser.setXMLSchema((Object)xMLSchema);
        dOMParser.setValidationMode(3);
        try {
            if (object instanceof String) {
                dOMParser.parse(GeneralHelper.createURL((String)object));
            } else {
                dOMParser.parse((InputStream)object);
            }
            xMLDocument = dOMParser.getDocument();
        }
        catch (XMLParseException xMLParseException) {
            throw new IllegalArgumentException(xMLParseException.getMessage());
        }
        catch (SAXException sAXException) {
            throw new IllegalArgumentException(sAXException.getMessage());
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException(iOException.getMessage());
        }
        Element element = xMLDocument.getDocumentElement();
        NodeList nodeList = element.getChildNodes();
        int n = 0;
        int n2 = nodeList.getLength();
        while (n < n2) {
            int n3;
            Object object2;
            Object object3;
            NodeList nodeList2;
            Node node = nodeList.item(n);
            String string = node.getNodeName();
            if (string.equals(M_C_LOCALE_CHARSETS)) {
                nodeList2 = node.getChildNodes();
                int n4 = 0;
                int n5 = nodeList2.getLength();
                while (n4 < n5) {
                    Object object4;
                    node = nodeList2.item(n4);
                    object3 = node.getChildNodes();
                    object2 = null;
                    String string2 = ".*";
                    String string3 = null;
                    int n6 = 0;
                    n3 = object3.getLength();
                    while (n6 < n3) {
                        node = object3.item(n6);
                        object4 = node.getNodeName();
                        if (((String)object4).equals("locale")) {
                            object2 = node.getFirstChild().getNodeValue().toLowerCase(Locale.US);
                        } else if (((String)object4).equals(M_C_USER_AGENT)) {
                            string2 = node.getFirstChild().getNodeValue();
                        } else if (((String)object4).equals("charset")) {
                            string3 = GeneralHelper.getIANACharacterSetFromCs(node.getFirstChild().getNodeValue());
                        }
                        ++n6;
                    }
                    if (object2 != null) {
                        object4 = new RE(string2);
                        StringTokenizer stringTokenizer = new StringTokenizer((String)object2, ",");
                        while (stringTokenizer.hasMoreTokens()) {
                            Locale locale = OraLocaleInfo.getLocaleFromString(stringTokenizer.nextToken());
                            ArrayList<Object[]> arrayList = (ArrayList<Object[]>)this.m_localeCharsetMap.get(locale);
                            if (arrayList == null) {
                                arrayList = new ArrayList<Object[]>(1);
                                this.m_localeCharsetMap.put(locale, arrayList);
                            }
                            arrayList.add(new Object[]{object4, string3});
                        }
                    }
                    ++n4;
                }
            } else if (string.equals(M_C_PAGE_CHARSET)) {
                this.m_pageCharset = GeneralHelper.getIANACharacterSetFromCs(node.getChildNodes().item(0).getNodeValue());
                if (node.hasAttributes() && !node.getAttributes().item(0).getNodeValue().equals(M_C_YES)) {
                    this.m_pageCharsetForceSet = false;
                }
            } else if (string.equals(M_C_APPLICATION_LOCALE)) {
                nodeList2 = node.getChildNodes();
                ArrayList<Locale> arrayList = new ArrayList<Locale>();
                int n7 = 0;
                int n8 = nodeList2.getLength();
                while (n7 < n8) {
                    node = nodeList2.item(n7);
                    if (node.getNodeName().equals("locale")) {
                        object2 = node.getFirstChild().getNodeValue();
                        if (!M_C_LOCALE_NAME_PATTERN.match((String)object2)) {
                            throw new IllegalArgumentException(GDKMessage.getMessage(5224, object2));
                        }
                        Locale[] localeArray = OraLocaleInfo.getLocalesFromString((String)object2);
                        if (node.hasAttributes() && node.getAttributes().item(0).getNodeValue().equals(M_C_YES) && localeArray.length == 1) {
                            this.m_applicationDefaultLocale = localeArray[0];
                        }
                        int n9 = 0;
                        while (n9 < localeArray.length) {
                            this.m_applicationLocaleSet.add(localeArray[n9]);
                            arrayList.add(localeArray[n9]);
                            ++n9;
                        }
                    }
                    ++n7;
                }
                this.m_applicationLocales = arrayList.toArray(new Locale[0]);
            } else if (string.equals(M_C_LOCALE_DETERMINATION_RULE)) {
                this.m_localeDeterminationRuleList = new ArrayList();
                this.m_localeDeterminationRuleMethodList = new ArrayList();
                nodeList2 = node.getChildNodes();
                int n10 = 0;
                int n11 = nodeList2.getLength();
                while (n10 < n11) {
                    node = nodeList2.item(n10);
                    if (node.getNodeName().equals("locale-source")) {
                        object3 = Class.forName(node.getFirstChild().getNodeValue(), true, this.m_cloader);
                        try {
                            object2 = ((Class)object3).getMethod("getInstance", GeneralHelper.ARG_HTTP_SERVLET_REQUEST_CLASS);
                            this.m_localeDeterminationRuleMethodList.add(object2);
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                            throw new RuntimeException(noSuchMethodException.getMessage());
                        }
                        this.m_localeDeterminationRuleList.add(object3);
                    }
                    ++n10;
                }
                this.m_localeDeterminationRuleList = Collections.unmodifiableList(this.m_localeDeterminationRuleList);
                this.m_localeDeterminationRuleMethodList = Collections.unmodifiableList(this.m_localeDeterminationRuleMethodList);
            } else if (string.equals(M_C_LOCALE_PARAMETER_NAME)) {
                nodeList2 = node.getChildNodes();
                String string4 = null;
                int n12 = 0;
                int n13 = nodeList2.getLength();
                while (n12 < n13) {
                    node = nodeList2.item(n12);
                    string4 = node.getNodeName();
                    object2 = (LocaleSource.Parameter)m_paramStrToParameter.get(string4);
                    if (object2 != null) {
                        String string5 = node.getFirstChild().getNodeValue();
                        if (!M_C_PARAMETER_NAME_PATTERN.match(string5)) {
                            throw new IllegalArgumentException(GDKMessage.getMessage(5221, (Object)string5));
                        }
                        this.m_parameterNames.put(object2, string5);
                    }
                    ++n12;
                }
            } else if (string.equals(M_C_REWRITE_RULE)) {
                nodeList2 = node.getChildNodes();
                String string6 = null;
                Boolean bl = null;
                object3 = null;
                object2 = null;
                Object[] objectArray = new Object[3];
                NamedNodeMap namedNodeMap = node.getAttributes();
                int n14 = 0;
                n3 = namedNodeMap.getLength();
                while (n14 < n3) {
                    node = namedNodeMap.item(n14);
                    if (node.getNodeName().equals(M_C_NAME)) {
                        string6 = node.getNodeValue();
                    } else if (node.getNodeName().equals(M_C_FALLBACK)) {
                        bl = new Boolean(M_C_YES.equals(node.getNodeValue()));
                    }
                    ++n14;
                }
                if (string6 == null) {
                    string6 = DEFAULT;
                }
                if (bl == null) {
                    bl = new Boolean(false);
                }
                int n15 = 0;
                int n16 = nodeList2.getLength();
                while (n15 < n16) {
                    node = nodeList2.item(n15);
                    if (node.getNodeName().equals(M_C_PATTERN)) {
                        object3 = node.getFirstChild().getNodeValue();
                    } else if (node.getNodeName().equals(M_C_RESULT)) {
                        object2 = node.getFirstChild().getNodeValue();
                    }
                    ++n15;
                }
                objectArray[0] = new RE((String)object3);
                objectArray[1] = ApplicationContext.parseOutputPatternRewriteURL((String)object2);
                objectArray[2] = bl;
                this.m_rewriteRuleMap.put(string6, objectArray);
            } else if (string.equals(M_C_MESSAGE_BUNDLES)) {
                this.m_messageBundleMap.clear();
                nodeList2 = node.getChildNodes();
                int n17 = 0;
                int n18 = nodeList2.getLength();
                while (n17 < n18) {
                    node = nodeList2.item(n17);
                    if (node.getNodeName().equals(M_C_RESOURCE_BUNDLE)) {
                        object3 = null;
                        object2 = node.getAttributes();
                        int n19 = 0;
                        int n20 = object2.getLength();
                        while (n19 < n20) {
                            Node node2 = object2.item(n19);
                            if (node2.getNodeName().equals(M_C_NAME)) {
                                object3 = node2.getNodeValue();
                            }
                            ++n19;
                        }
                        if (object3 == null) {
                            object3 = DEFAULT;
                        }
                        this.m_messageBundleMap.put(object3, Class.forName(node.getFirstChild().getNodeValue(), true, this.m_cloader));
                    }
                    ++n17;
                }
            }
            ++n;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        try {
            M_C_REWRITE_PATTERN = new RE("(.*)/([^/]+)$");
            M_C_PARAMETER_NAME_PATTERN = new RE("^[a-z][-a-z0-9]*$");
            M_C_LOCALE_NAME_PATTERN = new RE("^(([a-zA-Z]+|\\*)([-_]([a-zA-Z]+|\\*)([-_][a-zA-Z0-9]+)?)?|\\*)$");
        }
        catch (RESyntaxException rESyntaxException) {
            throw new IllegalArgumentException(rESyntaxException.getMessage());
        }
        M_C_REWRITE_RESULT = ApplicationContext.parseOutputPatternRewriteURL("/$L/$1/$2");
        m_paramStrToParameter = new HashMap(LocaleSource.Parameter.size());
        m_paramStrToParameter.put("locale", LocaleSource.Parameter.LOCALE);
        m_paramStrToParameter.put("language", LocaleSource.Parameter.LANGUAGE);
        m_paramStrToParameter.put("territory", LocaleSource.Parameter.TERRITORY);
        m_paramStrToParameter.put("charset", LocaleSource.Parameter.CHARSET);
        m_paramStrToParameter.put("timezone", LocaleSource.Parameter.TIMEZONE);
        m_paramStrToParameter.put("iso-currency", LocaleSource.Parameter.ISO_CURRENCY);
        m_paramStrToParameter.put("linguistic-sort", LocaleSource.Parameter.LINGUISTIC_SORT);
        m_paramStrToParameter.put("date-format", LocaleSource.Parameter.DATE_FORMAT);
        m_paramStrToParameter.put("long-date-format", LocaleSource.Parameter.LONG_DATE_FORMAT);
        m_paramStrToParameter.put("time-format", LocaleSource.Parameter.TIME_FORMAT);
        m_paramStrToParameter.put("date-time-format", LocaleSource.Parameter.DATE_TIME_FORMAT);
        m_paramStrToParameter.put("long-date-time-format", LocaleSource.Parameter.LONG_DATE_TIME_FORMAT);
        m_paramStrToParameter.put("number-format", LocaleSource.Parameter.NUMBER_FORMAT);
        m_paramStrToParameter.put("currency-format", LocaleSource.Parameter.CURRENCY_FORMAT);
        m_paramStrToParameter.put("writing-direction", LocaleSource.Parameter.WRITING_DIRECTION);
        m_paramStrToParameter.put("command", LocaleSource.Parameter.COMMAND);
        m_paramStrToParameter.put("locale-source", LocaleSource.Parameter.LOCALE_SOURCE);
    }

    static abstract class RewriteURLVariable {
        private static final Character M_C_STAR = new Character('*');
        private static final Map m_nameToObj = new HashMap(16);
        public static final RewriteURLVariable LOCALE = new RewriteURLVariable('A'){

            public String getResult(RE rE, Locale locale) {
                return locale.toString();
            }
        };
        public static final RewriteURLVariable LANGUAGE = new RewriteURLVariable('L'){

            public String getResult(RE rE, Locale locale) {
                return locale.getLanguage();
            }
        };
        public static final RewriteURLVariable COUNTRY = new RewriteURLVariable('C'){

            public String getResult(RE rE, Locale locale) {
                return locale.getCountry();
            }
        };
        public static final RewriteURLVariable VARIANT = new RewriteURLVariable('V'){

            public String getResult(RE rE, Locale locale) {
                return locale.getVariant();
            }
        };
        public static final RewriteURLVariable ZERO = new RewriteURLVariable('0'){

            public String getResult(RE rE, Locale locale) {
                return rE.getParen(0);
            }
        };
        public static final RewriteURLVariable ONE = new RewriteURLVariable('1'){

            public String getResult(RE rE, Locale locale) {
                return rE.getParen(1);
            }
        };
        public static final RewriteURLVariable TWO = new RewriteURLVariable('2'){

            public String getResult(RE rE, Locale locale) {
                return rE.getParen(2);
            }
        };
        public static final RewriteURLVariable THREE = new RewriteURLVariable('3'){

            public String getResult(RE rE, Locale locale) {
                return rE.getParen(3);
            }
        };
        public static final RewriteURLVariable FOUR = new RewriteURLVariable('4'){

            public String getResult(RE rE, Locale locale) {
                return rE.getParen(4);
            }
        };
        public static final RewriteURLVariable FIVE = new RewriteURLVariable('5'){

            public String getResult(RE rE, Locale locale) {
                return rE.getParen(5);
            }
        };
        public static final RewriteURLVariable SIX = new RewriteURLVariable('6'){

            public String getResult(RE rE, Locale locale) {
                return rE.getParen(6);
            }
        };
        public static final RewriteURLVariable SEVEN = new RewriteURLVariable('7'){

            public String getResult(RE rE, Locale locale) {
                return rE.getParen(7);
            }
        };
        public static final RewriteURLVariable EIGHT = new RewriteURLVariable('8'){

            public String getResult(RE rE, Locale locale) {
                return rE.getParen(8);
            }
        };
        public static final RewriteURLVariable NINE = new RewriteURLVariable('9'){

            public String getResult(RE rE, Locale locale) {
                return rE.getParen(9);
            }
        };
        public static final RewriteURLVariable DOLLER = new RewriteURLVariable('$'){

            public String getResult(RE rE, Locale locale) {
                return "$";
            }
        };
        private final Character m_name;
        private final String m_data;

        public RewriteURLVariable(char c) {
            this.m_name = new Character(c);
            this.m_data = null;
            m_nameToObj.put(this.m_name, this);
        }

        public RewriteURLVariable(String string) {
            this.m_name = M_C_STAR;
            this.m_data = string;
        }

        public final String getData() {
            return this.m_data;
        }

        public abstract String getResult(RE var1, Locale var2);

        public static final RewriteURLVariable getInstance(char c) {
            return (RewriteURLVariable)m_nameToObj.get(new Character(c));
        }

        public static final RewriteURLVariable getInstance(String string) {
            return new RewriteURLVariable(string){

                public String getResult(RE rE, Locale locale) {
                    return this.getData();
                }
            };
        }
    }
}

