/*
 * Decompiled with CFR 0.152.
 */
package oracle.i18n.net;

import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import oracle.i18n.text.OraMapTable;
import oracle.i18n.util.GDKMessage;
import oracle.i18n.util.LocaleMapper;
import oracle.i18n.util.OraSQLUtil;

public class CharEntityReference {
    private static final Map charEntity = OraMapTable.getInstance(6).getHashMapAttribute("CHAR_ENTITY_REFERENCE");
    private static final Map resCharEntities = new HashMap(5);

    private CharEntityReference() {
    }

    public static String escape(String string) {
        try {
            return CharEntityReference.escape(string, "WE8ISO8859P1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalStateException(GDKMessage.getMessage(5200));
        }
    }

    public static String escape(String string, String string2) throws UnsupportedEncodingException {
        return CharEntityReference.escape(string, string2, Form.NAMED_DECIMAL_NUMBER);
    }

    public static String escape(String string, String string2, Form form) throws UnsupportedEncodingException {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        String string3 = string2;
        String string4 = LocaleMapper.getOraCharacterSet(2, string2);
        if (string4 != null) {
            string3 = string4;
        }
        char c = '\u0000';
        Character c2 = null;
        String string5 = null;
        int n2 = 0;
        while (n2 < n) {
            c = string.charAt(n2);
            c2 = new Character(c);
            string5 = (String)resCharEntities.get(c2);
            if (string5 == null) {
                if (OraSQLUtil.isValidIdentifier(c2.toString(), string3)) {
                    stringBuffer.append(c);
                } else if (form == Form.NAMED_DECIMAL_NUMBER || form == Form.DECIMAL_NUMBER) {
                    stringBuffer.append("&#" + Integer.toString(c) + ";");
                } else {
                    stringBuffer.append("&#x" + Integer.toHexString(c) + ";");
                }
            } else if (form == Form.NAMED || form == Form.NAMED_DECIMAL_NUMBER || form == Form.NAMED_HEXADECIMAL_NUMBER) {
                stringBuffer.append(string5);
            } else if (form == Form.DECIMAL_NUMBER) {
                stringBuffer.append("&#" + Integer.toString(c) + ";");
            } else {
                stringBuffer.append("&#x" + Integer.toHexString(c) + ";");
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    public static String unescape(String string) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            switch (c) {
                case '&': {
                    int n3 = string.indexOf(59, n2 + 1);
                    if (n3 < 0) {
                        throw new IllegalArgumentException(GDKMessage.getMessage(5203, (Object)string.substring(n2 + 1)));
                    }
                    if (string.charAt(n2 + 1) == '#') {
                        if (string.charAt(n2 + 2) == 'x') {
                            try {
                                stringBuffer.append((char)Integer.parseInt(string.substring(n2 + 3, n3), 16));
                            }
                            catch (NumberFormatException numberFormatException) {
                                throw new IllegalArgumentException(GDKMessage.getMessage(5201, (Object)string.substring(n2 + 3, n3)));
                            }
                        } else {
                            try {
                                stringBuffer.append((char)Integer.parseInt(string.substring(n2 + 2, n3), 10));
                            }
                            catch (NumberFormatException numberFormatException) {
                                throw new IllegalArgumentException(GDKMessage.getMessage(5202, (Object)string.substring(n2 + 2, n3)));
                            }
                        }
                    } else {
                        String string2 = (String)charEntity.get(string.substring(n2 + 1, n3));
                        if (string2 == null) {
                            throw new IllegalArgumentException(GDKMessage.getMessage(5203, (Object)string.substring(n2 + 1, n3)));
                        }
                        stringBuffer.append(string2.charAt(0));
                    }
                    n2 = n3;
                    break;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    static {
        resCharEntities.put(new Character('<'), "&lt;");
        resCharEntities.put(new Character('>'), "&gt;");
        resCharEntities.put(new Character('&'), "&amp;");
        resCharEntities.put(new Character('\''), "&apos;");
        resCharEntities.put(new Character('\"'), "&quot;");
    }

    public static class Form {
        private static int m_nextOrdinal = 0;
        public static final Form NAMED = new Form("Named entity");
        public static final Form DECIMAL_NUMBER = new Form("Decimal number entity");
        public static final Form HEXADECIMAL_NUMBER = new Form("Hexadecimal number entity");
        public static final Form NAMED_HEXADECIMAL_NUMBER = new Form("Named entity");
        public static final Form NAMED_DECIMAL_NUMBER = new Form("Decimal number entity");
        private final int m_ordinal = m_nextOrdinal++;
        private final String name;

        private Form(String string) {
            this.name = string;
        }

        public String toString() {
            return this.name;
        }

        public static final int size() {
            return m_nextOrdinal;
        }
    }
}

