/*
 * Decompiled with CFR 0.152.
 */
package oracle.gss.util;

import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Vector;
import oracle.gss.util.NLSLocaleInfo;
import oracle.i18n.text.OraMapTable;

public abstract class NLSLocale {
    public static final int NLSCHARSET = 0;
    public static final int JAVACHARSET = 1;
    public static final int IANACHARSET = 2;
    private static OraMapTable ISO_ORACLE_NAME_MAPPING = null;

    NLSLocale() {
    }

    public static synchronized NLSLocale getInstance(int n) {
        if (ISO_ORACLE_NAME_MAPPING == null) {
            ISO_ORACLE_NAME_MAPPING = OraMapTable.getInstance(1);
        }
        return new NLSLocaleInfo();
    }

    public static synchronized NLSLocale getInstance() {
        if (ISO_ORACLE_NAME_MAPPING == null) {
            ISO_ORACLE_NAME_MAPPING = OraMapTable.getInstance(1);
        }
        return new NLSLocaleInfo();
    }

    public Locale getJavaLocale(String string) {
        HashMap hashMap = ISO_ORACLE_NAME_MAPPING.getHashMapAttribute("NLS_LOCALE_2_JAVA_LOCALE");
        String string2 = string.toUpperCase(Locale.US);
        Locale locale = (Locale)hashMap.get(string.toUpperCase(Locale.US));
        if (locale == null) {
            String string3;
            String string4;
            int n = string2.indexOf("_");
            if (n > -1) {
                string4 = string2.substring(0, n);
                string3 = string2.substring(n + 1);
            } else {
                string4 = string2;
                string3 = "";
            }
            locale = this.getJavaLocale(string4, string3);
        }
        return locale;
    }

    public Locale getJavaLocale(String string, String string2) {
        Locale locale = null;
        String string3 = string.toUpperCase(Locale.US);
        String string4 = string2.toUpperCase(Locale.US);
        String string5 = string3.compareTo("") == 0 ? "" : this.getJavaLanguage(string3);
        if (string5 != null) {
            if (string4.compareTo("") == 0) {
                locale = new Locale(string5, "");
            } else {
                String string6 = this.getJavaTerritory(string4);
                if (string6 != null) {
                    locale = new Locale(string5, string6);
                }
            }
        }
        return locale;
    }

    public String getJavaLanguage(String string) {
        HashMap hashMap = ISO_ORACLE_NAME_MAPPING.getHashMapAttribute("ORACLE_LANG_2_ISO_A2_LANG");
        return (String)hashMap.get(string.toUpperCase(Locale.US));
    }

    public String getJavaTerritory(String string) {
        HashMap hashMap = ISO_ORACLE_NAME_MAPPING.getHashMapAttribute("ORACLE_TERR_2_ISO_A2_TERR");
        return (String)hashMap.get(string.toUpperCase(Locale.US));
    }

    public Enumeration enumNLSLocales() {
        HashMap hashMap = ISO_ORACLE_NAME_MAPPING.getHashMapAttribute("NLS_LOCALE_2_JAVA_LOCALE");
        Vector vector = new Vector();
        return Collections.enumeration(hashMap.keySet());
    }

    public Enumeration enumJavaLocales() {
        HashMap hashMap = ISO_ORACLE_NAME_MAPPING.getHashMapAttribute("JAVA_LOCALE_2_NLS_LOCALE");
        Vector vector = new Vector();
        return Collections.enumeration(hashMap.keySet());
    }

    public String getJavaCharset(String string) {
        HashMap hashMap = ISO_ORACLE_NAME_MAPPING.getHashMapAttribute("NLS_CHARSET_2_JAVA_CHARSET");
        String string2 = (String)hashMap.get(string.toUpperCase(Locale.US));
        if (string2 == null || string2.equals("")) {
            return null;
        }
        return string2;
    }

    public String getJavaCharset(int n, String string) {
        String string2;
        if (string == null) {
            return null;
        }
        switch (n) {
            case 0: {
                HashMap hashMap = ISO_ORACLE_NAME_MAPPING.getHashMapAttribute("NLS_CHARSET_2_JAVA_CHARSET");
                string2 = (String)hashMap.get(string.toUpperCase(Locale.US));
                break;
            }
            case 2: {
                HashMap hashMap = ISO_ORACLE_NAME_MAPPING.getHashMapAttribute("IANA_CHARSET_2_JAVA_CHARSET");
                string2 = (String)hashMap.get(string.toUpperCase(Locale.US));
                break;
            }
            default: {
                return string;
            }
        }
        if (string2 == null || string2.equals("")) {
            return null;
        }
        return string2;
    }

    public String getNLSCharset(int n, String string) {
        if (string == null) {
            return null;
        }
        String string2 = null;
        switch (n) {
            case 1: {
                HashMap hashMap = ISO_ORACLE_NAME_MAPPING.getHashMapAttribute("JAVA_CHARSET_2_NLS_CHARSET");
                string2 = (String)hashMap.get(string.toUpperCase(Locale.US));
                if (string2 != null && !string2.equals("")) break;
                hashMap = ISO_ORACLE_NAME_MAPPING.getHashMapAttribute("IANA_2_ORACLE");
                string2 = (String)hashMap.get(string.toUpperCase(Locale.US));
                break;
            }
            case 2: {
                HashMap hashMap = ISO_ORACLE_NAME_MAPPING.getHashMapAttribute("IANA_2_ORACLE");
                string2 = (String)hashMap.get(string.toUpperCase(Locale.US));
                break;
            }
            default: {
                return string;
            }
        }
        if (string2 == null || string2.equals("")) {
            return null;
        }
        return string2;
    }

    public String getIANACharset(int n, String string) {
        if (string == null) {
            return null;
        }
        String string2 = null;
        switch (n) {
            case 0: {
                HashMap hashMap = ISO_ORACLE_NAME_MAPPING.getHashMapAttribute("ORACLE_2_IANA");
                string2 = (String)hashMap.get(string.toUpperCase(Locale.US));
                break;
            }
            case 1: {
                HashMap hashMap = ISO_ORACLE_NAME_MAPPING.getHashMapAttribute("JAVA_CHARSET_2_IANA_CHARSET");
                string2 = (String)hashMap.get(string.toUpperCase(Locale.US));
                break;
            }
            default: {
                return string;
            }
        }
        if (string2 == null || string2.equals("")) {
            return null;
        }
        return string2;
    }

    public String getNLSCharset(String string) {
        HashMap hashMap = ISO_ORACLE_NAME_MAPPING.getHashMapAttribute("JAVA_CHARSET_2_NLS_CHARSET");
        String string2 = (String)hashMap.get(string.toUpperCase(Locale.US));
        if (string2 == null || string2.equals("")) {
            return null;
        }
        return string2;
    }

    public Enumeration enumNLSCharsets() {
        HashMap hashMap = ISO_ORACLE_NAME_MAPPING.getHashMapAttribute("NLS_CHARSET_2_JAVA_CHARSET");
        HashMap hashMap2 = ISO_ORACLE_NAME_MAPPING.getHashMapAttribute("ORACLE_2_IANA");
        Vector vector = new Vector();
        vector.addAll(hashMap.keySet());
        vector.removeAll(hashMap2.keySet());
        vector.addAll(hashMap2.keySet());
        Collections.sort(vector);
        return Collections.enumeration(vector);
    }

    public Enumeration enumJavaCharsets() {
        HashMap hashMap = ISO_ORACLE_NAME_MAPPING.getHashMapAttribute("JAVA_CHARSET_2_NLS_CHARSET");
        HashMap hashMap2 = ISO_ORACLE_NAME_MAPPING.getHashMapAttribute("JAVA_CHARSET_2_IANA_CHARSET");
        Vector vector = new Vector();
        vector.addAll(hashMap.keySet());
        vector.removeAll(hashMap2.keySet());
        vector.addAll(hashMap2.keySet());
        Collections.sort(vector);
        return Collections.enumeration(vector);
    }

    public Enumeration enumIANACharsets() {
        HashMap hashMap = ISO_ORACLE_NAME_MAPPING.getHashMapAttribute("IANA_2_ORACLE");
        HashMap hashMap2 = ISO_ORACLE_NAME_MAPPING.getHashMapAttribute("IANA_CHARSET_2_JAVA_CHARSET");
        Vector vector = new Vector();
        vector.addAll(hashMap.keySet());
        vector.removeAll(hashMap2.keySet());
        vector.addAll(hashMap2.keySet());
        Collections.sort(vector);
        return Collections.enumeration(vector);
    }

    public String getNLSLocale() {
        return this.getNLSLocale(Locale.getDefault());
    }

    public String getNLSLocale(Locale locale) {
        HashMap hashMap = ISO_ORACLE_NAME_MAPPING.getHashMapAttribute("JAVA_LOCALE_2_NLS_LOCALE");
        String string = (String)hashMap.get(locale);
        if (string == null) {
            String string2 = this.getNLSLanguage(locale);
            String string3 = locale.getCountry();
            if (string3.compareTo("") == 0) {
                return string2;
            }
            String string4 = this.getNLSTerritory(string3);
            if (string2 != null && string4 != null) {
                string = string2 + "_" + string4;
            }
        }
        return string;
    }

    public String getNLSLanguage(Locale locale) {
        String string = null;
        HashMap hashMap = ISO_ORACLE_NAME_MAPPING.getHashMapAttribute("JAVA_LOCALE_2_NLS_LANG");
        string = (String)hashMap.get(locale);
        if (string == null) {
            string = this.getNLSLanguage(locale.getLanguage());
        }
        return string;
    }

    public String getNLSTerritory(Locale locale) {
        int n;
        String string;
        String string2 = locale.getCountry();
        if (string2.compareTo("") == 0 && (string = this.getNLSLocale(locale)) != null && (n = string.indexOf(95)) != -1) {
            return string.substring(n + 1);
        }
        return this.getNLSTerritory(locale.getCountry());
    }

    public String getNLSLanguage(String string) {
        HashMap hashMap = ISO_ORACLE_NAME_MAPPING.getHashMapAttribute("ISO_A2_LANG_2_ORACLE_LANG");
        return (String)hashMap.get(string);
    }

    public String getNLSTerritory(String string) {
        HashMap hashMap = ISO_ORACLE_NAME_MAPPING.getHashMapAttribute("ISO_A2_TERR_2_ORACLE_TERR");
        return (String)hashMap.get(string.toUpperCase(Locale.US));
    }
}

