/*
 * Decompiled with CFR 0.152.
 */
package oracle.i18n.lcsd;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import oracle.i18n.lcsd.CmgIState;
import oracle.i18n.lcsd.CmgModel;
import oracle.i18n.lcsd.UniChrMG;

class ProfileParser {
    private static final String NAME = "/oracle/i18n/data/lx70001.nlb";
    private static final String DATAPATH = "/oracle/i18n/data/";
    private static final int UCHR_MAX = 256;
    private InputStream file;

    ProfileParser(String string) throws FileNotFoundException, IOException {
        URL uRL = this.getClass().getResource(DATAPATH + string);
        if (uRL == null) {
            throw new FileNotFoundException(string + " not found");
        }
        this.file = uRL.openStream();
    }

    ProfileParser() throws FileNotFoundException, IOException {
        URL uRL = this.getClass().getResource(NAME);
        if (uRL == null) {
            throw new FileNotFoundException("/oracle/i18n/data/lx70001.nlb not found");
        }
        this.file = uRL.openStream();
    }

    String readHeader() throws IOException {
        byte[] byArray = new byte[13];
        if (this.file.read(byArray) == -1) {
            throw new IOException("Unexpected end of file");
        }
        return new String(byArray, "ascii");
    }

    int getint() throws IOException {
        byte[] byArray = new byte[4];
        if (this.file.read(byArray) == -1) {
            throw new IOException("Unexpected end of file");
        }
        return byArray[0] & 0xFF | (byArray[1] & 0xFF) << 8 | (byArray[2] & 0xFF) << 16 | (byArray[3] & 0xFF) << 24;
    }

    byte getbyte() throws IOException {
        int n = this.file.read();
        if (n == -1) {
            throw new IOException("Unexpected end of file");
        }
        return (byte)n;
    }

    char getchar() throws IOException {
        int n = this.file.read();
        if (n == -1) {
            throw new IOException("Unexpected end of file");
        }
        return (char)n;
    }

    short getshort() throws IOException {
        byte[] byArray = new byte[2];
        if (this.file.read(byArray) == -1) {
            throw new IOException("Unexpected end of file");
        }
        return (short)((byArray[1] & 0xFF) << 8 | byArray[0] & 0xFF);
    }

    float getfloat() throws IOException {
        byte[] byArray = new byte[4];
        if (this.file.read(byArray) == -1) {
            throw new IOException("Unexpected end of file");
        }
        return Float.intBitsToFloat(byArray[0] & 0xFF | (byArray[1] & 0xFF) << 8 | (byArray[2] & 0xFF) << 16 | (byArray[3] & 0xFF) << 24);
    }

    byte[] getbyteArray(int n) throws IOException {
        byte[] byArray = new byte[n];
        if (this.file.read(byArray) == -1) {
            throw new IOException("Unexpected end of file");
        }
        return byArray;
    }

    char[] getcharArray(int n) throws IOException {
        byte[] byArray = new byte[n];
        if (this.file.read(byArray) == -1) {
            throw new IOException("Unexpected end of file");
        }
        char[] cArray = new char[n - 1];
        int n2 = 0;
        while (n2 < n - 1) {
            cArray[n2] = (char)byArray[n2];
            ++n2;
        }
        return cArray;
    }

    int[] getintArray(int n) throws IOException {
        byte[] byArray = new byte[n * 4];
        int[] nArray = new int[n];
        if (this.file.read(byArray) == -1) {
            throw new IOException("Unexpected end of file");
        }
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            nArray[n3] = byArray[n2] & 0xFF | (byArray[n2 + 1] & 0xFF) << 8 | (byArray[n2 + 2] & 0xFF) << 16 | (byArray[n2 + 3] & 0xFF) << 24;
            n2 += 4;
            ++n3;
        }
        return nArray;
    }

    short[] getshortArray(int n) throws IOException {
        byte[] byArray = new byte[n * 2];
        short[] sArray = new short[n];
        if (this.file.read(byArray) == -1) {
            throw new IOException("Unexpected end of file");
        }
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            sArray[n3] = (short)(byArray[n2] & 0xFF | (byArray[n2 + 1] & 0xFF) << 8);
            n2 += 2;
            ++n3;
        }
        return sArray;
    }

    float[] getfloatArray(int n) throws IOException {
        byte[] byArray = new byte[n * 4];
        float[] fArray = new float[n];
        if (this.file.read(byArray) == -1) {
            throw new IOException("Unexpected end of file");
        }
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            fArray[n3] = Float.intBitsToFloat(byArray[n2] & 0xFF | (byArray[n2 + 1] & 0xFF) << 8 | (byArray[n2 + 2] & 0xFF) << 16 | (byArray[n2 + 3] & 0xFF) << 24);
            n2 += 4;
            ++n3;
        }
        return fArray;
    }

    CmgModel[] getCmgModelArray(int n) throws IOException {
        CmgModel[] cmgModelArray = new CmgModel[n];
        int n2 = 0;
        while (n2 < n) {
            cmgModelArray[n2] = new CmgModel();
            this.getint();
            cmgModelArray[n2].norm_lprob = this.getfloat();
            cmgModelArray[n2].lpmin = this.getfloat();
            cmgModelArray[n2].grad = this.getfloat();
            cmgModelArray[n2].fact_id = this.getint();
            ++n2;
        }
        return cmgModelArray;
    }

    CmgIState[] getCmgIStateArray(int n) throws IOException {
        CmgIState[] cmgIStateArray = new CmgIState[n];
        int n2 = 0;
        while (n2 < n) {
            cmgIStateArray[n2] = new CmgIState();
            int n3 = this.getint();
            int n4 = this.getint();
            n4 = (n4 >>> 24) + ((n4 & 0xFFFFFF) << 8);
            cmgIStateArray[n2].nb_chrs = n4 & 0xFF;
            cmgIStateArray[n2].so_offset = n4 >>> 8;
            if (n4 >>> 8 != 0) {
                cmgIStateArray[n2].chrs = n3;
            } else {
                cmgIStateArray[n2].dnxts = n3 / 4;
            }
            ++n2;
        }
        return cmgIStateArray;
    }

    void getCmgLStateArray(int n, int[] nArray, byte[] byArray) throws IOException {
        int n2 = 0;
        while (n2 < n) {
            int n3 = this.getint();
            n3 = (n3 >>> 24) + ((n3 & 0xFFFFFF) << 8);
            nArray[n2] = n3 >>> 8;
            byArray[n2] = (byte)(n3 & 0xFF);
            ++n2;
        }
    }

    void getLmgMPElemArray(int n, byte[] byArray, byte[] byArray2) throws IOException {
        int n2 = 0;
        while (n2 < n) {
            byArray[n2] = this.getbyte();
            byArray2[n2] = this.getbyte();
            ++n2;
        }
    }

    UniChrMG getUniChrMG() throws IOException {
        UniChrMG uniChrMG = new UniChrMG();
        uniChrMG.nb_models = this.getint();
        uniChrMG.nb_facts = this.getint();
        uniChrMG.uch_lps_buff_size = this.getint();
        uniChrMG.models_normlp = this.getfloatArray(uniChrMG.nb_models);
        uniChrMG.models_lpmin = this.getfloatArray(uniChrMG.nb_models);
        uniChrMG.models_grad = this.getfloatArray(uniChrMG.nb_models);
        uniChrMG.uch_lps_buff_model_no = new byte[uniChrMG.uch_lps_buff_size];
        uniChrMG.uch_lps_buff_lprob = new byte[uniChrMG.uch_lps_buff_size];
        this.getLmgMPElemArray(uniChrMG.uch_lps_buff_size, uniChrMG.uch_lps_buff_model_no, uniChrMG.uch_lps_buff_lprob);
        uniChrMG.uch_lps = this.getintArray(256);
        int n = 0;
        while (n < 256) {
            uniChrMG.uch_lps[n] = (uniChrMG.uch_lps[n] >>> 22) + ((uniChrMG.uch_lps[n] & 0x3FFFFF) << 10);
            ++n;
        }
        return uniChrMG;
    }
}

