/*
 * Decompiled with CFR 0.152.
 */
package oracle.i18n.lcsd;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import oracle.i18n.lcsd.CmgIState;
import oracle.i18n.lcsd.MGFact;
import oracle.i18n.lcsd.MGroupEval;
import oracle.i18n.lcsd.MgeUAElem;
import oracle.i18n.lcsd.ProfileData;
import oracle.i18n.lcsd.ProfileParser;
import oracle.i18n.util.ConverterArchive;

class Profile
implements Serializable {
    private static final transient HashMap profileCache = new HashMap();
    private static final transient String STANDARD_PROFILE = "standard";
    private static final String DATAPATH = "/oracle/i18n/data/";
    private static final transient int MODELS_MAX = 256;
    private static final transient int UCHR_MAX = 256;
    private static final transient float EPSILON_LPROB = 30.0f;
    private ProfileData profileData;
    private transient byte prev_byte;
    private transient int curr_state;
    private transient MGroupEval mg_eval;
    private transient byte fst1;
    private transient byte fst2;
    private transient int nb_fsts;
    private transient int langid;
    private transient int charsetid;
    private transient int bestIndex;
    private transient float bestRatio;

    private Profile() {
    }

    public static synchronized Profile getInstance() throws FileNotFoundException, IOException {
        ProfileData profileData = (ProfileData)profileCache.get(STANDARD_PROFILE);
        if (profileData == null) {
            ConverterArchive converterArchive = new ConverterArchive();
            profileData = (ProfileData)converterArchive.readObj("/oracle/i18n/data/lx70001.glb");
            profileCache.put(STANDARD_PROFILE, profileData);
        }
        Profile profile = new Profile();
        profile.profileData = profileData;
        profile.mg_eval = new MGroupEval(profile.profileData);
        return profile;
    }

    public static synchronized Profile getInstance(String string) throws FileNotFoundException, IOException {
        ProfileData profileData = (ProfileData)profileCache.get(string);
        if (profileData == null) {
            ConverterArchive converterArchive = new ConverterArchive();
            profileData = (ProfileData)converterArchive.readObj(DATAPATH + string + ".glb");
            if (profileData == null) {
                throw new FileNotFoundException(string + " not found");
            }
            profileCache.put(string, profileData);
        }
        Profile profile = new Profile();
        profile.profileData = profileData;
        profile.mg_eval = new MGroupEval(profile.profileData);
        return profile;
    }

    public static void writeGLB(String string, String string2, String string3) throws FileNotFoundException, IOException {
        ProfileData profileData = Profile.readNLBFile(string3);
        ConverterArchive converterArchive = new ConverterArchive();
        converterArchive.insertObjtoFile(string, string2, (Object)profileData);
    }

    public static ProfileData readNLBFile(String string) throws FileNotFoundException, IOException {
        ProfileParser profileParser = string == null ? new ProfileParser() : new ProfileParser(string);
        ProfileData profileData = new ProfileData();
        String string2 = profileParser.readHeader();
        profileData.nb_models = profileParser.getint();
        profileData.nb_istates = profileParser.getint();
        profileData.min_for_direct = profileParser.getint();
        int n = profileParser.getint();
        int n2 = profileParser.getint();
        int n3 = profileParser.getint();
        int n4 = profileParser.getint();
        int n5 = profileParser.getint();
        int n6 = profileParser.getint();
        profileData.nb_facts = profileParser.getint();
        int n7 = profileParser.getint();
        int n8 = profileParser.getint();
        int n9 = profileParser.getint();
        int n10 = profileParser.getint();
        profileData.preprocessbitmap = n7 | n8 << 1 | n9 << 2 | n10 << 3;
        profileData.models = profileParser.getCmgModelArray(profileData.nb_models);
        int n11 = 0;
        while (n11 < profileData.nb_models) {
            int n12 = profileParser.getint();
            profileData.models[n11].name = profileParser.getcharArray(n12);
            ++n11;
        }
        profileData.istates = profileParser.getCmgIStateArray(n);
        profileData.istates_chrs = profileParser.getbyteArray(n2);
        profileData.istates_dnxts = profileParser.getintArray(n3);
        profileData.lstates_vals_offs = new int[n4];
        profileData.lstates_nb_vals = new byte[n4];
        profileParser.getCmgLStateArray(n4, profileData.lstates_vals_offs, profileData.lstates_nb_vals);
        profileData.lstates_model_no = new byte[n5];
        profileData.lstates_lprob = new byte[n5];
        profileParser.getLmgMPElemArray(n5, profileData.lstates_model_no, profileData.lstates_lprob);
        profileData.def_so = profileParser.getshortArray(n6);
        profileData.umg = profileParser.getUniChrMG();
        int[] nArray = new int[profileData.nb_models];
        int n13 = 0;
        while (n13 < profileData.nb_models) {
            int n14 = profileData.models[n13].fact_id;
            if (n14 != -1) {
                n14 -= profileData.nb_models;
            }
            nArray[n13] = n14;
            ++n13;
        }
        profileData.facts = Profile.buildMGfact(nArray, profileData.nb_models);
        return profileData;
    }

    private static MGFact buildMGfact(int[] nArray, int n) {
        int n2 = -1;
        MGFact mGFact = new MGFact();
        mGFact.nb_models = n;
        mGFact.model_fact = new int[n];
        int n3 = 0;
        while (n3 < n) {
            mGFact.model_fact[n3] = nArray[n3];
            n2 = Math.max(n2, nArray[n3]);
            ++n3;
        }
        mGFact.nb_facts = n2 + 1;
        mGFact.fact_nb_models = new int[mGFact.nb_facts];
        int n4 = 0;
        while (n4 < mGFact.nb_facts) {
            mGFact.fact_nb_models[n4] = 0;
            ++n4;
        }
        n3 = 0;
        while (n3 < n) {
            n4 = mGFact.model_fact[n3];
            if (n4 != -1) {
                int n5 = n4;
                mGFact.fact_nb_models[n5] = mGFact.fact_nb_models[n5] + 1;
            }
            ++n3;
        }
        n4 = 0;
        while (n4 < mGFact.nb_facts) {
            mGFact.fact_nb_models[n4] = 0;
            ++n4;
        }
        mGFact.fact_models = new int[256][256];
        n3 = 0;
        while (n3 < n) {
            n4 = mGFact.model_fact[n3];
            if (n4 != -1) {
                mGFact.fact_models[n4][mGFact.fact_nb_models[n4]] = n3;
                int n6 = n4;
                mGFact.fact_nb_models[n6] = mGFact.fact_nb_models[n6] + 1;
            }
            ++n3;
        }
        return mGFact;
    }

    private static Profile readGLBFile(String string) {
        return null;
    }

    public void reset() {
        this.mg_eval = new MGroupEval(this.profileData);
        this.prev_byte = 0;
        this.curr_state = 0;
        this.fst1 = 0;
        this.fst2 = 0;
        this.nb_fsts = 0;
        this.langid = 0;
        this.charsetid = 0;
        this.bestIndex = 0;
        this.bestRatio = 0.0f;
    }

    private int[] addByte(byte by) {
        this.curr_state = this.getNextState(by, this.curr_state);
        int n = this.profileData.nb_istates;
        if (this.curr_state < n) {
            if (this.curr_state == 0) {
                this.curr_state = this.getNextState(this.prev_byte, 0);
                this.curr_state = this.getNextState(by, this.curr_state);
                if (this.curr_state == 0) {
                    this.curr_state = this.getNextState(by, 0);
                }
            }
            this.prev_byte = by;
            return null;
        }
        this.prev_byte = by;
        int n2 = this.curr_state - n;
        this.curr_state = this.profileData.def_so[n2] & 0xFFFF;
        int n3 = this.profileData.lstates_nb_vals[n2] & 0xFF;
        int n4 = this.profileData.lstates_vals_offs[n2];
        int[] nArray = new int[]{n4, n3};
        return nArray;
    }

    private int getNextState(byte by, int n) {
        CmgIState[] cmgIStateArray = this.profileData.istates;
        byte[] byArray = this.profileData.istates_chrs;
        if (cmgIStateArray[n].so_offset != 0) {
            int n2 = cmgIStateArray[n].chrs;
            int n3 = cmgIStateArray[n].nb_chrs;
            if (n3 > 4) {
                int n4 = 0;
                int n5 = n3 - 1;
                while (n4 <= n5) {
                    int n6 = n4 + n5 + 1 >>> 1;
                    if (byArray[n2 + n6] == by) {
                        return cmgIStateArray[n].so_offset + n6;
                    }
                    if ((byArray[n2 + n6] & 0xFF) < (by & 0xFF)) {
                        n4 = n6 + 1;
                        continue;
                    }
                    n5 = n6 - 1;
                }
                return 0;
            }
            int n7 = 0;
            while (n7 < n3 && (byArray[n2 + n7] & 0xFF) < (by & 0xFF)) {
                ++n7;
            }
            return n7 < n3 && byArray[n2 + n7] == by ? cmgIStateArray[n].so_offset + n7 : 0;
        }
        return this.profileData.istates_dnxts[cmgIStateArray[n].dnxts + (by & 0xFF)];
    }

    private void evaluateBytes(byte[] byArray, int n, int n2) {
        this.mg_eval.tot_nb_lprobs += n2;
        while (n2 != 0) {
            byte by = byArray[n];
            int[] nArray = this.addByte(by);
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            if (nArray != null) {
                n6 = nArray[0];
                n5 = nArray[1];
            }
            int n7 = by & 0xFF;
            this.mg_eval.uni_counts[n7] = this.mg_eval.uni_counts[n7] + 1;
            this.mg_eval.verifyutf8(by);
            while (n4 < n5) {
                n3 = this.profileData.lstates_model_no[n6 + n4] & 0xFF;
                int[] nArray2 = this.mg_eval.models_chrs_counts[n3];
                int n8 = by & 0xFF;
                nArray2[n8] = nArray2[n8] + 1;
                int n9 = n3;
                this.mg_eval.ilprobs[n9] = this.mg_eval.ilprobs[n9] + (this.profileData.lstates_lprob[n6 + n4] & 0xFF);
                int n10 = n3;
                this.mg_eval.ilp_counts[n10] = this.mg_eval.ilp_counts[n10] + 1;
                ++n4;
            }
            ++n;
            --n2;
        }
        this.int2float();
    }

    private float int2float_lp(int n, float f, float f2, int n2) {
        return (float)n * f2 + (float)n2 * f;
    }

    private void int2float() {
        int n;
        int n2 = 0;
        while (n2 < this.mg_eval.nb_models) {
            n = this.profileData.models[n2].fact_id;
            if (n != -1) {
                int n3 = n2;
                this.mg_eval.ilp_counts[n3] = this.mg_eval.ilp_counts[n3] + this.mg_eval.ilp_counts[n];
                int n4 = n2;
                this.mg_eval.ilprobs[n4] = this.mg_eval.ilprobs[n4] + this.mg_eval.ilprobs[n];
            }
            ++n2;
        }
        n = this.mg_eval.nb_models;
        while (n < this.mg_eval.nb_mods_facts) {
            this.mg_eval.ilp_counts[n] = 0;
            this.mg_eval.ilprobs[n] = 0;
            ++n;
        }
        n2 = 0;
        while (n2 < this.mg_eval.nb_models) {
            if (this.mg_eval.ilp_counts[n2] != 0) {
                int n5 = n2;
                this.mg_eval.lprobs[n5] = this.mg_eval.lprobs[n5] + this.int2float_lp(this.mg_eval.ilprobs[n2], this.profileData.models[n2].lpmin, this.profileData.models[n2].grad, this.mg_eval.ilp_counts[n2]);
                int n6 = n2;
                this.mg_eval.lp_counts[n6] = this.mg_eval.lp_counts[n6] + this.mg_eval.ilp_counts[n2];
                this.mg_eval.ilp_counts[n2] = 0;
                this.mg_eval.ilprobs[n2] = 0;
            }
            ++n2;
        }
    }

    public void add(byte[] byArray) {
        this.add(byArray, byArray.length);
    }

    /*
     * Unable to fully structure code
     */
    public void add(byte[] var1_1, int var2_2) {
        var7_3 = 0;
        var9_4 = var2_2;
        if (var9_4 > 0) ** GOTO lbl47
        return;
lbl-1000:
        // 1 sources

        {
            var6_6 = var9_4 > 1024 ? 1024 : var9_4;
            var5_5 = new byte[var6_6];
            var8_7 = 0;
            var9_4 -= var6_6;
            var10_8 = 0;
            var11_9 = var7_3;
            while (var10_8 < var6_6) {
                var5_5[var10_8] = var1_1[var11_9];
                ++var10_8;
                ++var11_9;
            }
            var7_3 += var6_6;
            this.mg_eval.chk_ucs2(var5_5, var6_6);
            var6_6 = this.preprocessFacs(var5_5, var6_6);
            if (this.nb_fsts < 2) {
                if (var6_6 != 0 && this.nb_fsts == 0) {
                    v0 = var5_5[var8_7] & 255;
                    this.mg_eval.uni_counts[v0] = this.mg_eval.uni_counts[v0] + 1;
                    this.mg_eval.verifyutf8(var5_5[var8_7]);
                    this.fst1 = var5_5[var8_7++];
                    --var6_6;
                    ++this.nb_fsts;
                }
                if (var6_6 != 0 && this.nb_fsts == 1) {
                    v1 = var5_5[var8_7] & 255;
                    this.mg_eval.uni_counts[v1] = this.mg_eval.uni_counts[v1] + 1;
                    this.mg_eval.verifyutf8(var5_5[var8_7]);
                    this.fst2 = var5_5[var8_7++];
                    --var6_6;
                    ++this.nb_fsts;
                    this.curr_state = 0;
                    this.prev_byte = 0;
                    this.addByte(this.fst1);
                    this.addByte(this.fst2);
                }
            }
            if (var6_6 == 0) {
                if (this.langid == 0 || this.charsetid != 0) {
                    // empty if block
                }
                return;
            }
            this.nb_fsts = 3;
            this.evaluateBytes(var5_5, var8_7, var6_6);
            if (this.langid != 0 && this.charsetid == 0) continue;
lbl47:
            // 3 sources

            ** while (var9_4 > 0)
        }
lbl48:
        // 1 sources

    }

    public MGroupEval getMGroupEval() {
        return null;
    }

    private int rmTricarDups(byte[] byArray, int n) {
        int n2 = 0;
        byte by = byArray[0];
        int n3 = -1;
        int n4 = 0;
        while (n2 != n) {
            if (by == byArray[n2]) {
                if (++n3 == 3) {
                    while (by == byArray[++n2]) {
                    }
                    n3 = 0;
                }
            } else {
                n3 = 0;
            }
            by = byArray[n2];
            byArray[n4++] = byArray[n2++];
        }
        return n4;
    }

    private int rmCaps(byte[] byArray, int n) {
        int n2 = 0;
        while (n2 < n) {
            if ((byArray[n2] & 0xFF) >= 65 && (byArray[n2] & 0xFF) <= 90) {
                int n3 = n2;
                byArray[n3] = (byte)(byArray[n3] + 32);
            }
            ++n2;
        }
        return n;
    }

    private int rmDigits(byte[] byArray, int n) {
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            if ((byArray[n3] & 0xFF) < 48 || (byArray[n3] & 0xFF) > 57) {
                byArray[n2++] = byArray[n3];
            }
            ++n3;
        }
        return n2;
    }

    private int rmDigitsCaps(byte[] byArray, int n) {
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            if ((byArray[n3] & 0xFF) >= 65 && (byArray[n3] & 0xFF) <= 90) {
                byArray[n2++] = (byte)(byArray[n3] + 32);
            } else if ((byArray[n3] & 0xFF) < 48 || (byArray[n3] & 0xFF) > 57) {
                byArray[n2++] = byArray[n3];
            }
            ++n3;
        }
        return n2;
    }

    private int rmDigitsCapsTriDup(byte[] byArray, int n) {
        int n2 = 0;
        byte by = byArray[0];
        int n3 = -1;
        int n4 = 0;
        while (n2 < n) {
            if (by == byArray[n2]) {
                if (++n3 == 3) {
                    while (++n2 < n && by == byArray[n2]) {
                    }
                    n3 = 0;
                }
            } else {
                n3 = 0;
            }
            if (n2 >= n) break;
            by = byArray[n2];
            if ((byArray[n2] & 0xFF) >= 65 && (byArray[n2] & 0xFF) <= 90) {
                byArray[n4++] = (byte)(byArray[n2++] + 32);
                continue;
            }
            if ((byArray[n2] & 0xFF) < 48 || (byArray[n2] & 0xFF) > 57) {
                byArray[n4++] = byArray[n2++];
                continue;
            }
            ++n2;
        }
        return n4;
    }

    private int rmDigitsCapsTriDupBlks(byte[] byArray, int n) {
        int n2 = 0;
        byte by = byArray[0];
        int n3 = -1;
        int n4 = 0;
        while (n2 < n) {
            if (by == byArray[n2]) {
                if (++n3 == 3) {
                    while (++n2 < n && by == byArray[n2]) {
                    }
                    n3 = 0;
                }
            } else {
                n3 = 0;
            }
            if (n2 >= n) break;
            by = byArray[n2];
            if ((byArray[n2] & 0xFF) >= 65 && (byArray[n2] & 0xFF) <= 90) {
                byArray[n4++] = (byte)(byArray[n2++] + 32);
                continue;
            }
            if ((byArray[n2] & 0xFF) == 9 || (byArray[n2] & 0xFF) == 10 || (byArray[n2] & 0xFF) == 13) {
                byArray[n4++] = 32;
                ++n2;
                continue;
            }
            if ((byArray[n2] & 0xFF) < 48 || (byArray[n2] & 0xFF) > 57) {
                byArray[n4++] = byArray[n2++];
                continue;
            }
            ++n2;
        }
        return n4;
    }

    private int rmBlks(byte[] byArray, int n) {
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            byArray[n2++] = (byArray[n3] & 0xFF) != 9 && (byArray[n3] & 0xFF) != 10 && (byArray[n3] & 0xFF) != 13 ? byArray[n3] : 32;
            ++n3;
        }
        return n2;
    }

    private int preprocessFacs(byte[] byArray, int n) {
        switch (this.profileData.preprocessbitmap) {
            case 15: {
                n = this.rmDigitsCapsTriDupBlks(byArray, n);
                break;
            }
            case 7: {
                n = this.rmDigitsCapsTriDup(byArray, n);
                break;
            }
            case 6: {
                n = this.rmDigitsCaps(byArray, n);
                break;
            }
            case 8: {
                n = this.rmBlks(byArray, n);
                break;
            }
            case 4: {
                n = this.rmDigits(byArray, n);
                break;
            }
            case 2: {
                n = this.rmCaps(byArray, n);
                break;
            }
            case 1: {
                n = this.rmTricarDups(byArray, n);
                break;
            }
            default: {
                if ((this.profileData.preprocessbitmap & 8) != 0) {
                    n = this.rmTricarDups(byArray, n);
                }
                if ((this.profileData.preprocessbitmap & 4) != 0) {
                    n = this.rmCaps(byArray, n);
                }
                if ((this.profileData.preprocessbitmap & 2) != 0) {
                    n = this.rmDigits(byArray, n);
                }
                if ((this.profileData.preprocessbitmap & 1) == 0) break;
                n = this.rmBlks(byArray, n);
            }
        }
        return n;
    }

    float[] get_lprobs_mgroupeval() {
        int n;
        this.int2float();
        int n2 = 0;
        while (n2 < this.mg_eval.nb_mods_facts) {
            this.mg_eval.uilprobs[n2] = 0;
            this.mg_eval.uilp_counts[n2] = 0;
            ++n2;
        }
        int n3 = 0;
        while (n3 < 256) {
            int n4 = this.mg_eval.ulp_acs.tlens[n3];
            MgeUAElem[] mgeUAElemArray = this.mg_eval.ulp_acs.tables[n3];
            n2 = 0;
            while (n2 < n4) {
                n = mgeUAElemArray[n2].model & 0xFF;
                int n5 = mgeUAElemArray[n2].fact & 0xFFFF;
                int n6 = this.mg_eval.uni_counts[n3] - (n == n5 ? this.mg_eval.models_chrs_counts[n][n3] : this.mg_eval.models_chrs_counts[n][n3] + this.mg_eval.models_chrs_counts[n5][n3]);
                int n7 = n;
                this.mg_eval.uilprobs[n7] = this.mg_eval.uilprobs[n7] + n6 * (mgeUAElemArray[n2].uilp & 0xFF);
                int n8 = n;
                this.mg_eval.uilp_counts[n8] = this.mg_eval.uilp_counts[n8] + n6;
                ++n2;
            }
            ++n3;
        }
        n = 0;
        while (n < this.mg_eval.nb_models) {
            float f = this.mg_eval.lprobs[n];
            if (this.mg_eval.uilp_counts[n] != 0) {
                f += this.int2float_lp(this.mg_eval.uilprobs[n], this.profileData.umg.models_lpmin[n], this.profileData.umg.models_grad[n], this.mg_eval.uilp_counts[n]);
            }
            this.mg_eval.out_lprobs[n] = (f += 30.0f * (float)(this.mg_eval.tot_nb_lprobs - this.mg_eval.lp_counts[n] - this.mg_eval.uilp_counts[n])) / (float)this.mg_eval.tot_nb_lprobs;
            ++n;
        }
        this.mg_eval.filter_utf8(this.profileData);
        return this.mg_eval.out_lprobs;
    }

    float calcul_ratio(float[] fArray) {
        int n = this.profileData.nb_models;
        float f = 1.0E7f;
        int n2 = -1;
        if (fArray == null) {
            return -1.0f;
        }
        int n3 = 0;
        while (n3 < n) {
            if (fArray[n3] < f) {
                n2 = n3;
                f = fArray[n3];
            }
            ++n3;
        }
        this.bestIndex = n2;
        this.bestRatio = n2 < 0 || n2 >= n ? -1.0f : this.calcul_ratio_mdl(fArray, n2);
        return this.bestRatio;
    }

    float calcul_ratio_mdl(float[] fArray, int n) {
        float f = 0.0f;
        int n2 = 0;
        while (n2 < this.mg_eval.nb_models) {
            f += (float)Math.exp(fArray[n] - fArray[n2]);
            ++n2;
        }
        return 1.0f / f;
    }

    Object[][] getResult(String string, String string2) {
        String string3;
        int n;
        float[] fArray = this.get_lprobs_mgroupeval();
        float f = this.calcul_ratio(fArray);
        int n2 = this.profileData.nb_models;
        int[] nArray = new int[n2];
        nArray[0] = 0;
        if (string != null) {
            n = 0;
            while (n < n2) {
                string3 = new String(this.profileData.models[n].name);
                if (!string.equalsIgnoreCase(string3.substring(0, string3.indexOf(95)))) {
                    fArray[n] = 1.0E7f;
                }
                ++n;
            }
        } else if (string2 != null) {
            n = 0;
            while (n < n2) {
                string3 = new String(this.profileData.models[n].name);
                if (!string2.equalsIgnoreCase(string3.substring(string3.indexOf(95) + 1))) {
                    fArray[n] = 1.0E7f;
                }
                ++n;
            }
        }
        int n3 = 1;
        while (n3 < n2) {
            n = 0;
            while (n <= n3 - 1) {
                if (fArray[n3] < fArray[nArray[n]]) {
                    int n4 = n3;
                    while (n4 > n) {
                        nArray[n4] = nArray[n4 - 1];
                        --n4;
                    }
                    nArray[n] = n3;
                    break;
                }
                ++n;
            }
            if (n > n3 - 1) {
                nArray[n3] = n3;
            }
            ++n3;
        }
        Object[][] objectArray = new Object[n2][2];
        int n5 = 0;
        while (n5 < n2) {
            objectArray[n5][0] = new String(this.profileData.models[nArray[n5]].name);
            objectArray[n5][1] = new Float(this.calcul_ratio_mdl(fArray, nArray[n5]));
            ++n5;
        }
        return objectArray;
    }

    boolean isAL16UTF16() {
        return this.mg_eval.isAL16UTF16();
    }

    int promote_demote(int n) {
        return this.mg_eval.promote_demote(n);
    }
}

