/*
 * Decompiled with CFR 0.152.
 */
package oracle.i18n.lcsd;

import oracle.i18n.lcsd.MGEvUlpAcs;
import oracle.i18n.lcsd.MGLang;
import oracle.i18n.lcsd.MgeUAElem;
import oracle.i18n.lcsd.ProfileData;

class MGroupEval {
    private static final transient int UCHR_MAX = 256;
    private static final transient int FLGUTF8 = 1;
    private static final transient int FLGAL32UTF8 = 2;
    private static final transient int FLGUCS2LE = 4;
    private static final transient int EVENPOSITION = 1;
    private static final transient int BOMUTF8 = 1;
    private static final transient int BOMAL16UTF16 = 2;
    private static final transient int BOMAL16UTF16LE = 4;
    private static final transient byte[] MS1252 = new byte[]{-128, -126, -125, -124, -123, -122, -121, -120, -119, -118, -117, -116, -114, -111, -110, -109, -108, -107, -106, -105, -104, -103, -102, -101, -100, -98, -97};
    private static final transient byte[] ISOP15 = new byte[]{-92};
    private static final transient byte[] MS1250 = new byte[]{-128, -126, -124, -123, -122, -121, -119, -118, -117, -116, -115, -114, -113, -111, -110, -109, -108, -107, -106, -105, -103, -102, -101, -100, -99, -98, -97};
    private static final transient byte[] MS1251 = new byte[]{-128, -127, -126, -125, -124, -123, -122, -121, -120, -119, -118, -117, -116, -115, -114, -113, -112, -111, -110, -109, -108, -107, -106, -105, -103, -102, -101, -100, -99, -98, -97};
    private static final transient byte[] MS1253 = new byte[]{-128, -126, -125, -124, -123, -122, -121, -119, -117, -111, -110, -109, -108, -107, -106, -105, -103, -101, -92, -91, -82};
    private static final transient byte[] MS1254 = new byte[]{-128, -126, -125, -124, -123, -122, -121, -120, -119, -118, -117, -116, -111, -110, -109, -108, -107, -106, -105, -104, -103, -102, -101, -100, -97};
    private static final transient byte[] MS1255 = new byte[]{-128, -126, -125, -124, -123, -122, -121, -120, -119, -117, -111, -110, -109, -108, -107, -106, -105, -104, -103, -101, -95, -65, -64, -63, -62, -61, -60, -59, -58, -57, -56, -55, -53, -52, -51, -50, -49, -48, -47, -46, -45, -44, -43, -42, -41, -40, -3, -2};
    private static final transient byte[] ISOP8 = new byte[]{-33};
    private static final transient byte[] MS1256 = new byte[]{-128, -127, -126, -125, -124, -123, -122, -121, -120, -119, -118, -117, -116, -115, -114, -113, -112, -111, -110, -109, -108, -107, -106, -105, -104, -103, -102, -101, -100, -99, -98, -97, -95, -94, -93, -91, -90, -89, -88, -87, -86, -85, -82, -81, -80, -79, -78, -77, -76, -75, -74, -73, -72, -71, -70, -68, -67, -66, -64, -37, -36, -35, -34, -33, -13, -12, -11, -10, -9, -8, -7, -6, -5, -4, -3, -2, -49};
    private static final transient byte[] KO949 = new byte[]{-127, -126, -125, -124, -123, -122, -121, -120, -119, -118, -117, -116, -115, -114, -113, -112, -111, -110, -109, -108, -107, -106, -105, -104, -103, -102, -101, -100, -99, -98, -97};
    private static final transient byte[] GBK = new byte[]{-128, -127, -126, -125, -124, -123, -122, -121, -120, -119, -118, -117, -116, -115, -114, -113, -112, -111, -110, -109, -108, -107, -106, -105, -104, -103, -102, -101, -100, -99, -98, -97};
    MGEvUlpAcs ulp_acs;
    int nb_models;
    int nb_facts;
    int nb_mods_facts;
    MGLang model2lang;
    int[] uni_counts;
    int[][] models_chrs_counts;
    float[] lprobs;
    int[] lp_counts;
    int[] ilprobs;
    int[] ilp_counts;
    float[] out_lprobs;
    int[] uilprobs;
    int[] uilp_counts;
    float[] out_ulprobs;
    int tot_nb_lprobs;
    int utf8_state;
    int utf8_flag;
    int bom_flag;
    int bompos;

    MGroupEval(ProfileData profileData) {
        int n;
        this.ulp_acs = new MGEvUlpAcs(profileData);
        this.nb_models = profileData.nb_models;
        String[] stringArray = new String[this.nb_models];
        this.nb_facts = profileData.nb_facts;
        this.nb_mods_facts = this.nb_models + this.nb_facts;
        this.lprobs = new float[this.nb_mods_facts];
        this.lp_counts = new int[this.nb_mods_facts];
        this.ilprobs = new int[this.nb_mods_facts];
        this.ilp_counts = new int[this.nb_mods_facts];
        this.out_lprobs = new float[this.nb_mods_facts];
        this.uilprobs = new int[this.nb_mods_facts];
        this.uilp_counts = new int[this.nb_mods_facts];
        this.out_ulprobs = new float[this.nb_mods_facts];
        this.models_chrs_counts = new int[this.nb_mods_facts][256];
        this.uni_counts = new int[256];
        int n2 = 0;
        while (n2 < this.nb_models) {
            stringArray[n2] = new String(profileData.models[n2].name);
            ++n2;
        }
        this.model2lang = new MGLang(stringArray, this.nb_models);
        this.tot_nb_lprobs = 0;
        this.utf8_state = 1;
        this.utf8_flag = 1;
        this.bompos = 0;
        this.bom_flag = 0;
        int n3 = 0;
        while (n3 < 256) {
            int n4 = this.ulp_acs.tlens[n3];
            MgeUAElem[] mgeUAElemArray = this.ulp_acs.tables[n3];
            this.uni_counts[n3] = 0;
            n = 0;
            while (n < n4) {
                this.models_chrs_counts[mgeUAElemArray[n].model][n3] = 0;
                this.models_chrs_counts[mgeUAElemArray[n].fact][n3] = 0;
                ++n;
            }
            ++n3;
        }
        n = 0;
        while (n < this.nb_mods_facts) {
            this.lprobs[n] = 0.0f;
            this.lp_counts[n] = 0;
            this.ilprobs[n] = 0;
            this.ilp_counts[n] = 0;
            ++n;
        }
    }

    void verifyutf8(byte by) {
        int n = by & 0xFF;
        if (this.bompos < 3) {
            switch (this.bompos) {
                case 0: {
                    if (n == 239) {
                        this.setbomFlag(1);
                    }
                    if (n == 254) {
                        this.setbomFlag(2);
                    }
                    if (n != 255) break;
                    this.setbomFlag(4);
                    break;
                }
                case 1: {
                    if (n != 187) {
                        this.clearbomFlag(1);
                    }
                    if (n != 255) {
                        this.clearbomFlag(2);
                    }
                    if (n == 254) break;
                    this.clearbomFlag(4);
                    break;
                }
                case 2: {
                    if (n == 191) break;
                    this.clearbomFlag(1);
                    break;
                }
            }
            ++this.bompos;
        }
        if (!this.isSetutf8Flag(1)) {
            return;
        }
        switch (this.utf8_state) {
            case 1: {
                if (n >= 0 && n <= 127) break;
                if (n >= 194 && n <= 223) {
                    this.utf8_state = 2;
                    break;
                }
                if (n >= 224 && n <= 239) {
                    this.utf8_state = 3;
                    break;
                }
                if (n >= 240 && n <= 244) {
                    this.utf8_state = 4;
                    this.setutf8Flag(2);
                    break;
                }
                this.clearutf8Flag(1);
                break;
            }
            case 2: {
                if (n >= 128 && n <= 191) {
                    this.utf8_state = 1;
                    break;
                }
                this.clearutf8Flag(1);
                break;
            }
            case 3: {
                if (n >= 128 && n <= 191) {
                    this.utf8_state = 2;
                    break;
                }
                this.clearutf8Flag(1);
                break;
            }
            case 4: {
                if (n >= 128 && n <= 191) {
                    this.utf8_state = 3;
                    break;
                }
                this.clearutf8Flag(1);
                break;
            }
            default: {
                this.clearutf8Flag(1);
            }
        }
    }

    void chk_ucs2(byte[] byArray, int n) {
        boolean bl = true;
        if (this.isSetutf8Flag(4)) {
            return;
        }
        int n2 = 0;
        while (n2 < n) {
            bl ^= true;
            if (byArray[n2] == 0) {
                if (bl & true) {
                    this.setutf8Flag(4);
                } else {
                    this.clearutf8Flag(4);
                }
                return;
            }
            ++n2;
        }
    }

    int promote_demote(int n) {
        switch (n) {
            case 871: {
                if (this.chk_ascii()) {
                    return 1;
                }
                if (!this.isSetutf8Flag(1) || !this.isSetutf8Flag(2)) break;
                return 873;
            }
            case 178: {
                if (this.chk_ascii()) {
                    return 1;
                }
                if (this.chk_codepoints(MS1252)) break;
                if (this.chk_codepoints(ISOP15)) {
                    return 46;
                }
                return 31;
            }
            case 32: {
                if (!this.chk_codepoints(MS1250)) break;
                return 170;
            }
            case 35: {
                if (!this.chk_codepoints(MS1251)) break;
                return 171;
            }
            case 37: {
                if (!this.chk_codepoints(MS1253)) break;
                return 174;
            }
            case 39: {
                if (!this.chk_codepoints(MS1254)) break;
                return 177;
            }
            case 38: {
                if (!this.chk_codepoints(MS1255)) break;
                return 175;
            }
            case 36: {
                if (!this.chk_codepoints(MS1256)) break;
                return 560;
            }
            case 840: {
                if (!this.chk_codepoints(KO949)) break;
                return 846;
            }
            case 850: {
                if (!this.chk_codepoints(GBK)) break;
                return 852;
            }
        }
        return n;
    }

    boolean chk_codepoints(byte[] byArray) {
        int n = 0;
        while (n < byArray.length) {
            if (this.uni_counts[byArray[n] & 0xFF] > 0) {
                return true;
            }
            ++n;
        }
        return false;
    }

    boolean chk_ascii() {
        int n = 128;
        while (n < 256) {
            if (this.uni_counts[n] > 0) {
                return false;
            }
            ++n;
        }
        return true;
    }

    boolean isAL16UTF16() {
        return this.isSetutf8Flag(4);
    }

    void setutf8Flag(int n) {
        this.utf8_flag |= n;
    }

    void clearutf8Flag(int n) {
        this.utf8_flag &= 65535 - n;
    }

    boolean isSetutf8Flag(int n) {
        return (this.utf8_flag & n) != 0;
    }

    void setbomFlag(int n) {
        this.bom_flag |= n;
    }

    void clearbomFlag(int n) {
        this.bom_flag &= 65535 - n;
    }

    boolean isSetbomFlag(int n) {
        return (this.bom_flag & n) != 0;
    }

    void filter_utf8(ProfileData profileData) {
        if (this.isSetutf8Flag(1) && this.bom_flag == 0) {
            return;
        }
        if (this.bom_flag != 0) {
            String string = new String();
            if (this.isSetbomFlag(4)) {
                string = "al16utf16le";
                int n = 0;
                while (n < this.nb_models) {
                    String string2 = String.valueOf(profileData.models[n].name);
                    String string3 = string2.substring(0, 2);
                    String string4 = string2.substring(3);
                    if (!string4.equalsIgnoreCase(string) && (!string4.equalsIgnoreCase("al16utf16") || string3.equalsIgnoreCase("zt") || string3.equalsIgnoreCase("zh") || string3.equalsIgnoreCase("ko") || string3.equalsIgnoreCase("ja"))) {
                        this.out_lprobs[n] = 1000.0f;
                    }
                    ++n;
                }
            } else {
                if (this.isSetbomFlag(1)) {
                    string = "utf8";
                }
                if (this.isSetbomFlag(2)) {
                    string = "al16utf16";
                }
                int n = 0;
                while (n < this.nb_models) {
                    String string5 = String.valueOf(profileData.models[n].name);
                    String string6 = string5.substring(3);
                    if (!string6.equalsIgnoreCase(string)) {
                        this.out_lprobs[n] = 1000.0f;
                    }
                    ++n;
                }
            }
        } else {
            int n = 0;
            while (n < this.nb_models) {
                char[] cArray = profileData.models[n].name;
                if (cArray.length == 7 && cArray[3] == 'U' && cArray[6] == '8') {
                    this.out_lprobs[n] = 1.0E7f;
                }
                ++n;
            }
        }
    }
}

