/*
 * Decompiled with CFR 0.152.
 */
package oracle.i18n.lcsd;

import java.io.IOException;
import java.io.InputStream;
import oracle.i18n.lcsd.LCSDResultSet;
import oracle.i18n.lcsd.Profile;
import oracle.i18n.util.GDKMessage;
import oracle.i18n.util.LocaleMapper;

public class LCSDetector {
    private Profile profile = null;
    private String OraCharSetName = null;
    private String ISOLangName = null;
    private static int PROCESS_BYTE = 1;
    private static int PROCESS_STRING = 2;
    private static int PROCESS_FILESTREAM = 3;
    private static int FLAG_RESET = 0;
    private int process_flag = FLAG_RESET;

    public LCSDetector() {
        try {
            this.profile = Profile.getInstance();
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException(GDKMessage.getMessage((int)6001));
        }
    }

    public LCSDetector(String string) {
        try {
            this.profile = Profile.getInstance(string);
            if (this.profile == null) {
                throw new IllegalArgumentException(GDKMessage.getMessage((int)6001));
            }
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException(GDKMessage.getMessage((int)6001));
        }
    }

    public int setCharacterSetFilter(String string) {
        this.OraCharSetName = LocaleMapper.getOraCharacterSet((int)3, (String)string);
        if (this.OraCharSetName != null) {
            if (this.ISOLangName == null) {
                return 0;
            }
            this.ISOLangName = null;
            this.OraCharSetName = null;
            throw new IllegalArgumentException(GDKMessage.getMessage((int)6004));
        }
        throw new IllegalArgumentException(GDKMessage.getMessage((int)6002));
    }

    public int setLanguageFilter(String string) {
        this.ISOLangName = string;
        if (LocaleMapper.getOraLangFromJavaLang((String)this.ISOLangName) != null || this.ISOLangName.equalsIgnoreCase("ZT") || this.ISOLangName.equalsIgnoreCase("SH") || this.ISOLangName.equalsIgnoreCase("SQ") || this.ISOLangName.equalsIgnoreCase("EU")) {
            if (this.OraCharSetName == null) {
                return 0;
            }
            this.ISOLangName = null;
            this.OraCharSetName = null;
            throw new IllegalArgumentException(GDKMessage.getMessage((int)6004));
        }
        throw new IllegalArgumentException(GDKMessage.getMessage((int)6003));
    }

    public void detect(byte[] byArray) {
        if (this.process_flag == FLAG_RESET) {
            this.process_flag = PROCESS_BYTE;
        } else if (this.process_flag != PROCESS_BYTE) {
            throw new IllegalArgumentException(GDKMessage.getMessage((int)6005));
        }
        this.profile.add(byArray);
    }

    public int detect(byte[] byArray, int n, int n2) {
        if (this.process_flag == FLAG_RESET) {
            this.process_flag = PROCESS_BYTE;
        } else if (this.process_flag != PROCESS_BYTE) {
            throw new IllegalArgumentException(GDKMessage.getMessage((int)6005));
        }
        if (n < 0 || n2 <= 0) {
            return 0;
        }
        int n3 = byArray.length;
        if (n + n2 > n3) {
            n2 = n3 - n;
        }
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        this.profile.add(byArray2);
        if (n + n2 == n3) {
            return -1;
        }
        return n2;
    }

    public void detect(InputStream inputStream) throws IOException {
        if (this.process_flag == FLAG_RESET) {
            this.process_flag = PROCESS_FILESTREAM;
        } else if (this.process_flag != PROCESS_FILESTREAM) {
            throw new IllegalArgumentException(GDKMessage.getMessage((int)6005));
        }
        int n = inputStream.available();
        byte[] byArray = n < 2048 ? new byte[n] : new byte[2048];
        int n2 = inputStream.read(byArray);
        while (n2 != -1) {
            this.profile.add(byArray, n2);
            n2 = inputStream.read(byArray);
        }
    }

    public int detect(InputStream inputStream, int n) throws IOException {
        if (this.process_flag == FLAG_RESET) {
            this.process_flag = PROCESS_FILESTREAM;
        } else if (this.process_flag != PROCESS_FILESTREAM) {
            throw new IllegalArgumentException(GDKMessage.getMessage((int)6005));
        }
        int n2 = inputStream.available();
        if (n2 == 0) {
            return -1;
        }
        if (n2 < n) {
            n = n2;
        }
        if (n < 2048) {
            byte[] byArray = new byte[n];
            inputStream.read(byArray);
            this.profile.add(byArray);
        } else {
            byte[] byArray = new byte[2048];
            int n3 = 0;
            while (true) {
                int n4;
                if (n3 + (n4 = inputStream.read(byArray)) >= n) {
                    this.profile.add(byArray, n - n3);
                    break;
                }
                this.profile.add(byArray, n4);
                n3 += n4;
            }
        }
        return n;
    }

    public void detect(String string) {
        if (this.process_flag == FLAG_RESET) {
            this.process_flag = PROCESS_STRING;
        } else if (this.process_flag != PROCESS_STRING) {
            throw new IllegalArgumentException(GDKMessage.getMessage((int)6005));
        }
        byte[] byArray = this.convertToByteArray(string.toCharArray());
        this.profile.add(byArray);
    }

    public int detect(String string, int n) {
        if (this.process_flag == FLAG_RESET) {
            this.process_flag = PROCESS_STRING;
        } else if (this.process_flag != PROCESS_STRING) {
            throw new IllegalArgumentException(GDKMessage.getMessage((int)6005));
        }
        if (n < string.length()) {
            byte[] byArray = this.convertToByteArray(string.substring(0, n - 1).toCharArray());
            this.profile.add(byArray);
            return n;
        }
        byte[] byArray = this.convertToByteArray(string.toCharArray());
        this.profile.add(byArray);
        return -1;
    }

    public void detect(char[] cArray) {
        if (this.process_flag == FLAG_RESET) {
            this.process_flag = PROCESS_STRING;
        } else if (this.process_flag != PROCESS_STRING) {
            throw new IllegalArgumentException(GDKMessage.getMessage((int)6005));
        }
        byte[] byArray = this.convertToByteArray(cArray);
        this.profile.add(byArray);
    }

    public int detect(char[] cArray, int n, int n2) {
        if (this.process_flag == FLAG_RESET) {
            this.process_flag = PROCESS_STRING;
        } else if (this.process_flag != PROCESS_STRING) {
            throw new IllegalArgumentException(GDKMessage.getMessage((int)6005));
        }
        byte[] byArray = this.convertToByteArray(cArray, n, n2);
        this.profile.add(byArray);
        if (n + n2 >= cArray.length) {
            return -1;
        }
        return n2;
    }

    public LCSDResultSet getResult() {
        return new LCSDResultSet(this.profile, this.ISOLangName, this.OraCharSetName, this.process_flag);
    }

    public void reset() {
        this.ISOLangName = null;
        this.OraCharSetName = null;
        this.process_flag = FLAG_RESET;
        this.profile.reset();
    }

    private byte[] convertToByteArray(char[] cArray) {
        int n = cArray.length;
        byte[] byArray = new byte[n * 2];
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            byArray[2 * n2] = (byte)(c >>> 8);
            byArray[2 * n2 + 1] = (byte)c;
            ++n2;
        }
        return byArray;
    }

    private byte[] convertToByteArray(char[] cArray, int n, int n2) {
        int n3 = cArray.length;
        if (n + n2 > n3) {
            n2 = n3 - n;
        }
        byte[] byArray = new byte[n2 * 2];
        int n4 = 0;
        while (n4 < n2) {
            char c = cArray[n4 + n];
            byArray[2 * n4] = (byte)(c >>> 8);
            byArray[2 * n4 + 1] = (byte)c;
            ++n4;
        }
        return byArray;
    }
}

